package com.elitesland.tw.tw5.server.prd.humanresources.eval.entity;

import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDate;

import org.hibernate.annotations.Where;
import com.elitescloud.boot.model.entity.BaseModel;


/**
 * @author : WWW
 * @date : 2023-11-24
 * @desc : 评价表
 */

@Entity
@Table(name = "prd_evaluate")
@org.hibernate.annotations.Table(appliesTo = "prd_evaluate", comment = "评价表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PrdEvaluateDO extends BaseModel {


    /**
     * 来源id
     */
    @Column(name = "from_id", columnDefinition = "bigint(20) comment '来源id'")
    private Long fromId;

    /**
     * 配置id
     */
    @Column(name = "config_id", columnDefinition = "bigint(20) comment '配置id'")
    private Long configId;

    /**
     * 评价对象名称
     */
    @Column(name = "item_name", columnDefinition = "varchar(255) comment '评价对象名称'")
    private String itemName;

    /**
     * 评价类别
     */
    @Column(name = "cate", columnDefinition = "varchar(255) comment '评价类别'")
    private String cate;

    /**
     * 评价类型
     */
    @Column(name = "type", columnDefinition = "varchar(255) comment '评价类型'")
    private String type;

    /**
     * 项目id
     */
    @Column(name = "pro_id", columnDefinition = "bigint(20) comment '项目id'")
    private Long proId;

    /**
     * 任务id
     */
    @Column(name = "task_id", columnDefinition = "bigint(20) comment '任务id'")
    private Long taskId;

    /**
     * 活动id
     */
    @Column(name = "act_id", columnDefinition = "bigint(20) comment '活动id'")
    private Long actId;

    /**
     * 评价说明
     */
    @Column(name = "eval_desc", columnDefinition = "varchar(255) comment '评价说明'")
    private String evalDesc;

    /**
     * 评价日期
     */
    @Column(name = "eval_date", columnDefinition = "date comment '评价日期'")
    private LocalDate evalDate;

    /**
     * 评价人
     */
    @Column(name = "eval_user", columnDefinition = "varchar(255) comment '评价人'")
    private String evalUser;

    /**
     * 评价人id
     */
    @Column(name = "eval_user_id", columnDefinition = "bigint(20) comment '评价人id'")
    private Long evalUserId;

    /**
     * 被评价人
     */
    @Column(name = "to_eval_user", columnDefinition = "varchar(255) comment '被评价人'")
    private String toEvalUser;

    /**
     * 被评价人id
     */
    @Column(name = "to_eval_user_id", columnDefinition = "bigint(20) comment '被评价人id'")
    private Long toEvalUserId;

    /**
     * 平均分数
     */
    @Column(name = "average_score", columnDefinition = "decimal(20,2) comment '平均分数'")
    private BigDecimal averageScore;


    /**
     * 状态
     */
    @Column(name = "state", columnDefinition = "int(11) comment '状态'")
    private Integer state;
}

