package com.elitesland.tw.tw5.server.prd.humanresources.eval.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluateDtlPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluatePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateDtlQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEvaluateDtlService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEvaluateService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateDtlVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdEvaluateConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.dao.PrdEvaluateDao;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.entity.PrdEvaluateDO;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.repo.PrdEvaluateRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import javax.servlet.http.HttpServletResponse;

import com.elitescloud.boot.exception.BusinessException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.collection.CollectionUtil;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.boot.exception.BusinessException;

import java.util.List;
import java.util.stream.Collectors;


/**
 * @author : WWW
 * @date : 2023-11-24
 * @desc : 评价表Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class PrdEvaluateServiceImpl implements PrdEvaluateService {


    private final PrdEvaluateDao prdEvaluateDao;

    private final PrdEvaluateRepo prdEvaluateRepo;

    private final PrdEvaluateDtlService prdEvaluateDtlService;

    private final CacheUtil cacheUtil;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdEvaluateVO save(PrdEvaluatePayload prdEvaluatePayload) {

        checkData(prdEvaluatePayload);
        if (null == prdEvaluatePayload.getState()) {
            prdEvaluatePayload.setState(1);
        }
        PrdEvaluateDO prdEvaluateDO = new PrdEvaluateDO();
        prdEvaluateDO = PrdEvaluateConvert.INSTANCE.p2d(prdEvaluatePayload);
        prdEvaluateDO.setEvalDate(LocalDate.now());
        // 平均分数
        BigDecimal average = prdEvaluatePayload.getPrdEvaluateDtlPayloadList().stream().map(vo -> ObjectUtils.isEmpty(vo.getScore()) ? new BigDecimal(0) : vo.getScore()).reduce(BigDecimal.ZERO, BigDecimal::add).divide(BigDecimal.valueOf(prdEvaluatePayload.getPrdEvaluateDtlPayloadList().size()), 2, BigDecimal.ROUND_HALF_UP);
        prdEvaluateDO.setAverageScore(average);

        PrdEvaluateDO res = prdEvaluateRepo.save(prdEvaluateDO);

        // 评价明细处理
        for (PrdEvaluateDtlPayload prdEvaluateDtlPayload : prdEvaluatePayload.getPrdEvaluateDtlPayloadList()) {
            prdEvaluateDtlPayload.setEvalId(res.getId());
            prdEvaluateDtlService.save(prdEvaluateDtlPayload);
        }

        return PrdEvaluateConvert.INSTANCE.d2v(res);

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdEvaluateVO update(PrdEvaluatePayload prdEvaluatePayload) {

        Assert.notNull(prdEvaluatePayload.getId(), "id is null");
        PrdEvaluateVO res = save(prdEvaluatePayload);
        return res;

    }


    @Override
    public PrdEvaluateVO get(Long id) {

        if (null == id) {
            return null;
        }
        PrdEvaluateVO res = prdEvaluateDao.get(id);
        if (null != res) {
            // 获取试用期评价明细
            PrdEvaluateDtlQuery prdEvaluateDtlQuery = new PrdEvaluateDtlQuery();
            prdEvaluateDtlQuery.setEvalId(id);
            List<PrdEvaluateDtlVO> list = prdEvaluateDtlService.getList(prdEvaluateDtlQuery);
            res.setPrdEvaluateDtlVOList(list);
        }
        return res;

    }


    @Override
    public PagingVO<PrdEvaluateVO> page(PrdEvaluateQuery prdEvaluateQuery) {

        prdEvaluateQuery.setState(1);
        PagingVO<PrdEvaluateVO> res = prdEvaluateDao.page(prdEvaluateQuery);
        res.getRecords().forEach(x -> {
            x.setTypeDesc(cacheUtil.transferSystemSelection("org:employee:evalClass", x.getType()));
            x.setCateDesc(cacheUtil.transferSystemSelection("org:employee:evalClass", x.getCate()));
        });
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = prdEvaluateDao.del(ids);
        // 删除评论明细
        Long dels = prdEvaluateDtlService.delByEvalIds(ids);
        return res;

    }

    @Override
    public List<PrdEvaluateVO> getList(PrdEvaluateQuery prdEvaluateQuery) {

        prdEvaluateQuery.setState(1);
        List<PrdEvaluateVO> res = prdEvaluateDao.getList(prdEvaluateQuery);
        for (PrdEvaluateVO prdEvaluateVO : res) {
            PrdEvaluateDtlQuery prdEvaluateDtlQuery = new PrdEvaluateDtlQuery();
            prdEvaluateDtlQuery.setEvalId(prdEvaluateVO.getId());
            List<PrdEvaluateDtlVO> list = prdEvaluateDtlService.getList(prdEvaluateDtlQuery);
            prdEvaluateVO.setPrdEvaluateDtlVOList(list);
        }
        return res;

    }


    /**
     * 数据校验
     *
     * @param prdEvaluatePayload
     */
    private void checkData(PrdEvaluatePayload prdEvaluatePayload) {

        if (null == prdEvaluatePayload.getConfigId()) {
            throw new BusinessException("评价配置id不能为空");
        }
        if (StringUtils.isBlank(prdEvaluatePayload.getCate())) {
            throw new BusinessException("评价类别不能为空");
        }
        if (StringUtils.isBlank(prdEvaluatePayload.getType())) {
            throw new BusinessException("评价类型不能为空");
        }
        if (null == prdEvaluatePayload.getFromId()) {
            throw new BusinessException("评价来源id不能为空");
        }

//        if (StringUtils.isBlank(prdEvaluatePayload.getEvalDesc())) {
//            throw new BusinessException("评语不能为空");
//        }
        if (null == prdEvaluatePayload.getEvalUserId()) {
            throw new BusinessException("评价人id不能为空");
        }
        if (StringUtils.isBlank(prdEvaluatePayload.getEvalUser())) {
            throw new BusinessException("评价人名称不能为空");
        }
        if (null == prdEvaluatePayload.getToEvalUserId()) {
            throw new BusinessException("被评价人id不能为空");
        }
        if (StringUtils.isBlank(prdEvaluatePayload.getToEvalUser())) {
            throw new BusinessException("被评价人名称不能为空");
        }
        if (StringUtils.isBlank(prdEvaluatePayload.getItemName())) {
            throw new BusinessException("评价对象名称不能为空");
        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateByCondition(PrdEvaluatePayload prdEvaluatePayload) {
        Assert.notNull(prdEvaluatePayload.getId(), "id不能为空");
        Long res = prdEvaluateDao.update(prdEvaluatePayload);
        return res;
    }

    @Override
    @Transactional
    public Boolean batchSave(List<PrdEvaluatePayload> prdEvaluatePayloadList) {

        for (PrdEvaluatePayload prdEvaluatePayload : prdEvaluatePayloadList) {
            save(prdEvaluatePayload);
        }
        return true;
    }

    @Override
    @Transactional
    public Long updateStateByFormId(PrdEvaluatePayload prdEvaluatePayload) {
        Long res = prdEvaluateDao.updateStateByFormId(prdEvaluatePayload);
        return res;
    }

    @Override
    public List<PrdEvaluateVO> getScoreListByUserId(PrdEvaluateQuery prdEvaluateQuery) {

        List<PrdEvaluateVO> res = prdEvaluateDao.getScoreListByUserId(prdEvaluateQuery);
        return res;
    }


}

