package com.elitesland.tw.tw5.server.prd.humanresources.examination.dao;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamGradePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamGradeQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamGradeVO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.PrdPerformanceExamGradeDO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.QPrdPerformanceExamGradeDO;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.springframework.stereotype.Component;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.querydsl.core.types.Predicate;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;

import java.util.List;

import com.querydsl.core.types.ExpressionUtils;

import java.util.ArrayList;


/**
 * @author : WWW
 * @date : 2023-11-14
 * @desc : 考核结果等级RepoProc
 */

@Component
public class PrdPerformanceExamGradeDao extends BaseRepoProc<PrdPerformanceExamGradeDO> {

    private static final QPrdPerformanceExamGradeDO qPrdPerformanceExamGradeDO = QPrdPerformanceExamGradeDO.prdPerformanceExamGradeDO;


    protected PrdPerformanceExamGradeDao() {

        super(qPrdPerformanceExamGradeDO);

    }


    public PagingVO<PrdPerformanceExamGradeVO> page(PrdPerformanceExamGradeQuery prdPerformanceExamGradeQuery) {

        JPAQuery<PrdPerformanceExamGradeVO> query =
                select(PrdPerformanceExamGradeVO.class)
                        .where(bulidPredicate(prdPerformanceExamGradeQuery));
        prdPerformanceExamGradeQuery.setPaging(query);
        prdPerformanceExamGradeQuery.fillOrders(query, qPrdPerformanceExamGradeDO);
        return PagingVO.<PrdPerformanceExamGradeVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qPrdPerformanceExamGradeDO)
                .set(qPrdPerformanceExamGradeDO.deleteFlag, 1)
                .where(qPrdPerformanceExamGradeDO.id.in(ids))
                .execute();

        return res;

    }


    public PrdPerformanceExamGradeVO get(Long id) {

        PrdPerformanceExamGradeVO prdPerformanceExamGradeVO = select(PrdPerformanceExamGradeVO.class)
                .where(qPrdPerformanceExamGradeDO.id.eq(id))
                .fetchOne();

        return prdPerformanceExamGradeVO;

    }


    public List<PrdPerformanceExamGradeVO> getList(PrdPerformanceExamGradeQuery prdPerformanceExamGradeQuery) {

        List<PrdPerformanceExamGradeVO> res =
                select(PrdPerformanceExamGradeVO.class)
                        .where(bulidPredicate(prdPerformanceExamGradeQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qPrdPerformanceExamGradeDO.examId,
                        qPrdPerformanceExamGradeDO.name,
                        qPrdPerformanceExamGradeDO.scoreRatioStart,
                        qPrdPerformanceExamGradeDO.scoreRatioEnd,
                        qPrdPerformanceExamGradeDO.id,
                        qPrdPerformanceExamGradeDO.createTime,
                        qPrdPerformanceExamGradeDO.remark

                )).from(qPrdPerformanceExamGradeDO);

    }


    private Predicate bulidPredicate(PrdPerformanceExamGradeQuery prdPerformanceExamGradeQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(null != prdPerformanceExamGradeQuery.getExamId(), qPrdPerformanceExamGradeDO.examId, prdPerformanceExamGradeQuery.getExamId())
                .andEq(StringUtils.isNotBlank(prdPerformanceExamGradeQuery.getName()), qPrdPerformanceExamGradeDO.name, prdPerformanceExamGradeQuery.getName())
                .andEq(null != prdPerformanceExamGradeQuery.getScoreRatioStart(), qPrdPerformanceExamGradeDO.scoreRatioStart, prdPerformanceExamGradeQuery.getScoreRatioStart())
                .andEq(null != prdPerformanceExamGradeQuery.getScoreRatioEnd(), qPrdPerformanceExamGradeDO.scoreRatioEnd, prdPerformanceExamGradeQuery.getScoreRatioEnd())
                .build();

        return predicate;

    }


    private List<Predicate> bulidPredicates(PrdPerformanceExamGradeQuery prdPerformanceExamGradeQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 绩效id
        if (null != prdPerformanceExamGradeQuery.getExamId()) {
            predicates.add(qPrdPerformanceExamGradeDO.examId.eq(prdPerformanceExamGradeQuery.getExamId()));
        }
        // 等级名称
        if (StringUtils.isNotEmpty(prdPerformanceExamGradeQuery.getName())) {
            predicates.add(qPrdPerformanceExamGradeDO.name.eq(prdPerformanceExamGradeQuery.getName()));
        }
        // 得分占比开始
        if (null != prdPerformanceExamGradeQuery.getScoreRatioStart()) {
            predicates.add(qPrdPerformanceExamGradeDO.scoreRatioStart.eq(prdPerformanceExamGradeQuery.getScoreRatioStart()));
        }
        // 得分占比结束
        if (null != prdPerformanceExamGradeQuery.getScoreRatioEnd()) {
            predicates.add(qPrdPerformanceExamGradeDO.scoreRatioEnd.eq(prdPerformanceExamGradeQuery.getScoreRatioEnd()));
        }

//      Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicates;
    }


    public Long count(PrdPerformanceExamGradeQuery prdPerformanceExamGradeQuery) {

        long res = select(PrdPerformanceExamGradeVO.class)
                .where(bulidPredicate(prdPerformanceExamGradeQuery))
                .fetchCount();

        return res;


    }

    public Long update(PrdPerformanceExamGradePayload prdPerformanceExamGradePayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qPrdPerformanceExamGradeDO);

        // 绩效id
        if (null != prdPerformanceExamGradePayload.getExamId()) {
            update.set(qPrdPerformanceExamGradeDO.examId, prdPerformanceExamGradePayload.getExamId());
        }
        // 等级名称
        if (StringUtils.isNotEmpty(prdPerformanceExamGradePayload.getName())) {
            update.set(qPrdPerformanceExamGradeDO.name, prdPerformanceExamGradePayload.getName());
        }
        // 得分占比开始
        if (null != prdPerformanceExamGradePayload.getScoreRatioStart()) {
            update.set(qPrdPerformanceExamGradeDO.scoreRatioStart, prdPerformanceExamGradePayload.getScoreRatioStart());
        }
        // 得分占比结束
        if (null != prdPerformanceExamGradePayload.getScoreRatioEnd()) {
            update.set(qPrdPerformanceExamGradeDO.scoreRatioEnd, prdPerformanceExamGradePayload.getScoreRatioEnd());
        }
        long res = update.where(qPrdPerformanceExamGradeDO.id.eq(prdPerformanceExamGradePayload.getId()))
                .execute();
        return res;

    }

    public Long delByExamId(Long id) {
        JPAUpdateClause update = jpaQueryFactory.update(qPrdPerformanceExamGradeDO);
        long res = update.set(qPrdPerformanceExamGradeDO.deleteFlag, 1)
                .where(qPrdPerformanceExamGradeDO.examId.eq(id))
                .execute();
        return res;

    }
}

