package com.elitesland.tw.tw5.server.prd.humanresources.examination.dao;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamResultPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamResultQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamResultVO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.PrdPerformanceExamResultDO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.QPrdPerformanceExamResultDO;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.springframework.stereotype.Component;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.querydsl.core.types.Predicate;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;

import java.util.List;

import com.querydsl.core.types.ExpressionUtils;

import java.util.ArrayList;


/**
 * @author : WWW
 * @date : 2023-11-15
 * @desc : 绩效考核结果RepoProc
 */

@Component
public class PrdPerformanceExamResultDao extends BaseRepoProc<PrdPerformanceExamResultDO> {

    private static final QPrdPerformanceExamResultDO qPrdPerformanceExamResultDO = QPrdPerformanceExamResultDO.prdPerformanceExamResultDO;


    protected PrdPerformanceExamResultDao() {

        super(qPrdPerformanceExamResultDO);

    }


    public PagingVO<PrdPerformanceExamResultVO> page(PrdPerformanceExamResultQuery prdPerformanceExamResultQuery) {

        JPAQuery<PrdPerformanceExamResultVO> query =
                select(PrdPerformanceExamResultVO.class)
                        .where(bulidPredicate(prdPerformanceExamResultQuery));
        prdPerformanceExamResultQuery.setPaging(query);
        prdPerformanceExamResultQuery.fillOrders(query, qPrdPerformanceExamResultDO);
        return PagingVO.<PrdPerformanceExamResultVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qPrdPerformanceExamResultDO)
                .set(qPrdPerformanceExamResultDO.deleteFlag, 1)
                .where(qPrdPerformanceExamResultDO.id.in(ids))
                .execute();

        return res;

    }


    public PrdPerformanceExamResultVO get(Long id) {

        PrdPerformanceExamResultVO prdPerformanceExamResultVO = select(PrdPerformanceExamResultVO.class)
                .where(qPrdPerformanceExamResultDO.id.eq(id))
                .fetchOne();

        return prdPerformanceExamResultVO;

    }


    public List<PrdPerformanceExamResultVO> getList(PrdPerformanceExamResultQuery prdPerformanceExamResultQuery) {

        List<PrdPerformanceExamResultVO> res =
                select(PrdPerformanceExamResultVO.class)
                        .where(bulidPredicate(prdPerformanceExamResultQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qPrdPerformanceExamResultDO.examId,
                        qPrdPerformanceExamResultDO.examName,
                        qPrdPerformanceExamResultDO.examStartPeriod,
                        qPrdPerformanceExamResultDO.examEndPeriod,
                        qPrdPerformanceExamResultDO.empId,
                        qPrdPerformanceExamResultDO.empName,
                        qPrdPerformanceExamResultDO.userId,
                        qPrdPerformanceExamResultDO.resType,
                        qPrdPerformanceExamResultDO.baseBuId,
                        qPrdPerformanceExamResultDO.baseBuName,
                        qPrdPerformanceExamResultDO.coopType,
                        qPrdPerformanceExamResultDO.examDesc,
                        qPrdPerformanceExamResultDO.examCreatUserId,
                        qPrdPerformanceExamResultDO.examCreatUser,
                        qPrdPerformanceExamResultDO.examCreatTime,
                        qPrdPerformanceExamResultDO.scoreRes,
                        qPrdPerformanceExamResultDO.gradeRes,
                        qPrdPerformanceExamResultDO.scoreFinalDesc,
                        qPrdPerformanceExamResultDO.state,
                        qPrdPerformanceExamResultDO.flowDocNo,
                        qPrdPerformanceExamResultDO.id,
                        qPrdPerformanceExamResultDO.scoreMax,
                        qPrdPerformanceExamResultDO.scoreMin,
                        qPrdPerformanceExamResultDO.createTime,
                        qPrdPerformanceExamResultDO.remark

                )).from(qPrdPerformanceExamResultDO);

    }


    private Predicate bulidPredicate(PrdPerformanceExamResultQuery prdPerformanceExamResultQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(null != prdPerformanceExamResultQuery.getExamId(), qPrdPerformanceExamResultDO.examId, prdPerformanceExamResultQuery.getExamId())
                .andLike(StringUtils.isNotBlank(prdPerformanceExamResultQuery.getExamName()), qPrdPerformanceExamResultDO.examName, prdPerformanceExamResultQuery.getExamName())
                .andEq(null != prdPerformanceExamResultQuery.getExamStartPeriod(), qPrdPerformanceExamResultDO.examStartPeriod, prdPerformanceExamResultQuery.getExamStartPeriod())
                .andEq(null != prdPerformanceExamResultQuery.getExamEndPeriod(), qPrdPerformanceExamResultDO.examEndPeriod, prdPerformanceExamResultQuery.getExamEndPeriod())
                .andEq(null != prdPerformanceExamResultQuery.getEmpId(), qPrdPerformanceExamResultDO.empId, prdPerformanceExamResultQuery.getEmpId())
                .andEq(StringUtils.isNotBlank(prdPerformanceExamResultQuery.getEmpName()), qPrdPerformanceExamResultDO.empName, prdPerformanceExamResultQuery.getEmpName())
                .andEq(null != prdPerformanceExamResultQuery.getUserId(), qPrdPerformanceExamResultDO.userId, prdPerformanceExamResultQuery.getUserId())
                .andEq(StringUtils.isNotBlank(prdPerformanceExamResultQuery.getResType()), qPrdPerformanceExamResultDO.resType, prdPerformanceExamResultQuery.getResType())
                .andEq(null != prdPerformanceExamResultQuery.getBaseBuId(), qPrdPerformanceExamResultDO.baseBuId, prdPerformanceExamResultQuery.getBaseBuId())
                .andEq(StringUtils.isNotBlank(prdPerformanceExamResultQuery.getCoopType()), qPrdPerformanceExamResultDO.coopType, prdPerformanceExamResultQuery.getCoopType())
                .andEq(StringUtils.isNotBlank(prdPerformanceExamResultQuery.getExamDesc()), qPrdPerformanceExamResultDO.examDesc, prdPerformanceExamResultQuery.getExamDesc())
                .andEq(null != prdPerformanceExamResultQuery.getExamCreatUserId(), qPrdPerformanceExamResultDO.examCreatUserId, prdPerformanceExamResultQuery.getExamCreatUserId())
                .andEq(StringUtils.isNotBlank(prdPerformanceExamResultQuery.getExamCreatUser()), qPrdPerformanceExamResultDO.examCreatUser, prdPerformanceExamResultQuery.getExamCreatUser())
                .andEq(null != prdPerformanceExamResultQuery.getExamCreatTime(), qPrdPerformanceExamResultDO.examCreatTime, prdPerformanceExamResultQuery.getExamCreatTime())
                .andEq(null !=(prdPerformanceExamResultQuery.getScoreRes()), qPrdPerformanceExamResultDO.scoreRes, prdPerformanceExamResultQuery.getScoreRes())
                .andGoe(null !=(prdPerformanceExamResultQuery.getScoreResStart()), qPrdPerformanceExamResultDO.scoreRes, prdPerformanceExamResultQuery.getScoreResStart())
                .andLoe(null !=(prdPerformanceExamResultQuery.getScoreResEnd()), qPrdPerformanceExamResultDO.scoreRes, prdPerformanceExamResultQuery.getScoreResEnd())
                .andEq(StringUtils.isNotBlank(prdPerformanceExamResultQuery.getGradeRes()), qPrdPerformanceExamResultDO.gradeRes, prdPerformanceExamResultQuery.getGradeRes())
                .andEq(StringUtils.isNotBlank(prdPerformanceExamResultQuery.getScoreFinalDesc()), qPrdPerformanceExamResultDO.scoreFinalDesc, prdPerformanceExamResultQuery.getScoreFinalDesc())
                .andEq(StringUtils.isNotBlank(prdPerformanceExamResultQuery.getState()), qPrdPerformanceExamResultDO.state, prdPerformanceExamResultQuery.getState())
                .andEq(StringUtils.isNotBlank(prdPerformanceExamResultQuery.getFlowDocNo()), qPrdPerformanceExamResultDO.flowDocNo, prdPerformanceExamResultQuery.getFlowDocNo())
                .build();


        return predicate;

    }


    private List<Predicate> bulidPredicates(PrdPerformanceExamResultQuery prdPerformanceExamResultQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 绩效考核id
        if (null != prdPerformanceExamResultQuery.getExamId()) {
            predicates.add(qPrdPerformanceExamResultDO.examId.eq(prdPerformanceExamResultQuery.getExamId()));
        }
        // 考核名称
        if (StringUtils.isNotEmpty(prdPerformanceExamResultQuery.getExamName())) {
            predicates.add(qPrdPerformanceExamResultDO.examName.eq(prdPerformanceExamResultQuery.getExamName()));
        }
        // 考核开始时间
        if (null != prdPerformanceExamResultQuery.getExamStartPeriod()) {
            predicates.add(qPrdPerformanceExamResultDO.examStartPeriod.eq(prdPerformanceExamResultQuery.getExamStartPeriod()));
        }
        // 考核结束时间
        if (null != prdPerformanceExamResultQuery.getExamEndPeriod()) {
            predicates.add(qPrdPerformanceExamResultDO.examEndPeriod.eq(prdPerformanceExamResultQuery.getExamEndPeriod()));
        }
        // 考核员工资源id
        if (null != prdPerformanceExamResultQuery.getEmpId()) {
            predicates.add(qPrdPerformanceExamResultDO.empId.eq(prdPerformanceExamResultQuery.getEmpId()));
        }
        // 考核员工资源名称
        if (StringUtils.isNotEmpty(prdPerformanceExamResultQuery.getEmpName())) {
            predicates.add(qPrdPerformanceExamResultDO.empName.eq(prdPerformanceExamResultQuery.getEmpName()));
        }
        // 考核用户id
        if (null != prdPerformanceExamResultQuery.getUserId()) {
            predicates.add(qPrdPerformanceExamResultDO.userId.eq(prdPerformanceExamResultQuery.getUserId()));
        }
        // 资源类型
        if (StringUtils.isNotEmpty(prdPerformanceExamResultQuery.getResType())) {
            predicates.add(qPrdPerformanceExamResultDO.resType.eq(prdPerformanceExamResultQuery.getResType()));
        }
        // BaseBu
        if (null != prdPerformanceExamResultQuery.getBaseBuId()) {
            predicates.add(qPrdPerformanceExamResultDO.baseBuId.eq(prdPerformanceExamResultQuery.getBaseBuId()));
        }
        // 合作方式
        if (StringUtils.isNotEmpty(prdPerformanceExamResultQuery.getCoopType())) {
            predicates.add(qPrdPerformanceExamResultDO.coopType.eq(prdPerformanceExamResultQuery.getCoopType()));
        }
        // 考核说明
        if (StringUtils.isNotEmpty(prdPerformanceExamResultQuery.getExamDesc())) {
            predicates.add(qPrdPerformanceExamResultDO.examDesc.eq(prdPerformanceExamResultQuery.getExamDesc()));
        }
        // 考核发起人id
        if (null != prdPerformanceExamResultQuery.getExamCreatUserId()) {
            predicates.add(qPrdPerformanceExamResultDO.examCreatUserId.eq(prdPerformanceExamResultQuery.getExamCreatUserId()));
        }
        // 考核发起人
        if (StringUtils.isNotEmpty(prdPerformanceExamResultQuery.getExamCreatUser())) {
            predicates.add(qPrdPerformanceExamResultDO.examCreatUser.eq(prdPerformanceExamResultQuery.getExamCreatUser()));
        }
        // 考核发起时间
        if (null != prdPerformanceExamResultQuery.getExamCreatTime()) {
            predicates.add(qPrdPerformanceExamResultDO.examCreatTime.eq(prdPerformanceExamResultQuery.getExamCreatTime()));
        }
        // 评分结果
        if (null !=(prdPerformanceExamResultQuery.getScoreRes())) {
            predicates.add(qPrdPerformanceExamResultDO.scoreRes.eq(prdPerformanceExamResultQuery.getScoreRes()));
        }
        // 等级结果
        if (StringUtils.isNotEmpty(prdPerformanceExamResultQuery.getGradeRes())) {
            predicates.add(qPrdPerformanceExamResultDO.gradeRes.eq(prdPerformanceExamResultQuery.getGradeRes()));
        }
        // 最终评分说明
        if (StringUtils.isNotEmpty(prdPerformanceExamResultQuery.getScoreFinalDesc())) {
            predicates.add(qPrdPerformanceExamResultDO.scoreFinalDesc.eq(prdPerformanceExamResultQuery.getScoreFinalDesc()));
        }
        // 状态
        if (StringUtils.isNotEmpty(prdPerformanceExamResultQuery.getState())) {
            predicates.add(qPrdPerformanceExamResultDO.state.eq(prdPerformanceExamResultQuery.getState()));
        }
        // 流程编号
        if (StringUtils.isNotEmpty(prdPerformanceExamResultQuery.getFlowDocNo())) {
            predicates.add(qPrdPerformanceExamResultDO.flowDocNo.eq(prdPerformanceExamResultQuery.getFlowDocNo()));
        }

//      Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicates;
    }


    public Long count(PrdPerformanceExamResultQuery prdPerformanceExamResultQuery) {

        long res = select(PrdPerformanceExamResultVO.class)
                .where(bulidPredicate(prdPerformanceExamResultQuery))
                .fetchCount();

        return res;


    }

    public Long update(PrdPerformanceExamResultPayload prdPerformanceExamResultPayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qPrdPerformanceExamResultDO);

        // 绩效考核id
        if (null != prdPerformanceExamResultPayload.getExamId()) {
            update.set(qPrdPerformanceExamResultDO.examId, prdPerformanceExamResultPayload.getExamId());
        }
        // 考核名称
        if (StringUtils.isNotEmpty(prdPerformanceExamResultPayload.getExamName())) {
            update.set(qPrdPerformanceExamResultDO.examName, prdPerformanceExamResultPayload.getExamName());
        }
        // 考核开始时间
        if (null != prdPerformanceExamResultPayload.getExamStartPeriod()) {
            update.set(qPrdPerformanceExamResultDO.examStartPeriod, prdPerformanceExamResultPayload.getExamStartPeriod());
        }
        // 考核结束时间
        if (null != prdPerformanceExamResultPayload.getExamEndPeriod()) {
            update.set(qPrdPerformanceExamResultDO.examEndPeriod, prdPerformanceExamResultPayload.getExamEndPeriod());
        }
        // 考核员工资源id
        if (null != prdPerformanceExamResultPayload.getEmpId()) {
            update.set(qPrdPerformanceExamResultDO.empId, prdPerformanceExamResultPayload.getEmpId());
        }
        // 考核员工资源名称
        if (StringUtils.isNotEmpty(prdPerformanceExamResultPayload.getEmpName())) {
            update.set(qPrdPerformanceExamResultDO.empName, prdPerformanceExamResultPayload.getEmpName());
        }
        // 考核用户id
        if (null != prdPerformanceExamResultPayload.getUserId()) {
            update.set(qPrdPerformanceExamResultDO.userId, prdPerformanceExamResultPayload.getUserId());
        }
        // 资源类型
        if (StringUtils.isNotEmpty(prdPerformanceExamResultPayload.getResType())) {
            update.set(qPrdPerformanceExamResultDO.resType, prdPerformanceExamResultPayload.getResType());
        }
        // BaseBu
        if (null != prdPerformanceExamResultPayload.getBaseBuId()) {
            update.set(qPrdPerformanceExamResultDO.baseBuId, prdPerformanceExamResultPayload.getBaseBuId());
        }
        // 合作方式
        if (StringUtils.isNotEmpty(prdPerformanceExamResultPayload.getCoopType())) {
            update.set(qPrdPerformanceExamResultDO.coopType, prdPerformanceExamResultPayload.getCoopType());
        }
        // 考核说明
        if (StringUtils.isNotEmpty(prdPerformanceExamResultPayload.getExamDesc())) {
            update.set(qPrdPerformanceExamResultDO.examDesc, prdPerformanceExamResultPayload.getExamDesc());
        }
        // 考核发起人id
        if (null != prdPerformanceExamResultPayload.getExamCreatUserId()) {
            update.set(qPrdPerformanceExamResultDO.examCreatUserId, prdPerformanceExamResultPayload.getExamCreatUserId());
        }
        // 考核发起人
        if (StringUtils.isNotEmpty(prdPerformanceExamResultPayload.getExamCreatUser())) {
            update.set(qPrdPerformanceExamResultDO.examCreatUser, prdPerformanceExamResultPayload.getExamCreatUser());
        }
        // 考核发起时间
        if (null != prdPerformanceExamResultPayload.getExamCreatTime()) {
            update.set(qPrdPerformanceExamResultDO.examCreatTime, prdPerformanceExamResultPayload.getExamCreatTime());
        }
        // 评分结果
        if (null != (prdPerformanceExamResultPayload.getScoreRes())) {
            update.set(qPrdPerformanceExamResultDO.scoreRes, prdPerformanceExamResultPayload.getScoreRes());
        }
        // 等级结果
        if (StringUtils.isNotEmpty(prdPerformanceExamResultPayload.getGradeRes())) {
            update.set(qPrdPerformanceExamResultDO.gradeRes, prdPerformanceExamResultPayload.getGradeRes());
        }
        // 最终评分说明
        if (StringUtils.isNotEmpty(prdPerformanceExamResultPayload.getScoreFinalDesc())) {
            update.set(qPrdPerformanceExamResultDO.scoreFinalDesc, prdPerformanceExamResultPayload.getScoreFinalDesc());
        }
        // 状态
        if (StringUtils.isNotEmpty(prdPerformanceExamResultPayload.getState())) {
            update.set(qPrdPerformanceExamResultDO.state, prdPerformanceExamResultPayload.getState());
        }
        // 流程编号
        if (StringUtils.isNotEmpty(prdPerformanceExamResultPayload.getFlowDocNo())) {
            update.set(qPrdPerformanceExamResultDO.flowDocNo, prdPerformanceExamResultPayload.getFlowDocNo());
        }
        // 工作流程
        if (StringUtils.isNotEmpty(prdPerformanceExamResultPayload.getProcInstId())) {
            update.set(qPrdPerformanceExamResultDO.procInstId, prdPerformanceExamResultPayload.getProcInstId());
        }
        if (null != (prdPerformanceExamResultPayload.getProcInstStatus())) {
            update.set(qPrdPerformanceExamResultDO.procInstStatus, prdPerformanceExamResultPayload.getProcInstStatus());
        }

        long res = update.where(qPrdPerformanceExamResultDO.id.eq(prdPerformanceExamResultPayload.getId()))
                .execute();
        return res;

    }

    public Long delByRangeIds(List<Long> ids) {
        long res = jpaQueryFactory.update(qPrdPerformanceExamResultDO)
                .set(qPrdPerformanceExamResultDO.deleteFlag, 1)
                .where(qPrdPerformanceExamResultDO.rangeId.in(ids))
                .execute();
        return res;
    }
}

