package com.elitesland.tw.tw5.server.prd.humanresources.resource.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.ResWithdrawApplyPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.ResWithdrawApplyQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResWithdrawApplyVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.QResWithdrawApplyDO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.ResWithdrawApplyDO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.repo.ResWithdrawApplyRepo;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.QPurchaseAgreementDO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.QPurchaseAgreementResDO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.QPurchasePaymentDO;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;

@Repository
@RequiredArgsConstructor
public class ResWithdrawApplyDAO {

    private final JPAQueryFactory jpaQueryFactory;

    private final ResWithdrawApplyRepo repo;

    private final QResWithdrawApplyDO qResWithdrawApplyDO = QResWithdrawApplyDO.resWithdrawApplyDO;

    private final QPrdOrgEmployeeDO qPrdOrgEmployeeDO = QPrdOrgEmployeeDO.prdOrgEmployeeDO;

    private final QPurchaseAgreementResDO qPurchaseAgreementResDO = QPurchaseAgreementResDO.purchaseAgreementResDO;

    private final QPurchaseAgreementDO qPurchaseAgreementDO = QPurchaseAgreementDO.purchaseAgreementDO;

    private final QPurchasePaymentDO qPurchasePaymentDO = QPurchasePaymentDO.purchasePaymentDO;

    public ResWithdrawApplyDO save(ResWithdrawApplyDO resWithdrawApplyDO) {
        return repo.save(resWithdrawApplyDO);
    }

    public void updatePrco(ResWithdrawApplyPayload payload) {

        JPAUpdateClause update = jpaQueryFactory.update(qResWithdrawApplyDO)
                .where(qResWithdrawApplyDO.id.eq(payload.getId()));

        if (payload.getProcInstId() != null) {
            update.set(qResWithdrawApplyDO.procInstId, payload.getProcInstId());
        }
        if (payload.getProcInstStatus() != null) {
            update.set(qResWithdrawApplyDO.procInstStatus, payload.getProcInstStatus());
        }
        if (payload.getApprovedTime() != null) {
            update.set(qResWithdrawApplyDO.approvedTime, payload.getApprovedTime());
        }
        if (payload.getDeleteFlag() != null) {
            update.set(qResWithdrawApplyDO.deleteFlag, payload.getDeleteFlag());
        }
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qResWithdrawApplyDO.procInstStatus);
            }
            if (nullFields.contains("procInstId")) {
                update.setNull(qResWithdrawApplyDO.procInstId);
            }
        }

        // 执行修改
        update.execute();
    }

    public ResWithdrawApplyDO findByProcId(String procId) {
        return repo.findByProcInstId(procId);
    }

    public ResWithdrawApplyDO findById(Long id) {
        Optional<ResWithdrawApplyDO> applyDO = repo.findById(id);
        return applyDO.orElse(null);
    }

    public PagingVO<ResWithdrawApplyVO> queryPaging(ResWithdrawApplyQuery query) {
        JPAQuery<ResWithdrawApplyVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<ResWithdrawApplyVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<ResWithdrawApplyVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    private JPAQuery<ResWithdrawApplyVO> getJpaQueryWhere(ResWithdrawApplyQuery query) {
        JPAQuery<ResWithdrawApplyVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qResWithdrawApplyDO.deleteFlag.eq(0));

        if (!ObjectUtils.isEmpty(query.getWithdrawNo())) {
            jpaQuery.where(qResWithdrawApplyDO.withdrawNo.eq(query.getWithdrawNo()));
        }
        if (!ObjectUtils.isEmpty(query.getApplyUserId())) {
            jpaQuery.where(qResWithdrawApplyDO.applyUserId.eq((query.getApplyUserId())));
        }
        if (!ObjectUtils.isEmpty(query.getApplyUserIds())) {
            jpaQuery.where(qResWithdrawApplyDO.applyUserId.in(query.getApplyUserIds()));
            jpaQuery.where(qResWithdrawApplyDO.procInstStatus.eq(ProcInstStatus.APPROVED));
            if (ObjectUtils.isEmpty(query.getWithdrawPayStatus())) {
                jpaQuery.where(qResWithdrawApplyDO.withdrawPayStatus.isNull());
            } else {
                jpaQuery.where(qResWithdrawApplyDO.withdrawPayStatus.in(query.getWithdrawPayStatus()));
            }
        }
        if (!ObjectUtils.isEmpty(query.getResType())) {
            jpaQuery.where(qResWithdrawApplyDO.resType.eq(query.getResType()));
        }
        if (!ObjectUtils.isEmpty(query.getProcInstStatus())) {
            jpaQuery.where(qResWithdrawApplyDO.procInstStatus.eq(query.getProcInstStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getApplyDateStart()) && !ObjectUtils.isEmpty(query.getApplyDateEnd())) {
            jpaQuery.where(qResWithdrawApplyDO.createTime.between(query.getApplyDateStart().atTime(0, 0, 0), query.getApplyDateEnd().atTime(0, 0, 0)));
        }
        if (!ObjectUtils.isEmpty(query.getCooperationMode())) {
            jpaQuery.where(qPrdOrgEmployeeDO.cooperationMode.eq(query.getCooperationMode()));
        }
        if (!ObjectUtils.isEmpty(query.getDocNo())) {
            jpaQuery.where(qPurchasePaymentDO.docNo.eq(query.getDocNo()));
        }
        if (!ObjectUtils.isEmpty(query.getWithdrawEqva())) {
            jpaQuery.where(qResWithdrawApplyDO.withdrawEqva.eq(query.getWithdrawEqva()));
        }
        if (!ObjectUtils.isEmpty(query.getWithdrawAmt())) {
            jpaQuery.where(qResWithdrawApplyDO.withdrawAmt.eq(query.getWithdrawAmt()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qResWithdrawApplyDO._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qResWithdrawApplyDO, query.getOrders()));
        return jpaQuery;
    }

    private JPAQuery<ResWithdrawApplyVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(ResWithdrawApplyVO.class,
                        qResWithdrawApplyDO.id,
                        qResWithdrawApplyDO.withdrawNo,
//                        qResWithdrawApplyDO.applyUserName,
                        qResWithdrawApplyDO.applyUserId,
                        qResWithdrawApplyDO.procInstStatus,
                        qResWithdrawApplyDO.createTime,
                        qResWithdrawApplyDO.resType,
                        qResWithdrawApplyDO.withdrawEqva,
                        qResWithdrawApplyDO.withdrawAmt,
                        qResWithdrawApplyDO.adjWithdrawAmt,
                        qResWithdrawApplyDO.withdrawPayStatus,
                        qPrdOrgEmployeeDO.cooperationMode,
                        qResWithdrawApplyDO.paymentApplyId,
                        qPurchasePaymentDO.paymentNo.as("paymentApplyNo"),
                        qPurchasePaymentDO.paymentApplicationType,
                        qPurchasePaymentDO.docNo
                )).from(qResWithdrawApplyDO)
                .leftJoin(qPrdOrgEmployeeDO).on(qPrdOrgEmployeeDO.userId.eq(qResWithdrawApplyDO.applyUserId))
                .leftJoin(qPurchasePaymentDO).on(qResWithdrawApplyDO.paymentApplyId.eq(qPurchasePaymentDO.id));

    }

    /**
     * 根据采购协议编号查询提现申请
     *
     * @param agreementNo 采购协议编号
     * @return 提现申请VO
     */
    public List<ResWithdrawApplyVO> findWithdrawByAgreementNo(String agreementNo) {
        JPAQuery<ResWithdrawApplyVO> jpaQuery = jpaQueryFactory.selectDistinct(Projections.bean(ResWithdrawApplyVO.class,
                        // 提现申请Id
                        qResWithdrawApplyDO.id,
                        // 提现申请单编号
                        qResWithdrawApplyDO.withdrawNo,
                        // 付款申请单Id
                        qResWithdrawApplyDO.paymentApplyId,
                        // 申请人
                        qResWithdrawApplyDO.applyUserId,
                        // 申请人
                        //qResWithdrawApplyDO.applyUserName,
                        // 申请日期
                        qResWithdrawApplyDO.createTime,
                        // 合作方式
                        qPrdOrgEmployeeDO.cooperationMode,
                        // 提现当量
                        qResWithdrawApplyDO.withdrawEqva,
                        // 提现金额
                        qResWithdrawApplyDO.withdrawAmt,
                        // 调整提现金额
                        qResWithdrawApplyDO.adjWithdrawAmt
                )).from(qResWithdrawApplyDO)
                .leftJoin(qPurchaseAgreementResDO).on(qResWithdrawApplyDO.applyUserId.eq(qPurchaseAgreementResDO.resId))
                .leftJoin(qPrdOrgEmployeeDO).on(qPrdOrgEmployeeDO.userId.eq(qResWithdrawApplyDO.applyUserId))
                .leftJoin(qPurchaseAgreementDO).on(qPurchaseAgreementDO.id.eq(qPurchaseAgreementResDO.documentId))
                .where(qPurchaseAgreementDO.purchaseAgreementNo.eq(agreementNo)
                        .and(qResWithdrawApplyDO.paymentApplyId.isNull())
                        .and(qResWithdrawApplyDO.procInstStatus.eq(ProcInstStatus.APPROVED))
                        .and(qResWithdrawApplyDO.withdrawPayStatus.isNull())
                );
        return jpaQuery.fetch();
    }

    /**
     * 更新提现单的状态以及付款申请单id
     *
     * @param paymentApplyId 付款申请单id
     * @param withdrawIds    提现单ids
     * @param withdrawStatus 提现单状态
     */
    public void updateWithdrawStatusAndPaymentApplyIdByIds(Long paymentApplyId, List<Long> withdrawIds, String withdrawStatus) {
        JPAUpdateClause update = jpaQueryFactory.update(qResWithdrawApplyDO)
                .set(qResWithdrawApplyDO.paymentApplyId, paymentApplyId)
                .set(qResWithdrawApplyDO.withdrawPayStatus, withdrawStatus)
                .where(qResWithdrawApplyDO.id.in(withdrawIds));
        update.execute();
    }

    /**
     * 根据付款申请单id将提现申请单中的数据恢复
     *
     * @param paymentApplyId 付款申请单id
     */
    public void resetWithdrawByPaymentApplyId(Long paymentApplyId) {
        JPAUpdateClause update = jpaQueryFactory.update(qResWithdrawApplyDO)
                .setNull(qResWithdrawApplyDO.paymentApplyId)
                .setNull(qResWithdrawApplyDO.withdrawPayStatus)
                .where(qResWithdrawApplyDO.paymentApplyId.eq(paymentApplyId));
        update.execute();
    }

    /**
     * 修改提现申请单状态
     *
     * @param paymentApplyId 付款申请单id
     * @param withdrawStatus 提现申请单状态
     */
    public void updateWithdrawStatusByPaymentApplyId(Long paymentApplyId, String withdrawStatus) {
        JPAUpdateClause update = jpaQueryFactory.update(qResWithdrawApplyDO)
                .set(qResWithdrawApplyDO.withdrawPayStatus, withdrawStatus)
                .where(qResWithdrawApplyDO.paymentApplyId.eq(paymentApplyId));
        update.execute();
    }

    /**
     * 根据付款申请单id查询提现申请单列表
     *
     * @param paymentApplyId 付款申请单id
     */
    public List<ResWithdrawApplyVO> queryListByPaymentApplyId(Long paymentApplyId) {
        JPAQuery<ResWithdrawApplyVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQuerySelect.where(qResWithdrawApplyDO.paymentApplyId.eq(paymentApplyId));
        return jpaQuerySelect.fetch();
    }

    public BigDecimal getWithdrawEqvaTotal(ResWithdrawApplyQuery query) {
        JPAQuery<BigDecimal> jpaQuery = jpaQueryFactory.select(qResWithdrawApplyDO.withdrawEqva.sum())
                .from(qResWithdrawApplyDO);

        buildWhere(query, jpaQuery);
        return jpaQuery.fetchOne();
    }

    public BigDecimal getWithdrawAmtTotal(ResWithdrawApplyQuery query) {
        JPAQuery<BigDecimal> jpaQuery = jpaQueryFactory.select(qResWithdrawApplyDO.adjWithdrawAmt.sum())
                .from(qResWithdrawApplyDO);

        buildWhere(query, jpaQuery);
        return jpaQuery.fetchOne();
    }

    private void buildWhere(ResWithdrawApplyQuery query, JPAQuery<?> jpaQuery) {
        jpaQuery.where(qResWithdrawApplyDO.deleteFlag.eq(0));

        if (!ObjectUtils.isEmpty(query.getWithdrawNo())) {
            jpaQuery.where(qResWithdrawApplyDO.withdrawNo.eq(query.getWithdrawNo()));
        }
        if (!ObjectUtils.isEmpty(query.getApplyUserId())) {
            jpaQuery.where(qResWithdrawApplyDO.applyUserId.eq((query.getApplyUserId())));
        }
        if (!ObjectUtils.isEmpty(query.getApplyUserIds())) {
            jpaQuery.where(qResWithdrawApplyDO.applyUserId.in(query.getApplyUserIds()));
            jpaQuery.where(qResWithdrawApplyDO.procInstStatus.eq(ProcInstStatus.APPROVED));
            if (ObjectUtils.isEmpty(query.getWithdrawPayStatus())) {
                jpaQuery.where(qResWithdrawApplyDO.withdrawPayStatus.isNull());
            } else {
                jpaQuery.where(qResWithdrawApplyDO.withdrawPayStatus.in(query.getWithdrawPayStatus()));
            }
        }
        if (!ObjectUtils.isEmpty(query.getResType())) {
            jpaQuery.where(qResWithdrawApplyDO.resType.eq(query.getResType()));
        }
        if (!ObjectUtils.isEmpty(query.getProcInstStatus())) {
            jpaQuery.where(qResWithdrawApplyDO.procInstStatus.eq(query.getProcInstStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getApplyDateStart()) && !ObjectUtils.isEmpty(query.getApplyDateEnd())) {
            jpaQuery.where(qResWithdrawApplyDO.createTime.between(query.getApplyDateStart().atTime(0, 0, 0), query.getApplyDateEnd().atTime(0, 0, 0)));
        }
        if (!ObjectUtils.isEmpty(query.getCooperationMode())) {
            jpaQuery.where(qPrdOrgEmployeeDO.cooperationMode.eq(query.getCooperationMode()));
        }
    }

}
