package com.elitesland.tw.tw5.server.prd.humanresources.resource.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.WorkOrderApplyPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.WorkOrderApplyQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.WorkOrderApplyVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.QWorkOrderApplyDO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.WorkOrderApplyDO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.repo.WorkOrderApplyRepo;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.List;
import java.util.Optional;

@Repository
@RequiredArgsConstructor
public class WorkOrderApplyDAO {

    private final WorkOrderApplyRepo workOrderApplyRepo;

    private final JPAQueryFactory jpaQueryFactory;

    private final QWorkOrderApplyDO workOrderApplyDO = QWorkOrderApplyDO.workOrderApplyDO;

    private final QPrdOrgEmployeeDO employeeDO = QPrdOrgEmployeeDO.prdOrgEmployeeDO;


    public WorkOrderApplyDO save(WorkOrderApplyDO workOrderApplyDO) {
        return workOrderApplyRepo.save(workOrderApplyDO);
    }

    @Transactional
    public void updateProcData(WorkOrderApplyPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(workOrderApplyDO)
                .where(workOrderApplyDO.id.eq(payload.getId()));

        if (payload.getProcInstId() != null) {
            update.set(workOrderApplyDO.procInstId, payload.getProcInstId());
        }
        if (payload.getProcInstStatus() != null) {
            update.set(workOrderApplyDO.procInstStatus, payload.getProcInstStatus());
        }
        if (payload.getApprovedTime() != null) {
            update.set(workOrderApplyDO.approvedTime, payload.getApprovedTime());
        }
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("procInstStatus")) {
                update.setNull(workOrderApplyDO.procInstStatus);
            }
            if (nullFields.contains("procInstId")) {
                update.setNull(workOrderApplyDO.procInstId);
            }
        }

        // 执行修改
        update.execute();
    }

    public WorkOrderApplyDO findByProcId(String procId) {
        return workOrderApplyRepo.findByProcInstId(procId);
    }

    public WorkOrderApplyDO queryByKey(Long id) {
        Optional<WorkOrderApplyDO> applyDO = workOrderApplyRepo.findById(id);
        return applyDO.orElse(null);
    }

    public PagingVO<WorkOrderApplyVO> queryPaging(WorkOrderApplyQuery query) {
        JPAQuery<WorkOrderApplyVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<WorkOrderApplyVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<WorkOrderApplyVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    private JPAQuery<WorkOrderApplyVO> getJpaQueryWhere(WorkOrderApplyQuery query) {
        JPAQuery<WorkOrderApplyVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(workOrderApplyDO.deleteFlag.eq(0));

        if (!ObjectUtils.isEmpty(query.getReasonType())) {
            jpaQuery.where(workOrderApplyDO.reasonType.eq(query.getReasonType()));
        }
        if (!ObjectUtils.isEmpty(query.getApplyNo())) {
            jpaQuery.where(workOrderApplyDO.applyNo.eq(query.getApplyNo()));
        }
        if (!ObjectUtils.isEmpty(query.getApplyName())) {
            jpaQuery.where(workOrderApplyDO.applyName.like(SqlUtil.toSqlLikeString(query.getApplyName())));
        }
        if (!ObjectUtils.isEmpty(query.getConsultantName())) {
            jpaQuery.where(workOrderApplyDO.consultantName.like(SqlUtil.toSqlLikeString(query.getConsultantName())));
        }
        if (!ObjectUtils.isEmpty(query.getReasonName())) {
            jpaQuery.where(workOrderApplyDO.reasonName.like(SqlUtil.toSqlLikeString(query.getReasonName())));
        }
        if (!ObjectUtils.isEmpty(query.getApplyResId())) {
            jpaQuery.where(workOrderApplyDO.createUserId.eq(query.getApplyResId()));
        }
//        if (!ObjectUtils.isEmpty(query.getApplyResId())) {
//            jpaQuery.where(workOrderApplyDO.createUserId.eq(query.getApplyResId()));
//        }
        if (!ObjectUtils.isEmpty(query.getReasonId())) {
            jpaQuery.where(workOrderApplyDO.reasonId.eq(query.getReasonId()));
        }
        if (!ObjectUtils.isEmpty(query.getServiceFee())) {
            jpaQuery.where(workOrderApplyDO.serviceFee.eq(query.getServiceFee()));
        }
        if (!ObjectUtils.isEmpty(query.getIsTax())) {
            jpaQuery.where(workOrderApplyDO.isTax.eq(query.getIsTax()));
        }
        if (!ObjectUtils.isEmpty(query.getProcInstStatus())) {
            jpaQuery.where(workOrderApplyDO.procInstStatus.eq(query.getProcInstStatus()));
        }
        // 预计入场日期
        if (!ObjectUtils.isEmpty(query.getExpectedStartDate())) {
            jpaQuery.where(workOrderApplyDO.expectedStartDate.goe(query.getExpectedStartDate()));
        }
        // 预计结束日期
        if (!ObjectUtils.isEmpty(query.getExpectedEndDate())) {
            jpaQuery.where(workOrderApplyDO.expectedEndDate.loe(query.getExpectedEndDate()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, workOrderApplyDO._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(workOrderApplyDO, query.getOrders()));
        return jpaQuery;
    }

    private JPAQuery<WorkOrderApplyVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(WorkOrderApplyVO.class,
                workOrderApplyDO.id,
                workOrderApplyDO.applyNo,
                workOrderApplyDO.applyName,
                workOrderApplyDO.reasonType,
                workOrderApplyDO.reasonId,
                workOrderApplyDO.reasonName,
                workOrderApplyDO.consultantName,
                workOrderApplyDO.settleType,
                workOrderApplyDO.capasetLevelId,
                workOrderApplyDO.capasetLevelName,
                workOrderApplyDO.serviceFee,
                workOrderApplyDO.isTax,
                workOrderApplyDO.expectedStartDate,
                workOrderApplyDO.expectedEndDate,
                workOrderApplyDO.createUserId.as("applyResId"),
//                workOrderApplyDO.creator.as("applyResName"),
                workOrderApplyDO.createTime,
                workOrderApplyDO.procInstStatus

        )).from(workOrderApplyDO);

    }


}
