package com.elitesland.tw.tw5.server.prd.humanresources.resource.service;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.WorkOrderApplyPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.WorkOrderApplyQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdCompositeAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.WorkOrderApplyService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.WorkOrderApplyVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdMessageConfigPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.convert.WorkOrderApplyConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.dao.WorkOrderApplyDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.WorkOrderApplyDO;
import com.elitesland.tw.tw5.server.prd.system.constant.MessageNoticeTypeEnum;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Slf4j
public class WorkOrderApplyServiceImpl extends BaseServiceImpl implements WorkOrderApplyService {

    private final WorkOrderApplyDAO workOrderApplyDAO;

    private final WorkflowUtil workflowUtil;

    private final PmsProjectService pmsProjectService;

    private final CrmOpportunityService crmOpportunityService;

    private final PrdOrgOrganizationService orgOrganizationService;

    private final PrdSystemRoleService prdSystemRoleService;

    private final CacheUtil cacheUtil;

    private final PrdCompositeAbilityService prdCompositeAbilityService;

    private final FileUtil fileUtil;

    private final PrdMessageConfigService messageConfigService;

    private final PrdSystemRoleService roleService;
    @Override
//    @Transactional
    public void submit(WorkOrderApplyPayload payload) {
        WorkOrderApplyDO payDO = WorkOrderApplyConvert.INSTANCE.payloadToDo(payload);
        if (payload.getId() == null) {

            String applyNo = generateSeqNum("WORK_ORDER_APPLY_NO");
            payDO.setApplyNo(applyNo);
            WorkOrderApplyDO workOrderApplyDO = workOrderApplyDAO.save(payDO);

            ProcessInfo processInfo = new ProcessInfo();
            String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();

            HashMap<String, Object> variables = new HashMap<>();

            //项目经理、交付Bu负责人审批
            if (payload.getReasonType().equals("PROJ")) {
                PmsProjectVO projectVO = pmsProjectService.queryByKey(payload.getReasonId());
                Long pmUserId = projectVO.getPmResId();
                Long deliBuId = projectVO.getDeliBuId();
                PrdOrgOrganizationVO orgOrganizationVO = cacheUtil.getOrg(deliBuId);
                Long manageId = orgOrganizationVO.getManageId();
                variables.put("Activity_1w250t6", CollUtil.newArrayList(pmUserId));
                variables.put("Activity_1um2jla", CollUtil.newArrayList(manageId));
            }
            //售前负责人、售前Bu负责人审批
            if (payload.getReasonType().equals("OPPO")) {
                CrmOpportunityVO crmOpportunityVO = crmOpportunityService.queryByKey(payload.getReasonId());
                Long preSaleUserId = crmOpportunityVO.getPreSaleUserId();
                Long preSaleOrgId = crmOpportunityVO.getPreSaleOrgId();
                PrdOrgOrganizationVO orgOrganizationVO = cacheUtil.getOrg(preSaleOrgId);
                Long manageId = orgOrganizationVO.getManageId();
                variables.put("Activity_1w250t6", CollUtil.newArrayList(preSaleUserId));
                variables.put("Activity_1um2jla", CollUtil.newArrayList(manageId));
            }
            //资源总监审批
            List<Long> resDirectors = prdSystemRoleService.queryUserIdByRoleCode(RoleEnum.PLAT_RESOURCE_DIRECTOR.getCode());
            variables.put("Activity_1iqm80n", resDirectors);
            //采购经理
            List<Long> finLeaderIds = prdSystemRoleService.queryUserIdByRoleCode(RoleEnum.PLAT_RESOURCE_PIC.getCode());
            variables.put("Activity_0691hsv", finLeaderIds);
            //外部资源负责人
            List<Long> extResManageId = prdSystemRoleService.queryUserIdByRoleCode(RoleEnum.PLAT_SALARY_MANAGER.getCode());
            variables.put("Activity_1mzy17m", extResManageId);
            //人事专员
            variables.put("Activity_0xokibz", extResManageId);


            //发起流程审批
            processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    ProcDefKey.WORK_ORDER_APPLY.name(),
                    "派工单申请-" + payload.getConsultantName(),
                    workOrderApplyDO.getId() + "",
                    variables)
            );

            //流程启动成功后，回写业务表数据
            payload.setId(workOrderApplyDO.getId());
            payload.setProcInstId(processInfo.getProcInstId());
            payload.setProcInstStatus(processInfo.getProcInstStatus());
            workOrderApplyDAO.updateProcData(payload);
            // 发通知给人事 平台人力资源总监 平台薪酬绩效主管
            String userName = GlobalUtil.getLoginUserName();
            String title = "派工单申请";
            String content = userName+"，发起了派工单申请， 请相关负责人及时查看";
            sendMessage(workOrderApplyDO.getId(),title,content);

        } else {
            workOrderApplyDAO.save(payDO);

        }
    }


    @Override
    public WorkOrderApplyVO queryByProcId(String procId) {
        WorkOrderApplyDO workOrderApplyDO = workOrderApplyDAO.findByProcId(procId);
        if (workOrderApplyDO != null) {
            WorkOrderApplyVO workOrderApplyVO = WorkOrderApplyConvert.INSTANCE.doToVo(workOrderApplyDO);
            workOrderApplyVO.setOrderDatas(fileUtil.getFileDatas(workOrderApplyVO.getOrderCodes()));
            workOrderApplyVO.setResumeDatas(fileUtil.getFileDatas(workOrderApplyVO.getResumeCodes()));
            return workOrderApplyVO;
        }
        return null;
    }

    @Override
    public WorkOrderApplyVO queryByKey(Long id) {
        WorkOrderApplyDO workOrderApplyDO = workOrderApplyDAO.queryByKey(id);
        if (workOrderApplyDO != null) {
            WorkOrderApplyVO workOrderApplyVO = WorkOrderApplyConvert.INSTANCE.doToVo(workOrderApplyDO);
            workOrderApplyVO.setOrderDatas(fileUtil.getFileDatas(workOrderApplyVO.getOrderCodes()));
            workOrderApplyVO.setResumeDatas(fileUtil.getFileDatas(workOrderApplyVO.getResumeCodes()));
            return workOrderApplyVO;
        }
        return null;
    }

    @Override
    public PagingVO<WorkOrderApplyVO> queryPaging(WorkOrderApplyQuery query) {
        return workOrderApplyDAO.queryPaging(query);
    }

    // 发通知给人事 平台人力资源总监  平台薪酬绩效主管
    public void sendMessage(Long objectId,String messageTitle,String content){
        PrdMessageConfigPayload ado = new PrdMessageConfigPayload();
        ado.setObjectId(objectId);
        ado.setMessageTitle(messageTitle);
        ado.setMessageType(2);
        ado.setContentBigType("businessMessage");
        ado.setContentType(MessageNoticeTypeEnum.personnelMessage.getCode());
        ado.setMessageTag("important");
        ado.setIsEnable(0);
        ado.setNoticeScope("appoint_people");
        ado.setNoticeWay("instation");
        ado.setReleaseSource("profileMessage");
        ado.setReleaseStatus(3);
        ado.setMessageContent(content);
        List<Long> list = new ArrayList();
        list.addAll(roleService.queryUserIdByRoleCode(RoleEnum.PLAT_HRD.getCode()));
        list.addAll(roleService.queryUserIdByRoleCode(RoleEnum.PLAT_SALARY_MANAGER.getCode()));

        if(!CollectionUtils.isEmpty(list)){
            String noticeSource = list.stream().map(p -> p.toString()).collect(Collectors.joining(","));
            ado.setNoticeSource(noticeSource);
            //保存信息
            messageConfigService.insert(ado);
        }

    }
}
