package com.elitesland.tw.tw5.server.prd.inv.common;

import io.swagger.annotations.ApiModel;
import lombok.Getter;


/**
 * 百望发票状态类型
 *
 * @ Author: ssy
 * @ Date: 2020/6/15
 * @ Description:
 */
@ApiModel("百望发票类型")
public enum InvoiceStateEnum {

//    百望发票状态:0：正常, 1：失控, 2：作废, 3：红冲, 4：异常 - T_INVOICE.INVOICE_STATE
    INV_STATE_0("0","NORMAL","正常"),
    INV_STATE_1("1","OUT_CONTROL","失控"),
    INV_STATE_2("2","INVALID","作废"),
    INV_STATE_3("3","CHARGEOFF","红冲"),
    INV_STATE_4("4","ERROR","异常"),
    ;

    @Getter
    private final String code;
    @Getter
    private final String udcValue;
    @Getter
    private final String desc;

    InvoiceStateEnum(String code, String udcValue, String desc) {
        this.code = code;
        this.udcValue = udcValue;
        this.desc = desc;
    }
}
