package com.elitesland.tw.tw5.server.prd.inv.dao;


import com.elitesland.tw.tw5.api.prd.inv.payload.InvInvoiceTravelItineraryPayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceTravelItineraryQuery;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceTravelItineraryVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.inv.entity.InvInvoiceTravelItineraryDO;
import com.elitesland.tw.tw5.server.prd.inv.entity.QInvInvoiceTravelItineraryDO;
import com.elitesland.tw.tw5.server.prd.inv.repo.InvInvoiceTravelItineraryRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 发票行程单
 *
 * @author zoey
 * @date 2023-12-05
 */
@Repository
@RequiredArgsConstructor
public class InvInvoiceTravelItineraryDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final InvInvoiceTravelItineraryRepo repo;
    private final QInvInvoiceTravelItineraryDO qdo = QInvInvoiceTravelItineraryDO.invInvoiceTravelItineraryDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<InvInvoiceTravelItineraryVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(InvInvoiceTravelItineraryVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 租户ID
                qdo.tenantId,
                // 发票ID
                qdo.invId,
                // 百望系统发票ID
                qdo.baiwangInvId,
                // 百望系统发票行程单ID
                qdo.baiwangId,
                // 发票代码
                qdo.invoiceCode,
                // 发票号码
                qdo.invoiceNo,
                // 出发站
                qdo.fromstation,
                // 到达站
                qdo.tostation,
                // 航班号
                qdo.flightno,
                // 乘机日期
                qdo.traveldate,
                // 乘机时间
                qdo.traveltime,
                // 座位等级
                qdo.seatlevel,
                // 承运人
                qdo.carrier
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<InvInvoiceTravelItineraryVO> getJpaQueryWhere(InvInvoiceTravelItineraryQuery query) {
        JPAQuery<InvInvoiceTravelItineraryVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(InvInvoiceTravelItineraryQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(InvInvoiceTravelItineraryQuery query){
        List<Predicate> list = new ArrayList<>();
        /**  精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 发票ID 精确 */
        if (!ObjectUtils.isEmpty(query.getInvId())) {
            list.add(qdo.invId.eq(query.getInvId()));
        }
        /** 百望系统发票ID 精确 */
        if (!ObjectUtils.isEmpty(query.getBaiwangInvId())) {
            list.add(qdo.baiwangInvId.eq(query.getBaiwangInvId()));
        }
        /** 百望系统发票行程单ID 精确 */
        if (!ObjectUtils.isEmpty(query.getBaiwangId())) {
            list.add(qdo.baiwangId.eq(query.getBaiwangId()));
        }
        /** 发票代码 精确 */
        if (!ObjectUtils.isEmpty(query.getInvoiceCode())) {
            list.add(qdo.invoiceCode.eq(query.getInvoiceCode()));
        }
        /** 发票号码 精确 */
        if (!ObjectUtils.isEmpty(query.getInvoiceNo())) {
            list.add(qdo.invoiceNo.eq(query.getInvoiceNo()));
        }
        /** 出发站 精确 */
        if (!ObjectUtils.isEmpty(query.getFromstation())) {
            list.add(qdo.fromstation.eq(query.getFromstation()));
        }
        /** 到达站 精确 */
        if (!ObjectUtils.isEmpty(query.getTostation())) {
            list.add(qdo.tostation.eq(query.getTostation()));
        }
        /** 航班号 精确 */
        if (!ObjectUtils.isEmpty(query.getFlightno())) {
            list.add(qdo.flightno.eq(query.getFlightno()));
        }
        /** 乘机日期 精确 */
        if (!ObjectUtils.isEmpty(query.getTraveldate())) {
            list.add(qdo.traveldate.eq(query.getTraveldate()));
        }
        /** 乘机时间 精确 */
        if (!ObjectUtils.isEmpty(query.getTraveltime())) {
            list.add(qdo.traveltime.eq(query.getTraveltime()));
        }
        /** 座位等级 精确 */
        if (!ObjectUtils.isEmpty(query.getSeatlevel())) {
            list.add(qdo.seatlevel.eq(query.getSeatlevel()));
        }
        /** 承运人 精确 */
        if (!ObjectUtils.isEmpty(query.getCarrier())) {
            list.add(qdo.carrier.eq(query.getCarrier()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public InvInvoiceTravelItineraryVO queryByKey(Long id) {
        JPAQuery<InvInvoiceTravelItineraryVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<InvInvoiceTravelItineraryVO> queryListDynamic(InvInvoiceTravelItineraryQuery query) {
        JPAQuery<InvInvoiceTravelItineraryVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<InvInvoiceTravelItineraryVO> queryPaging(InvInvoiceTravelItineraryQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<InvInvoiceTravelItineraryVO> jpaQuery = getJpaQueryWhere(query);
        List<InvInvoiceTravelItineraryVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<InvInvoiceTravelItineraryVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public InvInvoiceTravelItineraryDO save(InvInvoiceTravelItineraryDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<InvInvoiceTravelItineraryDO> saveAll(List<InvInvoiceTravelItineraryDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(InvInvoiceTravelItineraryPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 发票ID
        if (payload.getInvId() != null) {
            update.set(qdo.invId, payload.getInvId());
        }
        // 百望系统发票ID
        if (payload.getBaiwangInvId() != null) {
            update.set(qdo.baiwangInvId, payload.getBaiwangInvId());
        }
        // 百望系统发票行程单ID
        if (payload.getBaiwangId() != null) {
            update.set(qdo.baiwangId, payload.getBaiwangId());
        }
        // 发票代码
        if (payload.getInvoiceCode() != null) {
            update.set(qdo.invoiceCode, payload.getInvoiceCode());
        }
        // 发票号码
        if (payload.getInvoiceNo() != null) {
            update.set(qdo.invoiceNo, payload.getInvoiceNo());
        }
        // 出发站
        if (payload.getFromstation() != null) {
            update.set(qdo.fromstation, payload.getFromstation());
        }
        // 到达站
        if (payload.getTostation() != null) {
            update.set(qdo.tostation, payload.getTostation());
        }
        // 航班号
        if (payload.getFlightno() != null) {
            update.set(qdo.flightno, payload.getFlightno());
        }
        // 乘机日期
        if (payload.getTraveldate() != null) {
            update.set(qdo.traveldate, payload.getTraveldate());
        }
        // 乘机时间
        if (payload.getTraveltime() != null) {
            update.set(qdo.traveltime, payload.getTraveltime());
        }
        // 座位等级
        if (payload.getSeatlevel() != null) {
            update.set(qdo.seatlevel, payload.getSeatlevel());
        }
        // 承运人
        if (payload.getCarrier() != null) {
            update.set(qdo.carrier, payload.getCarrier());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 租户ID
            if (nullFields.contains("tenantId")) {
                update.setNull(qdo.tenantId);
            }
            // 发票ID
            if (nullFields.contains("invId")) {
                update.setNull(qdo.invId);
            }
            // 百望系统发票ID
            if (nullFields.contains("baiwangInvId")) {
                update.setNull(qdo.baiwangInvId);
            }
            // 百望系统发票行程单ID
            if (nullFields.contains("baiwangId")) {
                update.setNull(qdo.baiwangId);
            }
            // 发票代码
            if (nullFields.contains("invoiceCode")) {
                update.setNull(qdo.invoiceCode);
            }
            // 发票号码
            if (nullFields.contains("invoiceNo")) {
                update.setNull(qdo.invoiceNo);
            }
            // 出发站
            if (nullFields.contains("fromstation")) {
                update.setNull(qdo.fromstation);
            }
            // 到达站
            if (nullFields.contains("tostation")) {
                update.setNull(qdo.tostation);
            }
            // 航班号
            if (nullFields.contains("flightno")) {
                update.setNull(qdo.flightno);
            }
            // 乘机日期
            if (nullFields.contains("traveldate")) {
                update.setNull(qdo.traveldate);
            }
            // 乘机时间
            if (nullFields.contains("traveltime")) {
                update.setNull(qdo.traveltime);
            }
            // 座位等级
            if (nullFields.contains("seatlevel")) {
                update.setNull(qdo.seatlevel);
            }
            // 承运人
            if (nullFields.contains("carrier")) {
                update.setNull(qdo.carrier);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

