package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitesland.tw.tw5.api.prd.my.payload.ProjectPayload;
import com.elitesland.tw.tw5.api.prd.my.query.ProjShQuery;
import com.elitesland.tw.tw5.api.prd.my.query.ProjectQuery;
import com.elitesland.tw.tw5.api.prd.my.service.ProjShService;
import com.elitesland.tw.tw5.api.prd.my.service.ProjectService;
import com.elitesland.tw.tw5.api.prd.my.vo.ProjShVO;
import com.elitesland.tw.tw5.api.prd.my.vo.ProjectVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.my.constant.ProjectEnum;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 工时用-项目表
 *
 * @author duwh
 * @date 2022-12-09
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/my/project")
@Slf4j
@Deprecated
public class ProjectController {

    private final ProjectService projectService;
    private final ProjShService projShService;
    private final CacheUtil cacheUtil;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    public TwOutputUtil insert(@RequestBody ProjectPayload payload) {
        return TwOutputUtil.ok(projectService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    public TwOutputUtil update(@RequestBody ProjectPayload payload) {
        return TwOutputUtil.ok(projectService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(projectService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    public TwOutputUtil paging(ProjectQuery query) {
        return TwOutputUtil.ok(projectService.paging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/listAll")
    // @UdcNameClass
    public TwOutputUtil queryListAll(ProjectQuery query) {
        query.setIsPermission(true);
        return queryList(query);
    }


    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    public TwOutputUtil queryList(ProjectQuery query) {
        final Long loginUserId = GlobalUtil.getLoginUserId();
        ProjectQuery projectQuery = new ProjectQuery();
        projectQuery.setProjIdV4(0L);
        // 无项目
        final List<ProjectVO> resultList = projectService.queryList(projectQuery);

        // 经营类项目数据  （行政人员填报工时）
        // 经营类项目  ext1 OPER   ext2为交付BU 组织id ：数据权限
        // 查当前登录人的组织id
        final Long defaultOrgIdByUserId = cacheUtil.getDefaultOrgIdByUserId(loginUserId);
        ProjectQuery projectOperQuery = new ProjectQuery();
        projectOperQuery.setExt2(defaultOrgIdByUserId+"");
        projectOperQuery.setExt1(ProjectEnum.OPER.getCode());
        final List<ProjectVO> projectOperList = projectService.queryList(projectOperQuery);
        resultList.addAll(projectOperList);
        if(query.getIsPermission()){
            // 根据项目成员决定项目数据权限
            ProjShQuery projShQuery = new ProjShQuery();
            projShQuery.setUserId(loginUserId);
            final List<ProjShVO> projShVOS = projShService.queryList(projShQuery);
            if (CollectionUtils.isEmpty(projShVOS)) {
                // 无项目
                return TwOutputUtil.ok(resultList);
            } else {
                List<Long> projIdList = projShVOS.stream()
                        .map(projShVO -> projShVO.getProjId())
                        .collect(Collectors.toList());
                query.setProjIdV4List(projIdList);
            }
        }
        if (!StringUtils.hasText(query.getProjStatus())) {
            query.setProjStatus("ACTIVE");
        }
        // 有权限的数据
        List<ProjectVO> list = projectService.queryList(query);
        resultList.addAll(list);
        return TwOutputUtil.ok(resultList);
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        projectService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
