package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.math.BigDecimal;

/**
 * 远程办公审批配置
 *
 * @author wangly
 * @date 2024-06-13
 */
@Entity
@Table(name = "abnormal_work_apply_config", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "abnormal_work_apply_config", comment = "远程办公审批配置")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AbnormalWorkApplyConfigDO extends BaseModel implements Serializable  {
    /** 事由类型 */
    @Comment("事由类型")
    @Column()
    private String reasonType;
    /** 触发条件 */
    @Comment("触发条件")
    @Column()
    private String triggerCondition;
    /** 触发天数 */
    @Comment("触发天数")
    @Column()
    private BigDecimal conditionDays;
    /** 业务角色1 */
    @Comment("业务角色1")
    @Column()
    private String firstRoleType;
    /** 审批角色1 */
    @Comment("审批角色1")
    @Column()
    private String firstApprovePerson;
    /** 业务角色2 */
    @Comment("业务角色2")
    @Column()
    private String twiceRoleType;
    /** 审批角色2 */
    @Comment("审批角色2")
    @Column()
    private String twiceApprovePerson;
    /** 业务角色3 */
    @Comment("业务角色3")
    @Column()
    private String thirdRoleType;
    /** 审批角色3 */
    @Comment("审批角色3")
    @Column()
    private String thirdApprovePerson;
    /** 业务角色4 */
    @Comment("业务角色4")
    @Column()
    private String fourthRoleType;
    /** 审批角色4 */
    @Comment("审批角色4")
    @Column()
    private String fourthApprovePerson;
    /** 扩展字段1 */
    @Comment("扩展字段1")
    @Column()
    private String ext1;
    /** 扩展字段2 */
    @Comment("扩展字段2")
    @Column()
    private String ext2;
    /** 扩展字段3 */
    @Comment("扩展字段3")
    @Column()
    private String ext3;
    /** 扩展字段4 */
    @Comment("扩展字段4")
    @Column()
    private String ext4;
    /** 扩展字段5 */
    @Comment("扩展字段5")
    @Column()
    private String ext5;

    public void copy(AbnormalWorkApplyConfigDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
