package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 外勤办公申请
 *
 * @author carl
 * @date 2024-05-22
 */
@Entity
@Table(name = "out_work_apply", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "out_work_apply", comment = "外勤办公申请")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class OutWorkApplyDO extends BaseModel implements Serializable {
    /**
     * 外出申请人id
     */
    @Comment("外出申请人id")
    @Column()
    private Long applyUserId;
    /**
     * 归属bu_id
     */
    @Comment("归属bu_id")
    @Column()
    private Long orgId;
    /**
     * base地id
     */
    @Comment("base地id")
    @Column()
    private String baseAddrId;
    /**
     * 直属领导id
     */
    @Comment("直属领导id")
    @Column()
    private Long parentUserId;
    /**
     * 岗位
     */
    @Comment("岗位")
    @Column()
    private String jobs;
    /** 级别 */
    @Comment("级别")
    @Column()
    private String grade;
    /**
     * 申请日期
     */
    @Comment("申请日期")
    @Column()
    private LocalDate applyDate;
    /**
     * 外勤办公日期
     */
    @Comment("外勤办公日期")
    @Column()
    private LocalDate outWorkDate;
    /**
     * 外勤办公时间开始
     */
    @Comment("外勤办公时间开始")
    @Column()
    private LocalDateTime outWorkTimeStart;

    /**
     * 外勤办公时间结束
     */
    @Comment("外勤办公时间结束")
    @Column()
    private LocalDateTime outWorkTimeEnd;
    /**
     * 外勤工作天数
     */
    @Comment("外勤工作天数")
    @Column()
    private BigDecimal outWorkDays;
    /**
     * 0.5天区分上午下午 AM上午 PM下午
     */
    @Comment("0.5天区分上午下午 AM上午 PM下午")
    @Column()
    private String outWorkInterval;
    /**
     * 外勤工作地
     */
    @Comment("外勤工作地")
    @Column()
    private String outWorkAddr;
    /**
     * 编号
     */
    @Comment("编号")
    @Column()
    private String applyNo;
    /**
     * 名称
     */
    @Comment("名称")
    @Column()
    private String applyName;
    /**
     * 任务状态
     */
    @Comment("任务状态")
    @Column()
    private String applyStatus;
    /**
     * 审批状态
     */
    @Comment("审批状态")
    @Column()
    private String procInstStatus;
    /**
     * 流程id
     */
    @Comment("流程id")
    @Column()
    private String procInstId;

    public void copy(OutWorkApplyDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
