package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 权限申请
 *
 * @author lemon
 * @date 2023-09-11
 */
@Entity
@Table(name = "t_permission_apply", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_permission_apply", comment = "权限申请")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TPermissionApplyDO extends BaseModel implements Serializable  {
    /** 申请人 */
    @Comment("申请人")
    @Column()
    private Long applyResId;
    /** 申请人部门 */
    @Comment("申请人部门")
    @Column()
    private Long applyBuId;
    /** 任务名称 */
    @Comment("任务名称")
    @Column()
    private String applyDate;
    /** 申请人手机号码 */
    @Comment("申请人手机号码")
    @Column()
    private String applyResPhone;
    /** 申请权限说明 */
    @Comment("申请权限说明")
    @Column()
    private String applyContent;
    /** 流程实例ID */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    /** 流程审批状态 */
    @Comment("流程审批状态")
    @Column()
    private ProcInstStatus procInstStatus;
    /** 提交时间 */
    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;
    /** 审批时间 */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    public void copy(TPermissionApplyDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
