package com.elitesland.tw.tw5.server.prd.my.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

/**
 * @author zoey
 * @Description: 周报已读状态表
 * @date 2023/3/20 - 16:31
 */
@Entity
@Table(name = "t_timesheet_biweekly_read", uniqueConstraints = {
        @UniqueConstraint(columnNames = {"userId","readUserId"})},indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_timesheet_biweekly_read", comment = "工时表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TimesheetBiweeklyReadFlagDO extends BaseModel {

    /**
     * 用户id
     */
    @Comment("用户id")
    @Column()
    private Long userId;


    /**
     * 周报读取用户id
     */
    @Comment("周报读取用户id")
    @Column()
    private Long readUserId;


//    /**
//     * 所在年周
//     */
//    @Comment("所在年周")
//    @Column()
//    private Integer yearWeek;

    /**
     * 读取状态（0：未读；1：已读）
     */
    @Comment("读取状态")
    @Column()
    private Integer readFlag;

}
