package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetSubsidySettingPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetSubsidySettingQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TimesheetSubsidySettingService;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetSubsidySettingVO;
import com.elitesland.tw.tw5.server.prd.my.convert.TimesheetSubsidySettingConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.TimesheetSubsidySettingDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.TimesheetSubsidySettingDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetSubsidySettingRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 工时补贴标准配置表
 *
 * @author duwh
 * @date 2024-07-13
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TimesheetSubsidySettingServiceImpl extends BaseServiceImpl implements TimesheetSubsidySettingService {

    private final TimesheetSubsidySettingRepo timesheetSubsidySettingRepo;
    private final TimesheetSubsidySettingDAO timesheetSubsidySettingDAO;

    @Override
    public PagingVO<TimesheetSubsidySettingVO> queryPaging(TimesheetSubsidySettingQuery query){
        return timesheetSubsidySettingDAO.queryPaging(query);
    }

    @Override
    public List<TimesheetSubsidySettingVO> queryListDynamic(TimesheetSubsidySettingQuery query){
        return timesheetSubsidySettingDAO.queryListDynamic(query);
    }

    @Override
    public TimesheetSubsidySettingVO queryByKey(Long key) {
        TimesheetSubsidySettingDO entity = timesheetSubsidySettingRepo.findById(key).orElseGet(TimesheetSubsidySettingDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TimesheetSubsidySettingVO vo = TimesheetSubsidySettingConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TimesheetSubsidySettingVO insert(TimesheetSubsidySettingPayload payload) {
        TimesheetSubsidySettingDO entityDo = TimesheetSubsidySettingConvert.INSTANCE.toDo(payload);
        return TimesheetSubsidySettingConvert.INSTANCE.toVo(timesheetSubsidySettingRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TimesheetSubsidySettingVO update(TimesheetSubsidySettingPayload payload) {
        TimesheetSubsidySettingDO entity = timesheetSubsidySettingRepo.findById(payload.getId()).orElseGet(TimesheetSubsidySettingDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TimesheetSubsidySettingDO entityDo = TimesheetSubsidySettingConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TimesheetSubsidySettingConvert.INSTANCE.toVo(timesheetSubsidySettingRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(TimesheetSubsidySettingPayload payload) {
        TimesheetSubsidySettingDO entity = timesheetSubsidySettingRepo.findById(payload.getId()).orElseGet(TimesheetSubsidySettingDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = timesheetSubsidySettingDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            timesheetSubsidySettingDAO.deleteSoft(keys);
        }
    }

}
