package com.elitesland.tw.tw5.server.prd.partner.identity.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerSimpleVO;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessCustomerSyncPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BusinessPartnerListSimpleQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BusinessPartnerQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessCutomerManageVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessCustomerInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.query.BusinessCustomerInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerSimpleVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyCustomerVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmCustomerOperationDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmLeadsDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunityDO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBookAddressDO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBusinessPartnerDO;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessInsideOrOutSideEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerIdentityEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerStatusEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessTeamRoleEnum;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.*;
import com.elitesland.tw.tw5.server.prd.partner.identity.repo.BusinessCustomerInfoRepo;
import com.elitesland.tw.tw5.server.prd.partner.team.entity.QBusinessTeamMemberDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * 业务伙伴-客户信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Repository
@RequiredArgsConstructor
public class BusinessCustomerInfoDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final BusinessCustomerInfoRepo repo;
    private final QBusinessCustomerInfoDO qdo = QBusinessCustomerInfoDO.businessCustomerInfoDO;
    private final QBusinessDistributorInfoDO qBusinessDistributorInfoDO = QBusinessDistributorInfoDO.businessDistributorInfoDO;
    private final QBusinessSupplierInfoDO qBusinessSupplierInfoDO = QBusinessSupplierInfoDO.businessSupplierInfoDO;
    private final QBusinessCollaboratePartnerInfoDO qBusinessCollaboratePartnerInfoDO = QBusinessCollaboratePartnerInfoDO.businessCollaboratePartnerInfoDO;
    private final QBusinessPartnerDO qBusinessPartnerDO = QBusinessPartnerDO.businessPartnerDO;
    private final QBookAddressDO qBookAddressDO = QBookAddressDO.bookAddressDO;
    private final QCrmLeadsDO qCrmLeadsDO = QCrmLeadsDO.crmLeadsDO;
    private final QCrmOpportunityDO qCrmOpportunityDO = QCrmOpportunityDO.crmOpportunityDO;
    private final QBusinessTeamMemberDO qBusinessTeamMemberDO = QBusinessTeamMemberDO.businessTeamMemberDO;
    private final QCrmCustomerOperationDO qCrmCustomerOperationDO = QCrmCustomerOperationDO.crmCustomerOperationDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessCustomerInfoVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(BusinessCustomerInfoVO.class,
                qdo.id,
                //客户编号
                qdo.customerNo,
                //同步jde标志
                qdo.syncJdeFlag,
                //qdo.remark,
                qdo.createUserId,
                //qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 业务伙伴id business_partner.id
                qdo.partnerId,
                // 客户状态 udc[CRM:BUSINESS_PARTNER:STATUS]
                qdo.customerStatus,
                // 客户级别 udc[crm:cust_oper:cust_grade]
                qdo.customerGradle,
                // 客户来源 udc[crm:customer_source]
                qdo.customerSource,
                // 客户经营状态
                qdo.isOperate,
                // 客户阶段 udc[crm:customer_stage]
                qdo.customerStage,
                // 扩展字段1
                qdo.ext1,
                // 扩展字段2
                qdo.ext2,
                // 扩展字段3
                qdo.ext3,
                // 扩展字段4
                qdo.ext4,
                // 扩展字段5
                qdo.ext5,
                // 分数
                qdo.score,
                // 策略id business_strategy.id
                qdo.strategyId
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessCustomerInfoVO> getJpaQueryWhere(BusinessCustomerInfoQuery query) {
        JPAQuery<BusinessCustomerInfoVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(BusinessCustomerInfoQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(BusinessCustomerInfoQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 业务伙伴id business_partner.id 精确 */
        if (!ObjectUtils.isEmpty(query.getPartnerId())) {
            list.add(qdo.partnerId.eq(query.getPartnerId()));
        }
        /** 客户编号 精确 */
        if (!ObjectUtils.isEmpty(query.getCustomerNo())) {
            list.add(qdo.customerNo.eq(query.getCustomerNo()));
        }
        /** 业务伙伴id business_partner.id 精确 */
        if (!CollectionUtils.isEmpty(query.getPartnerIdList())) {
            list.add(qdo.partnerId.in(query.getPartnerIdList()));
        }
        /** 客户状态 udc[CRM:BUSINESS_PARTNER:STATUS] 精确 */
        if (!ObjectUtils.isEmpty(query.getCustomerStatus())) {
            list.add(qdo.customerStatus.eq(query.getCustomerStatus()));
        }
        /** 客户级别 udc[crm:cust_oper:cust_grade] 精确 */
        if (!ObjectUtils.isEmpty(query.getCustomerGradle())) {
            list.add(qdo.customerGradle.eq(query.getCustomerGradle()));
        }
        /** 客户来源 udc[crm:customer_source] 精确 */
        if (!ObjectUtils.isEmpty(query.getCustomerSource())) {
            list.add(qdo.customerSource.eq(query.getCustomerSource()));
        }
        /** 客户阶段 udc[crm:customer_stage] 精确 */
        if (!ObjectUtils.isEmpty(query.getCustomerStage())) {
            list.add(qdo.customerStage.eq(query.getCustomerStage()));
        }
        /** 客户经营状态 精确 */
        if (!ObjectUtils.isEmpty(query.getCustOperStatus())) {
            list.add(qCrmCustomerOperationDO.custOperStatus.eq(query.getCustOperStatus()));
        }
        /** 扩展字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 扩展字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.eq(query.getExt2()));
        }
        /** 扩展字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.eq(query.getExt3()));
        }
        /** 扩展字段4 精确 */
        if (!ObjectUtils.isEmpty(query.getExt4())) {
            list.add(qdo.ext4.eq(query.getExt4()));
        }
        /** 扩展字段5 精确 */
        if (!ObjectUtils.isEmpty(query.getExt5())) {
            list.add(qdo.ext5.eq(query.getExt5()));
        }

        /** 分数 精确 */
        if (!ObjectUtils.isEmpty(query.getScore())) {
            list.add(qdo.score.eq(query.getScore()));
        }

        /**策略id business_strategy.id */
        if (!ObjectUtils.isEmpty(query.getStrategyId())) {
            list.add(qdo.strategyId.eq(query.getStrategyId()));
        }

        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public BusinessCustomerInfoVO queryByKey(Long id) {
        JPAQuery<BusinessCustomerInfoVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<BusinessCustomerInfoVO> queryListDynamic(BusinessCustomerInfoQuery query) {
        JPAQuery<BusinessCustomerInfoVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<BusinessCustomerInfoVO> queryPaging(BusinessCustomerInfoQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<BusinessCustomerInfoVO> jpaQuery = getJpaQueryWhere(query);
        List<BusinessCustomerInfoVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<BusinessCustomerInfoVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public BusinessCustomerInfoDO save(BusinessCustomerInfoDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<BusinessCustomerInfoDO> saveAll(List<BusinessCustomerInfoDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(BusinessCustomerInfoPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 业务伙伴id business_partner.id
        if (payload.getPartnerId() != null) {
            update.set(qdo.partnerId, payload.getPartnerId());
        }
        // 客户编号
        if (payload.getCustomerNo() != null) {
            update.set(qdo.customerNo, payload.getCustomerNo());
        }
        // jde同步标志
        if (payload.getSyncJdeFlag() != null) {
            update.set(qdo.syncJdeFlag, payload.getSyncJdeFlag());
        }
        // 客户状态 udc[CRM:BUSINESS_PARTNER:STATUS]
        if (payload.getCustomerStatus() != null) {
            update.set(qdo.customerStatus, payload.getCustomerStatus());
        }
        // 客户级别 udc[crm:customer_grade]
        if (payload.getCustomerGradle() != null) {
            update.set(qdo.customerGradle, payload.getCustomerGradle());
        }
        // 客户来源 udc[crm:customer_source]
        if (payload.getCustomerSource() != null) {
            update.set(qdo.customerSource, payload.getCustomerSource());
        }
        // 客户经营状态
        if (payload.getIsOperate() != null) {
            update.set(qdo.isOperate, payload.getIsOperate());
        }
        // 客户来源 udc[crm:customer_stage]
        if (payload.getCustomerStage() != null) {
            update.set(qdo.customerStage, payload.getCustomerStage());
        }

        // 流程实例ID
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        // 流程审批状态
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        // 提交时间
        if (payload.getSubmitTime() != null) {
            update.set(qdo.submitTime, payload.getSubmitTime());
        }
        // 审批时间
        if (payload.getApprovedTime() != null) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }

        // 扩展字段1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 扩展字段2
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 扩展字段3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 扩展字段4
        if (payload.getExt4() != null) {
            update.set(qdo.ext4, payload.getExt4());
        }
        // 扩展字段5
        if (payload.getExt5() != null) {
            update.set(qdo.ext5, payload.getExt5());
        }

        // 分数
        if (payload.getScore() != null) {
            update.set(qdo.score, payload.getScore());
        }
        // 策略id
        if (payload.getStrategyId() != null) {
            update.set(qdo.strategyId, payload.getStrategyId());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 业务伙伴id business_partner.id
            if (nullFields.contains("partnerId")) {
                update.setNull(qdo.partnerId);
            }
            // 客户编号
            if (nullFields.contains("customerNo")) {
                update.setNull(qdo.customerNo);
            }
            // jde同步标志
            if (nullFields.contains("syncJdeFlag")) {
                update.setNull(qdo.syncJdeFlag);
            }
            // 客户状态 udc[CRM:BUSINESS_PARTNER:STATUS]
            if (nullFields.contains("customerStatus")) {
                update.setNull(qdo.customerStatus);
            }
            // 客户级别 udc[crm:customer_grade]
            if (nullFields.contains("customerGradle")) {
                update.setNull(qdo.customerGradle);
            }
            // 客户来源 udc[crm:customer_source]
            if (nullFields.contains("customerSource")) {
                update.setNull(qdo.customerSource);
            }
            // 客户经营状态
            if (nullFields.contains("isOperate")) {
                update.setNull(qdo.isOperate);
            }
            // 客户阶段
            if (nullFields.contains("customerStage")) {
                update.setNull(qdo.customerStage);
            }
            // 扩展字段1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 扩展字段2
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 扩展字段3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
            // 扩展字段4
            if (nullFields.contains("ext4")) {
                update.setNull(qdo.ext4);
            }
            // 扩展字段5
            if (nullFields.contains("ext5")) {
                update.setNull(qdo.ext5);
            }
            // 分数
            if (nullFields.contains("score")) {
                update.setNull(qdo.score);
            }

            // 策略id
            if (nullFields.contains("strategyId")) {
                update.setNull(qdo.strategyId);
            }
            // 流程实例ID
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
            // 流程审批状态
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qdo.procInstStatus);
            }
            // 提交时间
            if (nullFields.contains("submitTime")) {
                update.setNull(qdo.submitTime);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    //合同 商机客户下拉查询
    public List<BusinessCustomerSimpleVO> listSimple(String identity, String customerStatus) {
        JPAQuery<BusinessCustomerSimpleVO> jpaQuery = jpaQueryFactory.select(Projections.bean(BusinessCustomerSimpleVO.class,
                //  qdo.id,
                //地址薄id
                qBusinessPartnerDO.bookId,
                // 业务伙伴id business_partner.id
                qBusinessPartnerDO.id,
                // 业务伙伴编号
                qBusinessPartnerDO.businessPartnerNo,
                qBusinessPartnerDO.partnerName.as("customerName"),
//                qBookInvoiceDO.taxNo,
//                qBookAccountDO.depositBank,
//                qBookAccountDO.accountNo,
//                qBookInvoiceDO.invoiceAddress,
//                qBookInvoiceDO.invoicePhone,
                qBusinessPartnerDO.partnerIndustry.as("companyIndustry"),
                qBusinessPartnerDO.partnerNature,
                qBusinessPartnerDO.partnerRegion,
//                qBookAddressDO.province,
//                qBookAddressDO.longitudeLatitude
                qBusinessPartnerDO.ext4,
                qBusinessPartnerDO.ext5,
                qBusinessPartnerDO.sortNo,
                qBusinessPartnerDO.parentManageBu
        )).from(qBusinessPartnerDO);
        if (!StringUtils.isEmpty(identity) && BusinessPartnerIdentityEnum.CUSTOMER.getCode().equals(identity)) {
            jpaQuery.leftJoin(qdo).on(qBusinessPartnerDO.id.eq(qdo.partnerId));
            // 合同查询的下拉客户要查询激活状态的
            if (!StringUtils.isEmpty(customerStatus)) {
                jpaQuery.where(qdo.customerStatus.eq(customerStatus));
            }
            jpaQuery.where(qdo.deleteFlag.eq(0));
        }

        if (!StringUtils.isEmpty(identity) && BusinessPartnerIdentityEnum.DISTRIBUTOR.getCode().equals(identity)) {
            jpaQuery.leftJoin(qBusinessDistributorInfoDO).on(qBusinessPartnerDO.id.eq(qBusinessDistributorInfoDO.partnerId));
            if (!StringUtils.isEmpty(customerStatus) && BusinessPartnerStatusEnum.ACTIVE.getCode().equals(customerStatus)) {
                jpaQuery.where(qBusinessDistributorInfoDO.dealerStatus.eq(customerStatus));
            }
            jpaQuery.where(qBusinessDistributorInfoDO.deleteFlag.eq(0));
        }

        if (!StringUtils.isEmpty(identity) && BusinessPartnerIdentityEnum.SUPPLIER.getCode().equals(identity)) {
            jpaQuery.leftJoin(qBusinessSupplierInfoDO).on(qBusinessPartnerDO.id.eq(qBusinessSupplierInfoDO.partnerId));
            jpaQuery.where(qBusinessSupplierInfoDO.deleteFlag.eq(0));
            if (!StringUtils.isEmpty(customerStatus)) {
                jpaQuery.where(qBusinessSupplierInfoDO.supplierStatus.eq(customerStatus));
            }
        }

        if (!StringUtils.isEmpty(identity) && BusinessPartnerIdentityEnum.COLLABORATE.getCode().equals(identity)) {
            jpaQuery.leftJoin(qBusinessCollaboratePartnerInfoDO).on(qBusinessPartnerDO.id.eq(qBusinessCollaboratePartnerInfoDO.partnerId));
            jpaQuery.where(qBusinessCollaboratePartnerInfoDO.deleteFlag.eq(0));
            if (!StringUtils.isEmpty(customerStatus)) {
                jpaQuery.where(qBusinessCollaboratePartnerInfoDO.collaborateStatus.eq(customerStatus));
            }
        }

        //    jpaQuery.leftJoin(qBookInvoiceDO).on(qBusinessPartnerDO.bookId.eq(qBookInvoiceDO.bookId).and(qBookInvoiceDO.isDefault.eq(true)).and(qBookInvoiceDO.deleteFlag.eq(0)));
        //    jpaQuery.leftJoin(qBookAccountDO).on(qBusinessPartnerDO.bookId.eq(qBookAccountDO.bookId).and(qBookAccountDO.isDefault.eq(true)).and(qBookAccountDO.deleteFlag.eq(0)));
        //     jpaQuery.leftJoin(qBookAddressDO).on(qBusinessPartnerDO.bookId.eq(qBookAddressDO.bookId).and(qBookAddressDO.isDefault.eq(true)).and(qBookAddressDO.deleteFlag.eq(0)));
        //如果是客户身份需要看客户经营状态
//        if(!StringUtils.isEmpty(identity)&& BusinessPartnerIdentityEnum.CUSTOMER.getCode().equals(identity)){
//            jpaQuery.where(qdo.isOperate.eq(true));
//        }
        //  jpaQuery.where(qBusinessPartnerDO.insideOrOutSide.eq(BusinessInsideOrOutSideEnum.OUTSIDE.getCode()));
        // 动态排序
        List<OrderItem> orders = new ArrayList<>();
        orders.add(OrderItem.asc("sortNo"));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qBusinessPartnerDO, orders));
        return jpaQuery.fetch();
    }

    //客户列表下拉查询统计
    public Long listSimplePagingCount(BusinessPartnerListSimpleQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.
                select(qBusinessPartnerDO.count()
                ).from(qBusinessPartnerDO);
        //客户
        if (!StringUtils.isEmpty(query.getPartnerIdentity()) && BusinessPartnerIdentityEnum.CUSTOMER.getCode().equals(query.getPartnerIdentity())) {
            jpaQuery.leftJoin(qdo).on(qBusinessPartnerDO.id.eq(qdo.partnerId));
            // 合同查询的下拉客户要查询激活状态的
            if (!StringUtils.isEmpty(query.getCustomerStatus())) {
                jpaQuery.where(qdo.customerStatus.eq(query.getCustomerStatus()));
            }
            jpaQuery.where(qdo.deleteFlag.eq(0));
        }
        //经销商
        if (!StringUtils.isEmpty(query.getPartnerIdentity()) && BusinessPartnerIdentityEnum.DISTRIBUTOR.getCode().equals(query.getPartnerIdentity())) {
            jpaQuery.leftJoin(qBusinessDistributorInfoDO).on(qBusinessPartnerDO.id.eq(qBusinessDistributorInfoDO.partnerId));
            jpaQuery.where(qBusinessDistributorInfoDO.deleteFlag.eq(0));
            if (!StringUtils.isEmpty(query.getCustomerStatus())) {
                jpaQuery.where(qBusinessDistributorInfoDO.dealerStatus.eq(query.getCustomerStatus()));
            }
        }
        //供应商
        if (!StringUtils.isEmpty(query.getPartnerIdentity()) && BusinessPartnerIdentityEnum.SUPPLIER.getCode().equals(query.getPartnerIdentity())) {
            jpaQuery.leftJoin(qBusinessSupplierInfoDO).on(qBusinessPartnerDO.id.eq(qBusinessSupplierInfoDO.partnerId));
            jpaQuery.where(qBusinessSupplierInfoDO.deleteFlag.eq(0));
            if (!StringUtils.isEmpty(query.getCustomerStatus())) {
                jpaQuery.where(qBusinessSupplierInfoDO.supplierStatus.eq(query.getCustomerStatus()));
            }
        }
        //合作伙伴
        if (!StringUtils.isEmpty(query.getPartnerIdentity()) && BusinessPartnerIdentityEnum.COLLABORATE.getCode().equals(query.getPartnerIdentity())) {
            jpaQuery.leftJoin(qBusinessCollaboratePartnerInfoDO).on(qBusinessPartnerDO.id.eq(qBusinessCollaboratePartnerInfoDO.partnerId));
            jpaQuery.where(qBusinessCollaboratePartnerInfoDO.deleteFlag.eq(0));
            if (!StringUtils.isEmpty(query.getCustomerStatus())) {
                jpaQuery.where(qBusinessCollaboratePartnerInfoDO.collaborateStatus.eq(query.getCustomerStatus()));
            }
        }

        if (!StringUtils.isEmpty(query.getPartnerName())) {
            jpaQuery.where(qBusinessPartnerDO.partnerName.like(SqlUtil.toSqlLikeString(query.getPartnerName())));

        }
        //    jpaQuery.leftJoin(qBookInvoiceDO).on(qBusinessPartnerDO.bookId.eq(qBookInvoiceDO.bookId).and(qBookInvoiceDO.isDefault.eq(true)).and(qBookInvoiceDO.deleteFlag.eq(0)));
        //    jpaQuery.leftJoin(qBookAccountDO).on(qBusinessPartnerDO.bookId.eq(qBookAccountDO.bookId).and(qBookAccountDO.isDefault.eq(true)).and(qBookAccountDO.deleteFlag.eq(0)));
        //     jpaQuery.leftJoin(qBookAddressDO).on(qBusinessPartnerDO.bookId.eq(qBookAddressDO.bookId).and(qBookAddressDO.isDefault.eq(true)).and(qBookAddressDO.deleteFlag.eq(0)));
        //如果是客户身份需要看客户经营状态
//        if(!StringUtils.isEmpty(identity)&& BusinessPartnerIdentityEnum.CUSTOMER.getCode().equals(identity)){
//            jpaQuery.where(qdo.isOperate.eq(true));
//        }
        jpaQuery.where(qBusinessPartnerDO.insideOrOutSide.eq(BusinessInsideOrOutSideEnum.OUTSIDE.getCode()));
        Long total = jpaQuery.fetchOne();
        if (total == null) {
            total = 0L;
        }
        return total;
    }

    //客户下拉查询分页
    public PagingVO<BusinessCustomerSimpleVO> listSimplePaging(BusinessPartnerListSimpleQuery query) {
        Long total = listSimplePagingCount(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<BusinessCustomerSimpleVO> jpaQuery = jpaQueryFactory.select(Projections.bean(BusinessCustomerSimpleVO.class,
                //  qdo.id,
                //地址薄id
                qBusinessPartnerDO.bookId,
                // 业务伙伴id business_partner.id
                qBusinessPartnerDO.id,
                // 业务伙伴编号
                qBusinessPartnerDO.businessPartnerNo,
                qBusinessPartnerDO.partnerName.as("customerName"),
//                qBookInvoiceDO.taxNo,
//                qBookAccountDO.depositBank,
//                qBookAccountDO.accountNo,
//                qBookInvoiceDO.invoiceAddress,
//                qBookInvoiceDO.invoicePhone,
                qBusinessPartnerDO.partnerIndustry.as("companyIndustry")
//                qBookAddressDO.longitudeLatitude
        )).from(qBusinessPartnerDO);
        //
        if (!StringUtils.isEmpty(query.getPartnerIdentity()) && BusinessPartnerIdentityEnum.CUSTOMER.getCode().equals(query.getPartnerIdentity())) {
            jpaQuery.leftJoin(qdo).on(qBusinessPartnerDO.id.eq(qdo.partnerId));
            // 合同查询的下拉客户要查询激活状态的
            if (!StringUtils.isEmpty(query.getCustomerStatus())) {
                jpaQuery.where(qdo.customerStatus.eq(query.getCustomerStatus()));
            }
            jpaQuery.where(qdo.deleteFlag.eq(0));
        }

        if (!StringUtils.isEmpty(query.getPartnerIdentity()) && BusinessPartnerIdentityEnum.DISTRIBUTOR.getCode().equals(query.getPartnerIdentity())) {
            jpaQuery.leftJoin(qBusinessDistributorInfoDO).on(qBusinessPartnerDO.id.eq(qBusinessDistributorInfoDO.partnerId));
            jpaQuery.where(qBusinessDistributorInfoDO.deleteFlag.eq(0));
            if (!StringUtils.isEmpty(query.getCustomerStatus())) {
                jpaQuery.where(qBusinessDistributorInfoDO.dealerStatus.eq(query.getCustomerStatus()));
            }
        }

        if (!StringUtils.isEmpty(query.getPartnerIdentity()) && BusinessPartnerIdentityEnum.SUPPLIER.getCode().equals(query.getPartnerIdentity())) {
            jpaQuery.leftJoin(qBusinessSupplierInfoDO).on(qBusinessPartnerDO.id.eq(qBusinessSupplierInfoDO.partnerId));
            jpaQuery.where(qBusinessSupplierInfoDO.deleteFlag.eq(0));
            if (!StringUtils.isEmpty(query.getCustomerStatus())) {
                jpaQuery.where(qBusinessSupplierInfoDO.supplierStatus.eq(query.getCustomerStatus()));
            }
        }

        if (!StringUtils.isEmpty(query.getPartnerIdentity()) && BusinessPartnerIdentityEnum.COLLABORATE.getCode().equals(query.getPartnerIdentity())) {
            jpaQuery.leftJoin(qBusinessCollaboratePartnerInfoDO).on(qBusinessPartnerDO.id.eq(qBusinessCollaboratePartnerInfoDO.partnerId));
            jpaQuery.where(qBusinessCollaboratePartnerInfoDO.deleteFlag.eq(0));
            if (!StringUtils.isEmpty(query.getCustomerStatus())) {
                jpaQuery.where(qBusinessCollaboratePartnerInfoDO.collaborateStatus.eq(query.getCustomerStatus()));
            }
        }

        if (!StringUtils.isEmpty(query.getPartnerName())) {
            jpaQuery.where(qBusinessPartnerDO.partnerName.like(SqlUtil.toSqlLikeString(query.getPartnerName())));

        }
        //    jpaQuery.leftJoin(qBookInvoiceDO).on(qBusinessPartnerDO.bookId.eq(qBookInvoiceDO.bookId).and(qBookInvoiceDO.isDefault.eq(true)).and(qBookInvoiceDO.deleteFlag.eq(0)));
        //    jpaQuery.leftJoin(qBookAccountDO).on(qBusinessPartnerDO.bookId.eq(qBookAccountDO.bookId).and(qBookAccountDO.isDefault.eq(true)).and(qBookAccountDO.deleteFlag.eq(0)));
        //     jpaQuery.leftJoin(qBookAddressDO).on(qBusinessPartnerDO.bookId.eq(qBookAddressDO.bookId).and(qBookAddressDO.isDefault.eq(true)).and(qBookAddressDO.deleteFlag.eq(0)));
        //如果是客户身份需要看客户经营状态
//        if(!StringUtils.isEmpty(identity)&& BusinessPartnerIdentityEnum.CUSTOMER.getCode().equals(identity)){
//            jpaQuery.where(qdo.isOperate.eq(true));
//        }
        jpaQuery.where(qBusinessPartnerDO.insideOrOutSide.eq(BusinessInsideOrOutSideEnum.OUTSIDE.getCode()));
        List<BusinessCustomerSimpleVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();

        return PagingVO.<BusinessCustomerSimpleVO>builder().records(result).total(total).build();
    }


    public CrmCustomerSimpleVO listSimpleByPartnerId(Long partnerId) {

        JPAQuery<CrmCustomerSimpleVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmCustomerSimpleVO.class,
                        //客户id
                        qdo.id,
                        //地址薄id
                        qBusinessPartnerDO.bookId,
                        // 业务伙伴id business_partner.id
                        qBusinessPartnerDO.id.as("partnerId"),
                        qBusinessPartnerDO.partnerName.as("customerName"),
                        qdo.customerStatus,
                        qdo.customerGradle,
                        qdo.customerSource,
                        qBookAddressDO.longitudeLatitude,
                        qBookAddressDO.detailAddress.as("companyAddress")
                )).from(qBusinessPartnerDO).
                leftJoin(qdo).on(qdo.partnerId.eq(qBusinessPartnerDO.id)).
                leftJoin(qBookAddressDO).on(qBusinessPartnerDO.bookId.eq(qBookAddressDO.bookId).and(qBookAddressDO.isDefault.eq(Boolean.TRUE)).and(qBookAddressDO.deleteFlag.eq(0)));
        jpaQuery.where(qBusinessPartnerDO.id.eq(partnerId));
        return jpaQuery.fetchOne();
    }

    //分级策略-查询客户
    public List<BusinessStrategyCustomerVO> queryCustomerList(BusinessPartnerQuery query) {
        JPAQuery<BusinessStrategyCustomerVO> jpaQuery = jpaQueryFactory.select(Projections.bean(BusinessStrategyCustomerVO.class,
                        qdo.id,
                        //业务伙伴id
                        qBusinessPartnerDO.id.as("partnerId"),
                        //性质
                        qBusinessPartnerDO.partnerNature,
                        //组织规模
                        qBusinessPartnerDO.organizationScale,
                        //与公司紧密度
                        qCrmCustomerOperationDO.companyTightness,
                        //行业地位
                        qCrmCustomerOperationDO.industryStand,
                        //经营策略
                        qCrmCustomerOperationDO.businessStrategy
                )).
                from(qdo).leftJoin(qBusinessPartnerDO).on(qdo.partnerId.eq(qBusinessPartnerDO.id)).
                leftJoin(qCrmCustomerOperationDO).on(qdo.partnerId.eq(qCrmCustomerOperationDO.customerId).and(qCrmCustomerOperationDO.deleteFlag.eq(0))).
                leftJoin(qBookAddressDO).on(qBookAddressDO.bookId.eq(qBusinessPartnerDO.bookId).and(qBookAddressDO.isDefault.eq(true))).
                where(qdo.deleteFlag.eq(0)).
                where(qBusinessPartnerDO.deleteFlag.eq(0));
        //性质
        if (!CollectionUtils.isEmpty(query.getPartnerNatureList())) {
            jpaQuery.where(qBusinessPartnerDO.partnerNature.in(query.getPartnerNatureList()));
        }
        //行业
        if (!CollectionUtils.isEmpty(query.getPartnerIndustryList())) {
            jpaQuery.where(qBusinessPartnerDO.partnerIndustry.in(query.getPartnerIndustryList()));
        }
        //国家
        if (!CollectionUtils.isEmpty(query.getCountryList())) {
            jpaQuery.where(qBookAddressDO.country.in(query.getCountryList()));
        }

        return jpaQuery.fetch();
    }

    //分级策略定时任务-将所有的客户的级别置为空
    public void updateCustomerGrade() {
        JPAUpdateClause update = jpaQueryFactory.update(qdo).setNull(qdo.customerGradle).
                setNull(qdo.score).setNull(qdo.indexInfo).where(qdo.deleteFlag.eq(0));
        update.execute();
    }

    public long queryCustomerManageCount(BusinessCustomerInfoQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.countDistinct()).
                from(qdo).leftJoin(qBusinessPartnerDO).on(qdo.partnerId.eq(qBusinessPartnerDO.id)).
                leftJoin(qCrmCustomerOperationDO).on(qBusinessPartnerDO.id.eq(qCrmCustomerOperationDO.customerId).and(qCrmCustomerOperationDO.deleteFlag.eq(0)));
        if (query.getPermissionFlag()) {
            jpaQuery.leftJoin(qBusinessTeamMemberDO).on(qBusinessTeamMemberDO.objectId.longValue().eq(qdo.partnerId));
        }
        jpaQuery.where(queryCustomerManageWhere(query));


        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }


    public JPAQuery<BusinessCutomerManageVO> queryCustomerManageSelect() {
        return jpaQueryFactory.select(Projections.bean(BusinessCutomerManageVO.class,
                        //业务伙伴id
                        qBusinessPartnerDO.id,
                        // 客户编号
                        qdo.customerNo,
                        qdo.remark,
                        qdo.createUserId,
                        qdo.creator,
                        qdo.createTime,
                        qBusinessPartnerDO.bookId,
                        // 业务伙伴编号
                        qBusinessPartnerDO.businessPartnerNo,
                        qBusinessPartnerDO.partnerNature,
                        // 类型 udc[CRM:BUSINESS_PARTNER:TYPE]
                        qBusinessPartnerDO.partnerType,
                        // 业务伙伴名称
                        qBusinessPartnerDO.partnerName,
                        //客户经营
                        qdo.isOperate,
                        //客户级别
                        qdo.customerGradle,
                        //客户状态
                        qdo.customerStatus,
                        //客户阶段
                        qdo.customerStage,
                        // 行业 udc[crm:leads_customer_industry]
                        qBusinessPartnerDO.partnerIndustry,
                        //客户来源
                        qdo.customerSource,
                        // 邮箱
                        qBusinessPartnerDO.partnerEmail,
                        // 传真
                        qBusinessPartnerDO.partnerFax,
                        // 电话
                        qBusinessPartnerDO.partnerPhone,
                        //国家
                        qBookAddressDO.country,
                        //省
                        qBookAddressDO.province,
                        //市
                        qBookAddressDO.city,
                        //区
                        qBookAddressDO.district,
                        qBookAddressDO.provinceName,
                        qBookAddressDO.cityName,
                        qBookAddressDO.districtName,
                        qBookAddressDO.detailAddress,
                        //客户经营状态
                        qCrmCustomerOperationDO.custOperStatus
                )).
                from(qdo).leftJoin(qBusinessPartnerDO).on(qdo.partnerId.eq(qBusinessPartnerDO.id)).
                leftJoin(qBookAddressDO).on(qBusinessPartnerDO.bookId.eq(qBookAddressDO.bookId).and(qBookAddressDO.isDefault.eq(true)).and(qBookAddressDO.deleteFlag.eq(0))).
                leftJoin(qCrmCustomerOperationDO).on(qBusinessPartnerDO.id.eq(qCrmCustomerOperationDO.customerId).and(qCrmCustomerOperationDO.deleteFlag.eq(0)));

    }

    private Predicate queryCustomerManageWhere(BusinessCustomerInfoQuery query) {
        List<Predicate> list = new ArrayList<>();
        list.add(qBusinessPartnerDO.deleteFlag.eq(0));
        //客户名称
        if (!ObjectUtils.isEmpty(query.getPartnerName())) {
            list.add(qBusinessPartnerDO.partnerName.like(SqlUtil.toSqlLikeString(query.getPartnerName())));
        }
        //客户级别
        if (!ObjectUtils.isEmpty(query.getCustomerGradle())) {
            list.add(qdo.customerGradle.eq(query.getCustomerGradle()));
        }
        //客户状态
        if (!ObjectUtils.isEmpty(query.getCustomerStatus())) {
            list.add(qdo.customerStatus.eq(query.getCustomerStatus()));
        }

        //客户行业
        if (!ObjectUtils.isEmpty(query.getPartnerIndustry())) {
            list.add(qBusinessPartnerDO.partnerIndustry.eq(query.getPartnerIndustry()));
        }
        //客户来源
        if (!ObjectUtils.isEmpty(query.getCustomerSource())) {
            list.add(qdo.customerSource.eq(query.getCustomerSource()));
        }

        //客户阶段
        if (!ObjectUtils.isEmpty(query.getCustomerStage())) {
            list.add(qdo.customerStage.eq(query.getCustomerStage()));
        }
        //客户经营状态
        if (!ObjectUtils.isEmpty(query.getCustOperStatus())) {
            list.add(qCrmCustomerOperationDO.custOperStatus.eq(query.getCustOperStatus()));
        }
        //导出使用
        if (!CollectionUtils.isEmpty(query.getIdList())) {
            list.add(qBusinessPartnerDO.id.in(query.getIdList()));
        }
        //性质
        if (!CollectionUtils.isEmpty(query.getPartnerNatureList())) {
            list.add(qBusinessPartnerDO.partnerNature.in(query.getPartnerNatureList()));
        }
        //性质
        if (!ObjectUtils.isEmpty(query.getPartnerNature())) {
            list.add(qBusinessPartnerDO.partnerNature.eq(query.getPartnerNature()));
        }
        //数据权限
        if (query.getPermissionFlag()) {
            BooleanExpression booleanExpression = qBusinessTeamMemberDO.userId.eq(query.getLoginUserId()).and(qBusinessTeamMemberDO.deleteFlag.eq(0));
            booleanExpression = booleanExpression.or(qdo.createUserId.eq(query.getLoginUserId()));
            list.add(booleanExpression);
        }
        return ExpressionUtils.allOf(list);
    }


    //客户管理分页查询
    public PagingVO<BusinessCutomerManageVO> queryCustomerManage(BusinessCustomerInfoQuery query) {

        long total = queryCustomerManageCount(query);
        if (total == 0) {
            return PagingVO.empty();
        }

        JPAQuery<BusinessCutomerManageVO> jpaQuery = queryCustomerManageSelect();
        if (query.getPermissionFlag()) {
            jpaQuery.leftJoin(qBusinessTeamMemberDO).on(qBusinessTeamMemberDO.objectId.longValue().eq(qdo.partnerId));
        }
        jpaQuery.distinct();
        // 条件封装
        jpaQuery.where(queryCustomerManageWhere(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        List<BusinessCutomerManageVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<BusinessCutomerManageVO>builder().records(result).total(total).build();
    }

    //客户管理列表查询
    public List<BusinessCutomerManageVO> queryCustomerManageList(BusinessCustomerInfoQuery query) {
        JPAQuery<BusinessCutomerManageVO> jpaQuery = queryCustomerManageSelect();
        if (query.getPermissionFlag()) {
            jpaQuery.leftJoin(qBusinessTeamMemberDO).on(qBusinessTeamMemberDO.objectId.longValue().eq(qdo.partnerId));
        }
        jpaQuery.distinct();
        // 条件封装
        jpaQuery.where(queryCustomerManageWhere(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));

        return jpaQuery.fetch();
    }

    public BusinessCutomerManageVO queryCustomerManageByPartnerId(Long id) {
        return jpaQueryFactory.select(Projections.bean(BusinessCutomerManageVO.class,
                        //业务伙伴id
                        qBusinessPartnerDO.id,
                        qdo.remark,
                        qdo.createUserId,
                        qdo.creator,
                        qdo.createTime,
                        qBusinessPartnerDO.bookId,
                        // 业务伙伴编号
                        qBusinessPartnerDO.businessPartnerNo,
                        // 类型 udc[CRM:BUSINESS_PARTNER:TYPE]
                        qBusinessPartnerDO.partnerType,
                        // 业务伙伴名称
                        qBusinessPartnerDO.partnerName,
                        //客户经营
                        qdo.isOperate,
                        //客户级别
                        qdo.customerGradle,
                        //客户状态
                        qdo.customerStatus,
                        //客户阶段
                        qdo.customerStage,
                        // 行业 udc[crm:leads_customer_industry]
                        qBusinessPartnerDO.partnerIndustry,
                        //客户来源
                        qdo.customerSource,
                        // 邮箱
                        qBusinessPartnerDO.partnerEmail,
                        // 传真
                        qBusinessPartnerDO.partnerFax,
                        // 电话
                        qBusinessPartnerDO.partnerPhone

                )).
                from(qdo).leftJoin(qBusinessPartnerDO).on(qdo.partnerId.eq(qBusinessPartnerDO.id)).
                where(qdo.deleteFlag.eq(0)).
                where(qdo.deleteFlag.eq(0)).
                fetchFirst();
    }

    //业务伙伴客户更新同步4.0查询
    public List<BusinessCustomerSyncPayload> queryBusinessCustomerSyncTw4(String businessPartnerNo) {
        JPAQuery<BusinessCustomerSyncPayload> jpaQuery = jpaQueryFactory.select(Projections.bean(BusinessCustomerSyncPayload.class,
                        qdo.id,
                        qdo.customerStatus,
                        qBusinessPartnerDO.bookIdV4,
                        qBusinessTeamMemberDO.memberName.as("operationUserName"))).from(qdo).
                leftJoin(qBusinessPartnerDO).on(qdo.partnerId.eq(qBusinessPartnerDO.id)).
                leftJoin(qBusinessTeamMemberDO).on(qdo.partnerId.eq(qBusinessTeamMemberDO.objectId).
                        and(qBusinessTeamMemberDO.deleteFlag.eq(0)).and(qBusinessTeamMemberDO.memberRole.eq(BusinessTeamRoleEnum.OPERATION.getCode()))).
                where(qdo.deleteFlag.eq(0)).
                where(qBusinessPartnerDO.deleteFlag.eq(0)).
                where(qdo.syncTime.lt(qdo.modifyTime).or(qdo.syncTime.isNull())).
                where(qBusinessPartnerDO.insideOrOutSide.eq(BusinessInsideOrOutSideEnum.OUTSIDE.getCode()));
        if (org.springframework.util.StringUtils.hasText(businessPartnerNo)) {
            jpaQuery.where(qBusinessPartnerDO.businessPartnerNo.eq(businessPartnerNo));
        }
        return jpaQuery.fetch();
    }

    //业务伙伴客户更新同步4.0更新同步时间
    public void updateSyncUpdateCustomer(List<Long> idList) {
        jpaQueryFactory.update(qdo).
                set(qdo.syncTime, LocalDateTime.now()).
                where(qdo.id.in(idList)).
                execute();
    }

    //业务伙伴客户更新同步4.0更新同步时间
    public void updateBusinessParnerCustomerModifyTime(Long partnerId) {
        jpaQueryFactory.update(qdo).
                set(qdo.modifyTime, LocalDateTime.now()).
                where(qdo.partnerId.eq(partnerId)).
                execute();

    }

    //查询所有的内部公司/签约公司/付款公司
    public List<BusinessCustomerSimpleVO> queryInnerCompany() {
        JPAQuery<BusinessCustomerSimpleVO> jpaQuery = jpaQueryFactory.select(Projections.bean(BusinessCustomerSimpleVO.class,
                        //  qdo.id,
                        //地址薄id
                        qBusinessPartnerDO.bookId,
                        // 业务伙伴编号
                        qBusinessPartnerDO.businessPartnerNo,
                        // 业务伙伴id
                        qBusinessPartnerDO.id,
                        // 业务伙伴名称
                        qBusinessPartnerDO.partnerName.as("customerName"),
                        // 行业
                        qBusinessPartnerDO.partnerIndustry.as("companyIndustry"),
                        qBusinessPartnerDO.ext4,
                        qBusinessPartnerDO.ext5,
                        qBusinessPartnerDO.sortNo
                )).from(qBusinessPartnerDO).
                where(qBusinessPartnerDO.insideOrOutSide.eq(BusinessInsideOrOutSideEnum.INSIDE.getCode())).
                where(qBusinessPartnerDO.disabledFlag.isNull().or(qBusinessPartnerDO.disabledFlag.eq(0))).
                where(qBusinessPartnerDO.deleteFlag.eq(0));

        List<OrderItem> orders = new ArrayList<>();
        orders.add(OrderItem.asc("sortNo"));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qBusinessPartnerDO, orders));

        return jpaQuery.fetch();
    }
}

