package com.elitesland.tw.tw5.server.prd.partner.team.controller;

import com.alibaba.fastjson.JSONObject;
import com.elitesland.tw.tw5.api.prd.partner.team.payload.BusinessTeamMemberPayload;
import com.elitesland.tw.tw5.api.prd.partner.team.query.BusinessTeamMemberQuery;
import com.elitesland.tw.tw5.api.prd.partner.team.service.BusinessTeamMemberService;
import com.elitesland.tw.tw5.api.prd.partner.team.vo.BusinessTeamMemberVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 团队成员
 *
 * @author wangly
 * @date 2023-05-16
 */
@Api(tags = "业务伙伴-团队成员")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/businessTeamMember")
@Slf4j
public class BusinessTeamMemberController {

    private final BusinessTeamMemberService businessTeamMemberService;

    /**
     * 业务伙伴-团队成员-新增
     * 插入的时候先删除后插入 避免更新删除一系列操作
     * @param jsonObject 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("业务伙伴-团队成员-新增")
    public TwOutputUtil insert(@RequestBody JSONObject jsonObject){
        List<BusinessTeamMemberPayload> payload = jsonObject.getJSONArray("list").toJavaList(BusinessTeamMemberPayload.class);
        return TwOutputUtil.ok(businessTeamMemberService.insert(payload));
    }

    /**
     * 业务伙伴-团队成员-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("业务伙伴-团队成员-更新")
    public TwOutputUtil update(@RequestBody BusinessTeamMemberPayload payload){
        return TwOutputUtil.ok(businessTeamMemberService.update(payload));
    }

    /**
     * 业务伙伴-团队成员-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("业务伙伴-团队成员-主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(businessTeamMemberService.queryByKey(key));
    }

    /**
     * 业务伙伴-团队成员-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("业务伙伴-团队成员-分页")
    public TwOutputUtil paging(BusinessTeamMemberQuery query) {
        return TwOutputUtil.ok(businessTeamMemberService.queryPaging(query));
    }

    /**
     * 业务伙伴-团队成员-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("业务伙伴-团队成员-查询列表")
    public TwOutputUtil<List<BusinessTeamMemberVO>> queryList(BusinessTeamMemberQuery query) {
        List<BusinessTeamMemberVO> businessTeamMemberVOS = businessTeamMemberService.queryListDynamic(query);
        return TwOutputUtil.ok(businessTeamMemberVOS);
    }

    /**
     * 业务伙伴-团队成员-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("业务伙伴-团队成员-删除")
    public TwOutputUtil deleteSoft(Long[] keys,Long objectId) {
        businessTeamMemberService.deleteSoft(Arrays.asList(keys),objectId);
        return TwOutputUtil.ok();
    }

}
