package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * 项目会议纪要
 *
 * @author zoey
 * @date 2024-05-28
 */
@Entity
@Table(name = "pms_project_summary", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "pms_project_summary", comment = "项目会议纪要")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsProjectSummaryDO extends BaseModel implements Serializable {
    /**
     * 纪要编号
     */
    @Comment("纪要编号")
    @Column()
    private String summaryNo;
    /**
     * 纪要名称
     */
    @Comment("纪要名称")
    @Column()
    private String summaryName;
    /**
     * 项目id
     */
    @Comment("项目id")
    @Column()
    private Long projId;
    /**
     * 消息内容
     */
    @Comment("消息内容")
    @Column()
    private String summaryContent;
    /**
     * 状态（0：已保存；1：已发布）
     */
    @Comment("状态（0：已保存；1：已发布）")
    @Column()
    private Integer summaryStatus;

    /**
     * 记录日期
     */
    @Comment("记录日期")
    @Column()
    private LocalDate summaryDate;

    public void copy(PmsProjectSummaryDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
