package com.elitesland.tw.tw5.server.prd.prj.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @author zoey
 * @Description:项目表
 * @date 2022/5/17 - 14:13
 */
@Entity
@Table(name = "prj_project", indexes = {
        @Index(name = "manage_index", columnList = "manage_user_id"),
        @Index(name = "org_index", columnList = "org_id")
})
@org.hibernate.annotations.Table(appliesTo = "prj_project", comment = "项目表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrjProjectDO extends BaseModel {

    @Comment("流程实例ID")
    @Column()
    private String procInstId;

    @Comment("名称")
    @Column(name = "project_name", nullable = false)
    private String projectName;

    @Comment("编号")
    @Column(name = "project_no", nullable = false)
    private String projectNo;

    @Comment("类型")
    @Column(name = "project_type", nullable = false)
    private String projectType;

    @Comment("开始时间")
    @Column()
    private LocalDate startTime;

    @Comment("结束时间")
    @Column()
    private LocalDate endTime;

    @Comment("负责人id")
    @Column(name = "manage_user_id")
    private Long manageUserId;

    @Comment("组织id")
    @Column(name = "org_id")
    private Long orgId;

    @Comment("公司ID")
    @Column()
    private Long companyId;

    @Comment("附件Codes")
    @Column()
    private String fileCodes;

    @Comment("项目状态")
    @Column()
    private String projectStatus;

    @Comment("关闭原因")
    @Column()
    private String closeReason;

    @Comment("丢失原因")
    @Column()
    private String loseReason;

    @Comment("关闭备注")
    @Column()
    private String clsoeRemark;
    /**
     * 当量预估单价
     */
    @Comment("当量预估单价")
    @Column()
    private BigDecimal eqvaPrice;

}
