package com.elitesland.tw.tw5.server.prd.purchase.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseContractDetailsPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseContractDetailsQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseContractDetailsService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurConOrAgreementDetailsSimpleVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseContractDetailsVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 采购合同管理-合同明细
 *
 * @author lipengfei
 * @date 2023-05-30
 */
@Api(tags = "采购合同管理-合同明细")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/purchaseContractDetails")
@Slf4j
public class PurchaseContractDetailsController {

    private final PurchaseContractDetailsService purchaseContractDetailsService;

    /**
     * 合同明细-新增
     *

     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("合同明细-新增")
    public TwOutputUtil insert(@RequestBody PurchaseContractDetailsPayload payload){
        return TwOutputUtil.ok(purchaseContractDetailsService.insert(payload));
    }

    /**
     * 合同明细-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("合同明细-更新")
    public TwOutputUtil update(@RequestBody PurchaseContractDetailsPayload payload){
        return TwOutputUtil.ok(purchaseContractDetailsService.update(payload));
    }

    /**
     * 合同明细-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("合同明细-主键查询")
    public TwOutputUtil<PurchaseContractDetailsVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(purchaseContractDetailsService.queryByKey(key));
    }

    /**
     * 合同明细-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("合同明细-分页")
    public TwOutputUtil<PagingVO<PurchaseContractDetailsVO>> paging(PurchaseContractDetailsQuery query) {
        return TwOutputUtil.ok(purchaseContractDetailsService.queryPaging(query));
    }

    /**
     * 合同明细-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("合同明细-查询列表")
    public TwOutputUtil<List<PurchaseContractDetailsVO>> queryList(PurchaseContractDetailsQuery query) {
        return TwOutputUtil.ok(purchaseContractDetailsService.queryListDynamic(query));
    }

    /**
     * 合同明细-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("合同明细-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        purchaseContractDetailsService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
