package com.elitesland.tw.tw5.server.prd.purchase.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 采购合同管理
 *
 * @author lipengfei
 * @date 2023-05-30
 */
@Entity
@Table(name = "t_purchase_payment_plan", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_purchase_payment_plan", comment = "采购合同管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PurchasePaymentPlanDO extends BaseModel implements Serializable  {
    /** 付款阶段 */
    @Comment("付款阶段")
    @Column()
    private String paymentStage;
    /** 付款金额 */
    @Comment("付款金额")
    @Column()
    private BigDecimal paymentAmt;
    /** 本次付款金额 */
    @Comment("本次付款金额")
    @Column()
    private BigDecimal currentPaymentAmt;
    /** 付款比例 */
    @Comment("付款比例")
    @Column()
    private BigDecimal paymentProportion;
    /** 预计付款日期 */
    @Comment("预计付款日期")
    @Column()
    private LocalDate estimatedPaymentDate;
    /** 付款申请单Id */
    @Comment("付款申请单Id")
    @Column()
    private Long paymentApplyId;
    /** 单据id */
    @Comment("单据id")
    @Column()
    private Long contractId;
    /** 单据编号 */
    @Comment("单据编号")
    @Column()
    private String contractNo;
    /** 付款状态 */
    @Comment("付款状态")
    @Column()
    private String paymentStatus;
    /** 核销状态 */
    @Comment("核销状态")
    @Column()
    private String writeoffStatus;
    /** 约束里程碑 */
    @Comment("约束里程碑")
    @Column()
    private Long milestone;
    /** 单据类型 */
    @Comment("单据类型")
    @Column()
    private String docType;
    /** 付款时间 */
    @Comment("付款时间")
    @Column()
    private LocalDateTime paymentDate;
    /** 约束合同节点 */
    @Comment("约束合同节点")
    @Column()
    private Long contractNode;
    /** 预付款中付款计划id */
    @Comment("预付款中付款计划id")
    @Column()
    private Long prePaymentPlanId;

    public void copy(PurchasePaymentPlanDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
