package com.elitesland.tw.tw5.server.prd.purchase.purenum;

import com.elitesland.tw.tw5.server.common.TwException;
import lombok.Getter;

/**
 * @author likunpeng
 * @date 2023/11/8
 * 付款申请单枚举
 */
public interface PurchasePaymentEnum {

    /**
     * 付款申请单流程
     */
    @Getter
    enum PaymentProcDefKey implements PurchasePaymentEnum {
        /**
         * 付款申请单流程
         */
//        PUR_TRADE_SERVICE("PUR_TRADE_SERVICE", "付款申请单服务贸易流程"),
//        PUR_TRADE_PRODUCT("PUR_TRADE_PRODUCT", "付款申请单产品贸易流程"),
//        PUR_OUTSOURCING("PUR_OUTSOURCING", "付款申请单外包流程"),
//        PUR_BID_SECURITY("PUR_BID_SECURITY", "采购合同投标保证金流程"),
//        PUR_HOUSE_RENTAL("PUR_HOUSE_RENTAL", "付款申请单房屋租赁流程"),
//        PUR_MIS_PURCHASE("PUR_MIS_PURCHASE", "付款申请单杂项采购流程"),
//        PUR_PUBLIC_OUTSOURCE("PUR_PUBLIC_OUTSOURCE", "付款申请单对公资源外包流程"),
//        PUR_MARKET("PUR_MARKET", "付款申请单市场渠道流程"),
//        PUR_RESEARCH("PUR_RESEARCH", "付款申请单研发采购流程"),
//        PUR_OPERATE("PUR_OPERATE", "付款申请单行政运营类采购流程"),
//        PUR_COMPANY("PUR_COMPANY", "付款申请单公司管理类流程"),
//        PUR_RESOURCE("PUR_RESOURCE", "付款申请单资源赋能类流程"),
//        PUR_AGREEMENT("PUR_AGREEMENT", "付款申请单行政运营类采购（协议）流程"),
//        PUR_SALARY_PAYMENT("PUR_SALARY_PAYMENT", "付款申请单薪资福利流程"),
//        PUR_ADVANCE_PAY_W_O("PUR_ADVANCE_PAY_W_O", "付款申请单预付款核销流程"),
//        PUR_ADVANCE_PAY_ONE("PUR_ADVANCE_PAY_ONE", "付款申请单预付款（合同采购及公司管理类采购）流程"),
//        PUR_ADVANCE_PAY_TWO("PUR_ADVANCE_PAY_TWO", "付款申请单预付款流程"),
//        PUR_ADVANCE_PAY_T("PUR_ADVANCE_PAY_T", "付款申请单预付款流程（项目采购预付款）"),
//        PUR_ADVANCE_PAY_FOUR("PUR_ADVANCE_PAY_FOUR", "付款申请单预付款流程（行政类预付款）"),

        PUR_PAYMENT_PAY("DIB_PUR_PAYMENT_PAY", "付款申请单流程"),
        PUR_ADVANCE_PAY("DIB_PUR_ADVANCE_PAY", "预付款申请单流程"),
        PUR_ADVANCE_PAY_W_O("DIB_PUR_ADVANCE_PAY_W_O", "付款申请单预付款核销流程"),


        ;
        private final String code;
        private final String desc;

        PaymentProcDefKey(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public static PaymentProcDefKey match(String procCode) {
            for (PaymentProcDefKey paymentProcDefKey : PaymentProcDefKey.values()) {
                if (paymentProcDefKey.getCode().equals(procCode)) {
                    return paymentProcDefKey;
                }
            }
            throw TwException.error("", "未找到相关流程，请检查！");
        }
    }

    /**
     * 付款申请单类型
     */
    @Getter
    enum PaymentType implements PurchasePaymentEnum {
        CONTRACT("contract", "按照采购合同付款"),
        AGREEMENT("agreement", "按照采购协议付款"),
        ADVANCE_PAY("advance_pay", "预付款"),
        ADVANCE_PAY_WRITE_OFF("advance_pay_write_off", "预付款核销"),
        SALARY_PAYMENT("salary_payment", "薪酬福利支付"),
        OTHER_PAYMENT("other_payment", "其他付款申请"),
        ;

        private final String code;
        private final String desc;

        PaymentType(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public static PaymentType match(String code) {
            for (PaymentType paymentType : PaymentType.values()) {
                if (paymentType.getCode().equals(code)) {
                    return paymentType;
                }
            }
            throw TwException.error("", "未找到相关的付款单类型，请检查");
        }
    }

    /**
     * 关联单据类型
     */
    @Getter
    enum PaymentDocType implements PurchasePaymentEnum {
        CONTRACT("contract", "采购合同"),
        AGREEMENT("agreement", "采购协议"),
        SALARY_PAYMENT("advance_pay", "薪资成本单"),
        OPPORTUNITY("opportunity", "商机"),
        TENTATIVE("tentative", "空"),
        ;

        private final String code;
        private final String desc;

        PaymentDocType(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public static PaymentDocType match(String paymentDocTypeCode) {
            if (paymentDocTypeCode == null) {
                return TENTATIVE;
            }
            for (PaymentDocType paymentDocType : PaymentDocType.values()) {
                if (paymentDocType.getCode().equals(paymentDocTypeCode)) {
                    return paymentDocType;
                }
            }
            throw TwException.error("", "未找到相关的关联单据类型，请检查");
        }
    }


    /**
     * 采购协议类型
     */
    @Getter
    enum AgreementType implements PurchasePaymentEnum {
        OTHER("other", "其他类协议"),
        ENTITY_OUTSOURCING("entity_outsourcing", "个体资源外包"),
        PUBLIC_OUTSOURCING("public_outsourcing", "对公资源外包"),
        CON_AGREEMENT("con_agreement", "合同协议"),
        ;

        private final String code;
        private final String desc;

        AgreementType(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public static AgreementType match(String code) {
            for (AgreementType agreementType : AgreementType.values()) {
                if (agreementType.getCode().equals(code)) {
                    return agreementType;
                }
            }
            throw TwException.error("", "未找到相关的采购协议类型，请检查");
        }
    }



    /**
     * 付款申请单状态
     */
    @Getter
    enum PaymentStatus implements PurchasePaymentEnum {
        CREATE("create", "新建"),
        APPROVING("approving", "审批中"),
        APPROVED("approved", "已审批"),
        PARTIAL_PAY("partial_pay", "部分付款"),
        PAID("paid", "已付款"),
        WRITE_OFF_PROCESS("write_off_process", "核销中"),
        WRITE_OFF_PART("write_off_part", "部分核销"),
        WRITTEN_OFF("written_off", "已核销"),
        CLOSE("close", "关闭"),
        ;

        private final String code;
        private final String desc;

        PaymentStatus(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }

    /**
     * 付款记录单状态
     */
    @Getter
    enum PaymentSlipStatus implements PurchasePaymentEnum {
        NEW("new", "新建"),
        READY("ready", "待应付会计提交"),
        FINANCE_MANAGER_APPR("finance_manager_appr", "财务经理审核"),
        CFO_APPR("cfo_appr", "CFO审核"),
        CASHIER_APPR("cashier_appr", "出纳审核"),
        PAID("paid", "已付款"),
        PAYMENT_ACCOUNT("payment_account","付款待记账"),
        FINANCE_REJECTED("finance_rejected", "财务经理驳回"),
        CASHIER_TO_SUBMIT("cashier_to_submit", "出纳驳回至应付会计"),
        CASHIER_TO_FINANCE("cashier_to_finance", "出纳驳回至财务经理"),
        ;

        private final String code;
        private final String desc;

        PaymentSlipStatus(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }

    /**
     * 付款计划付款状态
     */
    @Getter
    enum PaymentPlanPayStatus implements PurchasePaymentEnum {
        PARTIAL_PAYMENT("partial_payment", "部分付款"),
        UNPAID("unpaid", "未付款"),
        PAID("paid", "已完成"),
        ;

        private final String code;
        private final String desc;

        PaymentPlanPayStatus(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }

    /**
     * 采购协议验收方式
     */
    @Getter
    enum AcceptanceMethod implements PurchasePaymentEnum {
        SALARY_CASH("salary_cash", "薪资成本"),
        ATTRIBUTION_AGREEMENT("attribution_agreement", "参照归属协议"),
        WITHDRAW("withdraw", "提现申请单"),
        TASK("task", "任务包"),
        SETTLEMENT("settlement", "结算单"),
        MILE_CON_NODE("mile_con_node", "里程碑+合同节点"),
        CON_NODE("con_node", "合同节点"),
        MILESTONE("milestone", "里程碑"),

        ;

        private final String code;
        private final String desc;

        AcceptanceMethod(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public static AcceptanceMethod match(String code) {
            for (AcceptanceMethod acceptanceMethod : AcceptanceMethod.values()) {
                if (acceptanceMethod.getCode().equals(code)) {
                    return acceptanceMethod;
                }
            }
            return null;
        }
    }

    /**
     * 付款方式
     */
    @Getter
    enum PayModeEnum implements PurchasePaymentEnum {
        PAYCURRENCY(1, "网银支付"),
        PAYMANUAL(2, "手动支付");
        private final Integer code;
        private final String desc;

        PayModeEnum(Integer code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }

    /**
     * 网银提交标识
     */
    enum PayBankFlag implements PurchasePaymentEnum {

        BANKFALG1(1, "已提交"),
        BANKFALG2(2, "未提交");
        @Getter
        private final int code;

        /**
         * 描述
         */
        @Getter
        private final String desc;

        PayBankFlag(int code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }

    /**
     * 付款记录支付状态
     */
    @Getter
    enum PayStatusEnum implements PurchasePaymentEnum {
        SUCCESS("S", "成功"),
        FAIL("F", "失败"),
        REVOKE("C", "撤销"),
        EXPIRE("D", "过期"),
        VETO("R", "否决"),
        PAYRETRUN("G", "退票"),
        PAYIN("Z", "支付中");
        private final String code;
        private final String desc;

        PayStatusEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }

    /**
     * 付款记录支付状态
     */
    @Getter
    enum OrderTypeEnum implements PurchasePaymentEnum {
        REIM(1, "代发"),
        CONTANT(2, "支付");
        private final Integer code;
        private final String desc;

        OrderTypeEnum(Integer code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }

    /**
     * 系统内标识 Y 收方为招商银行账号      N收方为他行账户
     */
    @Getter
    enum PaySystemEnum implements PurchasePaymentEnum {
        YES("Y", "收方为招商银行账号"),
        NO("N", "收方为他行账户");
        private final String code;
        private final String desc;

        PaySystemEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }

    /**
     * 银企直联发送状态
     */
    @Getter
    enum PayStatusDetailEnum implements PurchasePaymentEnum {

        SEND(1, "待发送"),
        SELECT(2, "待查询"),
        PAYMENT(3, "待支付"),
        PAYIN(3, "支付中"),
        SUCCESS(4, "成功"),
        FAIL(5, "失败"),
        PAYRETURN(6, "支付退票");
        private final int code;
        private final String desc;

        PayStatusDetailEnum(int code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }

    /**
     * 单据类型
     */
    @Getter
    enum PayDocType implements PurchasePaymentEnum {

        REIM("REIM", "创建"),
        CONTANT("CONTANT", "付款");
        private final String code;

        /**
         * 描述
         */
        private final String desc;

        PayDocType(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }

    /**
     * 银企直联单据类型
     */
    @Getter
    enum BankDocType implements PurchasePaymentEnum {

        PAY("PAY", "付款申请单"),
        TRAN("TRAN", "资金划拨申请单"),
        REIM("REIM", "报销单");
        private final String code;

        /**
         * 描述
         */
        private final String desc;

        BankDocType(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }

    /**
     * 银企直联单据类型
     */
    @Getter
    enum PayStlchnEnum implements PurchasePaymentEnum {

        HYPERNET("R", "实时-超网"),
        FAST("Q", "快速"),
        ORDINARY("G", "普通");
        private final String code;

        /**
         * 描述
         */
        private final String desc;

        PayStlchnEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }
    /**
     * 履历类型
     */
    @Getter
    enum PayHistType implements PurchasePaymentEnum {

        HISTTYPE1("线下支付"),
        HISTTYPE2("账号修改"),
        HISTTYPE3("网银再次提交"),
        HISTTYPE4("网银提交"),
        HISTTYPE5("修改支付用途"),
        HISTTYPE6("支付方式修改");
        /**
         * 描述
         */
        @Getter
        private final String desc;

        PayHistType(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 履历描述
     */
    @Getter
    enum PayHistDtl implements PurchasePaymentEnum {
        DTL1("财务确认线下支付"),
        DTL2("收款账号修改"),
        DTL3("再次提交网银"),
        DTL4("财务提交网银"),
        DTL5("财务修改支付用途"),
        DTL6("手动支付"),
        DTL7("网银支付");
        /**
         * 描述
         */
        @Getter
        private final String desc;

        PayHistDtl(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 支付描述
     */
    enum PayNusage {

        NUSAGE1("报销转账"),
        NUSAGE2("预付款支付"),
        NUSAGE3("合同付款");

        /**
         * 描述
         */
        @Getter
        private final String desc;

        PayNusage(String desc) {
            this.desc = desc;
        }
    }
    @Getter
    enum CurrCodeEnum implements PurchasePaymentEnum{

        CNY("CNY","人民币"),
        ;
        private final String code;

        /**
         * 描述
         */
        private final String desc;

        CurrCodeEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }

    /**
     * 入账模块类型
     */
    @Getter
    enum AccountModuleType implements PurchasePaymentEnum {
        LEDGER("ledger", " 总账"),
        PAYABLE("payable", "应付")
        ;

        private final String code;
        private final String desc;

        AccountModuleType(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }

    /**
     * 提现付款状态
     */
    @Getter
    enum WithdrawStatus implements PurchasePaymentEnum {

        PAID("PAID", "已付款"),
        APPROVED("APPROVED", "付款已审批"),
        APPROVING("APPROVING", "付款审批中"),
        ;

        private final String code;
        private final String desc;

        WithdrawStatus(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }
}
