package com.elitesland.tw.tw5.server.prd.salecon.controller;

import com.elitesland.tw.tw5.api.prd.salecon.payload.ConPurchaseDemandPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConPurchaseDemandQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConPurchaseDemandService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 采购需求处理
 *
 * @author likunpeng
 * @date 2023-03-29
 */
@Api(tags = "采购需求处理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/contract/purchaseDemand")
@Slf4j
public class ConPurchaseDemandController {

    private final ConPurchaseDemandService conPurchaseDemandService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody ConPurchaseDemandPayload payload){
        return TwOutputUtil.ok(conPurchaseDemandService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody ConPurchaseDemandPayload payload){
        return TwOutputUtil.ok(conPurchaseDemandService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(conPurchaseDemandService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(ConPurchaseDemandQuery query) {
        return TwOutputUtil.ok(conPurchaseDemandService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(ConPurchaseDemandQuery query) {
        return TwOutputUtil.ok(conPurchaseDemandService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        conPurchaseDemandService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 根据合同ID查询采购需求
     * @param saleConId
     * @return result
     */
    @GetMapping("/demand/{saleConId}")
    @UdcNameClass
    @ApiOperation("根据合同ID查询")
    public TwOutputUtil queryBySaleConId(@PathVariable Long saleConId) {
        return TwOutputUtil.ok(conPurchaseDemandService.queryBySaleConId(saleConId));
    }

}
