package com.elitesland.tw.tw5.server.prd.salecon.controller;


import com.elitesland.tw.tw5.api.prd.salecon.payload.ConPurchaseDemandDPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConPurchaseDemandDQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConPurchaseDemandDService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;

/**
 * 采购需求处理明细
 *
 * @author likunpeng
 * @date 2023-03-29
 */
@Api(tags = "采购需求处理明细")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/contract/purchaseDemandD")
@Slf4j
public class ConPurchaseDemandDController {

    private final ConPurchaseDemandDService conPurchaseDemandDService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody ConPurchaseDemandDPayload payload){
        return TwOutputUtil.ok(conPurchaseDemandDService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody ConPurchaseDemandDPayload payload){
        return TwOutputUtil.ok(conPurchaseDemandDService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(conPurchaseDemandDService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(ConPurchaseDemandDQuery query) {
        return TwOutputUtil.ok(conPurchaseDemandDService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(ConPurchaseDemandDQuery query) {
        return TwOutputUtil.ok(conPurchaseDemandDService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        conPurchaseDemandDService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 批量导出活动excel
     *
     * @param query 查询条件
     * @return result
     */
    @GetMapping("/downloadPurDemand")
    public void downloadPurDemand(HttpServletResponse response, ConPurchaseDemandDQuery query) {
        conPurchaseDemandDService.downloadPurDemand(response, query);
    }
}
