package com.elitesland.tw.tw5.server.prd.salecon.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivablePlanConfirmPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivablePlanConfirmQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanConfirmVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConReceivablePlanConfirmDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.QConReceivablePlanConfirmDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConReceivablePlanConfirmRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 收款计划确认单
 *
 * @author lemon
 * @date 2023-12-23
 */
@Repository
@RequiredArgsConstructor
public class ConReceivablePlanConfirmDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final ConReceivablePlanConfirmRepo repo;
    private final QConReceivablePlanConfirmDO qdo = QConReceivablePlanConfirmDO.conReceivablePlanConfirmDO;
    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<ConReceivablePlanConfirmVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(ConReceivablePlanConfirmVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                //qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 确认单编号
                qdo.confirmNo,
                // 合同ID
                qdo.contractId,
                // 关联收款计划ID
                qdo.recePlanId,
                // 收款计划编号-收款号
                qdo.receNo,
                // 预付款计划-预计收款日期
                qdo.expectReceDate,
                // 提示类型备用
                qdo.tipsType,
                // 提示信息
                qdo.tips,
                // 销售负责人修改原因
                qdo.salesRemark,
                // 项目经理修改原因
                qdo.pmRemark,
                // 预计收款日期调整
                qdo.adjExpectReceDate,
                // 由项目经理确认 0 不需要 1需要
                qdo.pmConfirm,
                // 已付款由财务确认 0不需要 1需要
                qdo.financeConfirm,
                // 是否发送催款函 0 不需要 1需要
                qdo.sendPaymentRequest,
                // 预计收款日期确认无误？ 0 否 1是
                qdo.receDateConfirm,
                // 申请状态
                qdo.applyStatus,
                // 申请人用户ID
                qdo.applyUserId,
                qdo.procInstId,
                qdo.procInstStatus,
                qdo.submitTime,
                qdo.approvedTime
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<ConReceivablePlanConfirmVO> getJpaQueryWhere(ConReceivablePlanConfirmQuery query) {
        JPAQuery<ConReceivablePlanConfirmVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(ConReceivablePlanConfirmQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(ConReceivablePlanConfirmQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 确认单编号 精确 */
        if (!ObjectUtils.isEmpty(query.getConfirmNo())) {
            list.add(qdo.confirmNo.eq(query.getConfirmNo()));
        }
        /** 合同ID 精确 */
        if (!ObjectUtils.isEmpty(query.getContractId())) {
            list.add(qdo.contractId.eq(query.getContractId()));
        }
        /** 关联收款计划ID 精确 */
        if (!ObjectUtils.isEmpty(query.getRecePlanId())) {
            list.add(qdo.recePlanId.eq(query.getRecePlanId()));
        }
        /** 收款计划编号-收款号 精确 */
        if (!ObjectUtils.isEmpty(query.getReceNo())) {
            list.add(qdo.receNo.eq(query.getReceNo()));
        }
        /** 预付款计划-预计收款日期 精确 */
        if (!ObjectUtils.isEmpty(query.getExpectReceDate())) {
            list.add(qdo.expectReceDate.eq(query.getExpectReceDate()));
        }
        /** 提示类型备用 精确 */
        if (!ObjectUtils.isEmpty(query.getTipsType())) {
            list.add(qdo.tipsType.eq(query.getTipsType()));
        }
        /** 提示信息 精确 */
        if (!ObjectUtils.isEmpty(query.getTips())) {
            list.add(qdo.tips.eq(query.getTips()));
        }
        /** 销售负责人修改原因 精确 */
        if (!ObjectUtils.isEmpty(query.getSalesRemark())) {
            list.add(qdo.salesRemark.eq(query.getSalesRemark()));
        }
        /** 项目经理修改原因 精确 */
        if (!ObjectUtils.isEmpty(query.getPmRemark())) {
            list.add(qdo.pmRemark.eq(query.getPmRemark()));
        }
        /** 预计收款日期调整 精确 */
        if (!ObjectUtils.isEmpty(query.getAdjExpectReceDate())) {
            list.add(qdo.adjExpectReceDate.eq(query.getAdjExpectReceDate()));
        }
        /** 由项目经理确认 0 不需要 1需要 精确 */
        if (!ObjectUtils.isEmpty(query.getPmConfirm())) {
            list.add(qdo.pmConfirm.eq(query.getPmConfirm()));
        }
        /** 已付款由财务确认 0不需要 1需要 精确 */
        if (!ObjectUtils.isEmpty(query.getFinanceConfirm())) {
            list.add(qdo.financeConfirm.eq(query.getFinanceConfirm()));
        }
        /** 是否发送催款函 0 不需要 1需要 精确 */
        if (!ObjectUtils.isEmpty(query.getSendPaymentRequest())) {
            list.add(qdo.sendPaymentRequest.eq(query.getSendPaymentRequest()));
        }
        /** 预计收款日期确认无误？ 0 否 1是 精确 */
        if (!ObjectUtils.isEmpty(query.getReceDateConfirm())) {
            list.add(qdo.receDateConfirm.eq(query.getReceDateConfirm()));
        }
        /** 申请状态 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyStatus())) {
            list.add(qdo.applyStatus.eq(query.getApplyStatus()));
        }
        /** 申请人用户ID 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyUserId())) {
            list.add(qdo.applyUserId.eq(query.getApplyUserId()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public ConReceivablePlanConfirmVO queryByKey(Long id) {
        JPAQuery<ConReceivablePlanConfirmVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<ConReceivablePlanConfirmVO> queryListDynamic(ConReceivablePlanConfirmQuery query) {
        JPAQuery<ConReceivablePlanConfirmVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<ConReceivablePlanConfirmVO> queryPaging(ConReceivablePlanConfirmQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<ConReceivablePlanConfirmVO> jpaQuery = getJpaQueryWhere(query);
        List<ConReceivablePlanConfirmVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<ConReceivablePlanConfirmVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public ConReceivablePlanConfirmDO save(ConReceivablePlanConfirmDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<ConReceivablePlanConfirmDO> saveAll(List<ConReceivablePlanConfirmDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(ConReceivablePlanConfirmPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 确认单编号
        if (payload.getConfirmNo() != null) {
            update.set(qdo.confirmNo, payload.getConfirmNo());
        }
        // 合同ID
        if (payload.getContractId() != null) {
            update.set(qdo.contractId, payload.getContractId());
        }
        // 关联收款计划ID
        if (payload.getRecePlanId() != null) {
            update.set(qdo.recePlanId, payload.getRecePlanId());
        }
        // 收款计划编号-收款号
        if (payload.getReceNo() != null) {
            update.set(qdo.receNo, payload.getReceNo());
        }
        // 预付款计划-预计收款日期
        if (payload.getExpectReceDate() != null) {
            update.set(qdo.expectReceDate, payload.getExpectReceDate());
        }
        // 提示类型备用
        if (payload.getTipsType() != null) {
            update.set(qdo.tipsType, payload.getTipsType());
        }
        // 提示信息
        if (payload.getTips() != null) {
            update.set(qdo.tips, payload.getTips());
        }
        // 销售负责人修改原因
        if (payload.getSalesRemark() != null) {
            update.set(qdo.salesRemark, payload.getSalesRemark());
        }
        // 项目经理修改原因
        if (payload.getPmRemark() != null) {
            update.set(qdo.pmRemark, payload.getPmRemark());
        }
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        // 预计收款日期调整
        if (payload.getAdjExpectReceDate() != null) {
            update.set(qdo.adjExpectReceDate, payload.getAdjExpectReceDate());
        }
        // 由项目经理确认 0 不需要 1需要
        if (payload.getPmConfirm() != null) {
            update.set(qdo.pmConfirm, payload.getPmConfirm());
        }
        // 已付款由财务确认 0不需要 1需要
        if (payload.getFinanceConfirm() != null) {
            update.set(qdo.financeConfirm, payload.getFinanceConfirm());
        }
        // 是否发送催款函 0 不需要 1需要
        if (payload.getSendPaymentRequest() != null) {
            update.set(qdo.sendPaymentRequest, payload.getSendPaymentRequest());
        }
        // 预计收款日期确认无误？ 0 否 1是
        if (payload.getReceDateConfirm() != null) {
            update.set(qdo.receDateConfirm, payload.getReceDateConfirm());
        }
        // 申请状态
        if (payload.getApplyStatus() != null) {
            update.set(qdo.applyStatus, payload.getApplyStatus());
        }
        // 申请人用户ID
        if (payload.getApplyUserId() != null) {
            update.set(qdo.applyUserId, payload.getApplyUserId());
        }
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        if (payload.getSubmitTime() != null) {
            update.set(qdo.submitTime, payload.getSubmitTime());
        }
        if (payload.getApprovedTime() != null) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }
        if (payload.getDeleteFlag() != null) {
            update.set(qdo.deleteFlag, payload.getDeleteFlag());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 确认单编号
            if (nullFields.contains("confirmNo")) {
                update.setNull(qdo.confirmNo);
            }
            // 合同ID
            if (nullFields.contains("contractId")) {
                update.setNull(qdo.contractId);
            }
            // 关联收款计划ID
            if (nullFields.contains("recePlanId")) {
                update.setNull(qdo.recePlanId);
            }
            // 收款计划编号-收款号
            if (nullFields.contains("receNo")) {
                update.setNull(qdo.receNo);
            }
            // 预付款计划-预计收款日期
            if (nullFields.contains("expectReceDate")) {
                update.setNull(qdo.expectReceDate);
            }
            // 提示类型备用
            if (nullFields.contains("tipsType")) {
                update.setNull(qdo.tipsType);
            }
            // 提示信息
            if (nullFields.contains("tips")) {
                update.setNull(qdo.tips);
            }
            // 销售负责人修改原因
            if (nullFields.contains("salesRemark")) {
                update.setNull(qdo.salesRemark);
            }
            // 项目经理修改原因
            if (nullFields.contains("pmRemark")) {
                update.setNull(qdo.pmRemark);
            }
            if (nullFields.contains("remark")) {
                update.setNull(qdo.remark);
            }
            // 预计收款日期调整
            if (nullFields.contains("adjExpectReceDate")) {
                update.setNull(qdo.adjExpectReceDate);
            }
            // 由项目经理确认 0 不需要 1需要
            if (nullFields.contains("pmConfirm")) {
                update.setNull(qdo.pmConfirm);
            }
            // 已付款由财务确认 0不需要 1需要
            if (nullFields.contains("financeConfirm")) {
                update.setNull(qdo.financeConfirm);
            }
            // 是否发送催款函 0 不需要 1需要
            if (nullFields.contains("sendPaymentRequest")) {
                update.setNull(qdo.sendPaymentRequest);
            }
            // 预计收款日期确认无误？ 0 否 1是
            if (nullFields.contains("receDateConfirm")) {
                update.setNull(qdo.receDateConfirm);
            }
            // 申请状态
            if (nullFields.contains("applyStatus")) {
                update.setNull(qdo.applyStatus);
            }
            // 申请人用户ID
            if (nullFields.contains("applyUserId")) {
                update.setNull(qdo.applyUserId);
            }

            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qdo.procInstStatus);
            }
            if (nullFields.contains("submitTime")) {
                update.setNull(qdo.submitTime);
            }
            if (nullFields.contains("approvedTime")) {
                update.setNull(qdo.approvedTime);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

