package com.elitesland.tw.tw5.server.prd.salecon.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 合同开票批次
 *
 * @author likunpeng
 * @date 2023-07-19
 */
@Entity
@Table(name = "con_inv_batch", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "con_inv_batch", comment = "合同开票批次")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ConInvBatchDO extends BaseModel implements Serializable  {
    /** 批次号 */
    @Comment("批次号")
    @Column()
    private String batchNo;
    /** 批次状态 已申请/待开票/已开票/已取消 */
    @Comment("批次状态 已申请/待开票/已开票/已取消")
    @Column()
    private String batchStatus;
    /** prd_ab_invoice 发票信息ID */
    @Comment("prd_ab_invoice 发票信息ID")
    @Column()
    private Long invoiceId;
    /** 发票抬头 */
    @Comment("发票抬头")
    @Column()
    private String invTitle;
    /** 发票类型 */
    @Comment("发票类型")
    @Column()
    private String invType;
    /** 税率 */
    @Comment("税率")
    @Column()
    private BigDecimal taxRate;
    /** 递送方式 */
    @Comment("递送方式")
    @Column()
    private String deliMethod;
    /** 收件人 */
    @Comment("收件人")
    @Column()
    private String contactPerson;
    /** 收件人地址 文本录入 */
    @Comment("收件人地址 文本录入")
    @Column()
    private String invAddr;
    /** 收件人电话 */
    @Comment("收件人电话")
    @Column()
    private String invTel;
    /** 开户行 */
    @Comment("开户行")
    @Column()
    private String bankName;
    /** 账号 */
    @Comment("账号")
    @Column()
    private String accountNo;
    /** 开票日期 */
    @Comment("开票日期")
    @Column()
    private LocalDate batchDate;
    /** 发票内容 */
    @Comment("发票内容")
    @Column()
    private String invContent;
    /** 付款方式 */
    @Comment("付款方式")
    @Column()
    private String payMethod;
    /** 开票说明 */
    @Comment("开票说明")
    @Column()
    private String invDesc;
    /** 开票主体公司ID */
    @Comment("开票主体公司ID")
    @Column()
    private Long invOuId;
    /** 开票金额 */
    @Comment("开票金额")
    @Column()
    private BigDecimal invAmt;
    /** 是否自动保存开票信息到地址簿 0 不保存 1保存 */
    @Comment("是否自动保存开票信息到地址簿 0 不保存 1保存")
    @Column()
    private Integer saveAbFlag;
    /** 预计到账日期 */
    @Comment("预计到账日期")
    @Column()
    private LocalDate antiRecvDate;
    /** 是否已经开票 */
    @Comment("是否已经开票")
    @Column()
    private Integer alreadyInvFlag;
    /**
     * 产品大类（销售合同的销售大类）
     */
    @Comment("产品大类")
    @Column()
    private String productClass;

    /**
     * 邮件接收人（内部）
     */
    @Comment("邮件接收人（内部）")
    @Column()
    String recipientInner;

    /**
     * 邮件接收人（外部）
     */
    @Comment("邮件接收人（外部）")
    @Column()
    String recipientOuter;

    /** 是否自动开票:1 是；0 否 */
    @Comment("是否自动开票")
    @Column()
    private Integer invFlag;

    /** 邮件通知:1 是；0 否 */
    @Comment("邮件通知")
    @Column()
    private Integer emailFlag;

    /** 开票备注，将开票说明加工后传递百望 */
    @Comment("开票备注")
    @Column()
    private String invRemark;



    /** 地址 存放地址簿中的信息 */
    @Comment("地址 存放地址簿中的信息")
    @Column()
    private String addr;
    /** 退票原因 */
    @Comment("退票原因")
    @Column()
    private String disDisc;
    /** 收件人邮箱 */
    @Comment("收件人邮箱")
    @Column()
    private String invEmail;
    /** 发票商品ID 关联 T_INVOICE_ITEM.ID */
    @Comment("发票商品ID 关联 T_INVOICE_ITEM.ID")
    @Column()
    private Long invItemId;
    /** 流程实例ID */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    /** 流程审批状态 */
    @Comment("流程审批状态")
    @Column()
    private ProcInstStatus procInstStatus;
    /** 提交时间 */
    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;
    /** 审批时间 */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;
    /** 附件 */
    @Comment("附件")
    @Column()
    private String fileCode;
    /** 附件文件夹 */
    @Comment("附件文件夹")
    @Column()
    private String folderId;

    /**4.0的合同开票id*/
    @Comment("4.0的合同开票id")
    @Column()
    private Long invBatchIdV4;

    /**销售子合同id(用于退票解绑后，记录销售子合同来源，项目汇报用此字段)*/
    @Comment("销售子合同id")
    @Column()
    private Long saleContractId;


    /**
     * 工作类型
     */
    @Comment("工作类型")
    @Column()
    private String workType;


    /**
     * 结算单已回收
     */
    @Comment("结算单已回收")
    @Column()
    private Integer recycleSettleFlag;

    /** jde单据公司 */
    @Comment("jde单据公司")
    @Column()
    private String jdeCompany;
    /** jde单据号  */
    @Comment("jde单据号 ")
    @Column()
    private String jdeDocumentNo;
    /** jde单据类型 */
    @Comment("jde单据类型")
    @Column()
    private String jdeDocumentType;
    /** jde付款项 */
    @Comment("jde付款项")
    @Column()
    private String jdePaymentItem;
    /** jde发票凭证 */
    @Comment("jde发票凭证")
    @Column()
    private String jdeInvoiceVoucher;
    /** jde发票凭证失败原因 */
    @Comment("jde发票凭证失败原因")
    @Column()
    private String jdeInvoiceFailReason;


    /** jde发票凭证失败原因 */
    @Comment("jde发票凭证状态")
    @Column()
    private String jdeInvoiceStatus;

    /** jde发票凭证失败原因 */
    @Comment("jde核销收款状态")
    @Column()
    private String jdeReceiveWriteOffStatus;

    public void copy(ConInvBatchDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
