package com.elitesland.tw.tw5.server.prd.salecon.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * ConInvSettingController
 *
 * @author zoey
 * @date 2024-03-14
 */
@Entity
@Table(name = "con_inv_setting", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "con_inv_setting", comment = "ConInvSettingController")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ConInvSettingDO extends BaseModel implements Serializable  {
    /** 开票年度 */
    @Comment("开票年度")
    @Column(name = "inv_year",nullable = false)
    private Integer invYear;
    /** 开票主体 */
    @Comment("开票主体")
    @Column(name = "inv_ou_id",nullable = false)
    private Long invOuId;
    /** 状态:1 有效；0 无效 */
    @Comment("状态:1 有效；0 无效")
    @Column()
    private Integer effective;
    /** 月最后开票日 */
    @Comment("月最后开票日")
    @Column()
    private Integer deadline;

    public void copy(ConInvSettingDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
