package com.elitesland.tw.tw5.server.prd.salecon.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 采购需求处理明细
 *
 * @author likunpeng
 * @date 2023-03-29
 */
@Entity
@Table(name = "con_purchase_demand_d", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "con_purchase_demand_d", comment = "采购需求处理明细")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ConPurchaseDemandDDO extends BaseModel implements Serializable  {

    /** 需求编号 */
    @Comment("需求编号")
    @Column()
    private String demandCode;
    /** 需求总金额 */
    @Comment("需求类型")
    @Column()
    private String demandType;
    /** 销售合同id */
    @Comment("销售合同id")
    @Column()
    private Long saleConId;

    /** 需求日期 */
    @Comment("需求日期")
    @Column()
    private LocalDate demandDate;
    /** 需求负责人 */
    @Comment("需求负责人")
    @Column()
    private Long demandDirectorUserId;
    /** 建议供应商ID */
    @Comment("建议供应商ID")
    @Column()
    private Long supplierId;
    /** 需求说明 */
    @Comment("需求说明")
    @Column()
    private String demandSaid;
    /** 关联产品 */
    @Comment("关联产品")
    @Column()
    private Long productId;

    /** 采购大类ID */
    @Comment("采购大类ID")
    @Column()
    private Long productClassId;

    /** 采购大类名称 */
    @Comment("采购大类名称")
    @Column()
    private String productClass;

    /** 采购小类ID */
    @Comment("采购小类ID")
    @Column()
    private Long productSubClassId;

    /** 采购小类名称 */
    @Comment("采购小类名称")
    @Column()
    private String productSubClass;

    /** 数量 */
    @Comment("数量")
    @Column()
    private Integer demandNum;
    /** 含税单价 */
    @Comment("含税单价")
    @Column()
    private BigDecimal taxPrice;
    /** 货币 */
    @Comment("货币")
    @Column()
    private String symbol;
    /** 税率 */
    @Comment("税率")
    @Column()
    private BigDecimal taxRate;
    /** 含税总额 */
    @Comment("含税总额")
    @Column()
    private BigDecimal taxAmt;
    /** 不含税总额 */
    @Comment("不含税总额")
    @Column()
    private BigDecimal notTaxAmt;
    /** 采购合同id */
    @Comment("采购合同id")
    @Column()
    private Long purContractId;
    /** 采购需求Id */
    @Comment("采购需求Id")
    @Column()
    private Long purDemandId;
    /** 需求状态 */
    @Comment("需求状态")
    @Column()
    private String demandStatus;

    /** 4.0id */
    @Comment("4.0id")
    @Column()
    private Long demandDetailIdV4;

    @Comment("4.0id")
    @Column()
    private String contractNo;
    public void copy(ConPurchaseDemandDDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
