package com.elitesland.tw.tw5.server.prd.salecon.repo;

import com.elitesland.tw.tw5.server.prd.salecon.entity.ConReceivablePlanDO;
import org.springframework.data.repository.query.Param;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;

/**
 * 收款计划
 *
 * @author likunpeng
 * @date 2023-03-29
 */
public interface ConReceivablePlanRepo extends JpaRepository<ConReceivablePlanDO, Long>, JpaSpecificationExecutor<ConReceivablePlanDO> {

    @Query(value = " select * from con_receivable_plan e where e.modify_time >= ?1", nativeQuery = true)
    List<ConReceivablePlanDO> findByModifyTimeStart(String format);

    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update con_receivable_plan set modify_time=now()  where id=?1",nativeQuery = true)
    @Modifying
    void updateRemark(Long id);

    @Transactional
    @Modifying
    @Query(value = "update ConReceivablePlanDO set receStatus = ?2,invStatus=?3,alreadyInvAmt=?4,alreadyReceAmt=?5,modifyTime=current_time where  id =?1")
    void updateStatus(Long recvplanIdV5, String receStatus, String batchStatus, BigDecimal alreadyInvAmt,BigDecimal alreadyReceAmt);

    @Transactional
    @Modifying
    @Query(value = "update ConReceivablePlanDO set receStatus = ?2,modifyTime=current_time  where  invBatchId = ?1")
    void updateReceStatusByBatchId(Long invBatchId, String code);

    @Transactional
    @Modifying
    @Query(value = "update ConReceivablePlanDO set alreadyInvAmt = receAmt,notInvAmt = 0,modifyTime=current_time  where  invBatchId = ?1")
    void updateInvAmt (Long invBatchId);

    @Transactional
    @Modifying
    @Query(value = "update ConReceivablePlanDO set alreadyInvAmt = receAmt,notInvAmt = 0,modifyTime=current_time,receStatus=?2  where  id = ?1")
    void updateInvAmtAndReceStatus (Long invBatchId,String receStatus);

    @Transactional
    @Modifying
    @Query(value = "update ConReceivablePlanDO set alreadyInvAmt = 0,notInvAmt = receAmt,modifyTime=current_time  where  invBatchId = ?1")
    void updateInvAmtBack (Long invBatchId);

    @Transactional
    @Modifying
    @Query(value = "update ConReceivablePlanDO set invBatchId = null,alreadyInvAmt = 0,notInvAmt = receAmt,modifyTime=current_time  where  invBatchId = ?1")
    void unbindBatchByBatchId(Long valueOf);


    @Transactional
    @Modifying
    @Query(value = "update ConReceivablePlanDO set invBatchId = null,alreadyInvAmt = 0,notInvAmt = receAmt,modifyTime=current_time,receStatus=?2  where  id = ?1")
    void unbindBatchById(Long id,String receStatus);
    ConReceivablePlanDO findByReceivePlanIdV4(Long idV4);

    /**
     * 根绝合同Id列表查询收款计划列表
     * @param deleteFlag
     * @param saleConIds
     * @return
     */
    List<ConReceivablePlanDO> findAllByDeleteFlagAndSaleConIdIn(Integer deleteFlag,List<Long> saleConIds);

    Optional<ConReceivablePlanDO> findByIdAndDeleteFlag(Long id,Integer deleteFlag);

    List<ConReceivablePlanDO> findAllByInvBatchIdAndDeleteFlag(Long invBatchId,Integer deleteFlag);

    /**
     * 累加实际收款金额1
     *
     * @param id
     * @param amt
     * @return
     */
    @Transactional
    @Modifying
    @Query(value = "UPDATE ConReceivablePlanDO SET actualRecvAmt =(IFNULL(actualRecvAmt,0) + IFNULL(?2,0)),actualRecvDate = ?3,receStatus = '2',modifyTime=current_time WHERE ID = ?1")
    int increamentActualRecvAmt(@Param("id") long id, @Param("amt") BigDecimal amt, @Param("recvDate") LocalDate recvDate);

    /**
     * 回置收款状态
     *
     * @param id
     * @return
     */
    @Transactional
    @Modifying
    @Query(value = "UPDATE ConReceivablePlanDO SET receStatus =?2,modifyTime=current_time WHERE id = ?1 AND actualRecvAmt >= receAmt")
    int setRecvStatus(@Param("id") long id, @Param("recvStatus") String recvStatus);

    @Transactional
    @Modifying
    @Query(value = "UPDATE ConReceivablePlanDO SET expectReceDate = (select antiRecvDate from ConInvBatchDO where id= ?1),modifyTime=current_time WHERE invBatchId = ?1")
    int updateExpectRecvDate(@Param("invId") Long invId);

    @Query(value = " select receive_plan_id_v4 from con_receivable_plan e where e.id = ?1", nativeQuery = true)
    Long queryV4Id(Long recvplanId);


//    @Query("SELECT id FROM ConReceivablePlanDO WHERE invBatchId=?1")
//    List<Long> queryIdByBatchId(Long valueOf);



}
