package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemFunctionDataPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFunctionDataQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemFunctionDataService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFunctionDataVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemFunctionDataConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemFunctionDataDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemFunctionDataDO;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 标准样例service
 *
 * @author wangding
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdSystemFunctionDataServiceImpl implements PrdSystemFunctionDataService {
    private final PrdSystemFunctionDataDAO dao;
    private final CacheUtil cacheUtil;


    @Transactional
    @Override
    public PrdSystemFunctionDataVO insert(PrdSystemFunctionDataPayload payload) {

        PrdSystemFunctionDataDO ado = PrdSystemFunctionDataConvert.INSTANCE.toDo(payload);
        dao.save(ado);
        cacheUtil.loadSystemFunctionDataCache();
        return PrdSystemFunctionDataConvert.INSTANCE.toVo(ado);

    }

    @Transactional
    @Override
    public Long update(PrdSystemFunctionDataPayload payload) {
        dao.updateByKeyDynamic(payload);
        cacheUtil.loadSystemFunctionDataCache();
        return 0L;
    }

    @Transactional
    @Override
    public boolean delete(List<Long> keys) {
        boolean isDelete = true;
        long delNum = dao.delete(keys);
        if (delNum <= 0) {
            isDelete = false;
        }
        cacheUtil.loadSystemFunctionDataCache();
        return isDelete;
    }

    @Override
    public PrdSystemFunctionDataVO queryByKey(Long key) {

        return dao.queryByKey(key);
    }

    @Override
    public PagingVO<PrdSystemFunctionDataVO> paging(PrdSystemFunctionDataQuery query) {
        return dao.queryPaging(query);
    }

}
