package com.elitesland.tw.tw5.server.prd.ts.controller;


import com.elitesland.tw.tw5.api.prd.ts.payload.TsNotaskApprovalConfigRulePayload;
import com.elitesland.tw.tw5.api.prd.ts.query.TsNotaskApprovalConfigRuleQuery;
import com.elitesland.tw.tw5.api.prd.ts.service.TsNotaskApprovalConfigRuleService;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsNotaskApprovalConfigRuleVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 无任务工时审批配置规则
 *
 * @author zoey
 * @date 2024-04-30
 */
@Api(tags = "无任务工时审批配置规则")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/tsNotaskApprovalConfigRule")
@Slf4j
public class TsNotaskApprovalConfigRuleController {

private final TsNotaskApprovalConfigRuleService tsNotaskApprovalConfigRuleService;

    /**
     * 无任务工时审批配置规则-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("无任务工时审批配置规则-新增")
    public TwOutputUtil<TsNotaskApprovalConfigRuleVO> insert(@RequestBody TsNotaskApprovalConfigRulePayload payload){
         return TwOutputUtil.ok(tsNotaskApprovalConfigRuleService.insert(payload));
    }

    /**
     * 无任务工时审批配置规则-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("无任务工时审批配置规则-更新")
    public TwOutputUtil<TsNotaskApprovalConfigRuleVO> update(@RequestBody TsNotaskApprovalConfigRulePayload payload){
        return TwOutputUtil.ok(tsNotaskApprovalConfigRuleService.update(payload));
    }

    /**
     * 无任务工时审批配置规则-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("无任务工时审批配置规则-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody TsNotaskApprovalConfigRulePayload payload){
        return TwOutputUtil.ok(tsNotaskApprovalConfigRuleService.updateByKeyDynamic(payload));
    }

    /**
     * 无任务工时审批配置规则-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("无任务工时审批配置规则-主键查询")
    public TwOutputUtil<TsNotaskApprovalConfigRuleVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(tsNotaskApprovalConfigRuleService.queryByKey(key));
    }

    /**
     * 无任务工时审批配置规则-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("无任务工时审批配置规则-分页")
    public TwOutputUtil<PagingVO<TsNotaskApprovalConfigRuleVO>> paging(TsNotaskApprovalConfigRuleQuery query) {
        return TwOutputUtil.ok(tsNotaskApprovalConfigRuleService.queryPaging(query));
    }

    /**
     * 无任务工时审批配置规则-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("无任务工时审批配置规则-查询列表")
    public TwOutputUtil<List<TsNotaskApprovalConfigRuleVO>> queryList(TsNotaskApprovalConfigRuleQuery query) {
        return TwOutputUtil.ok(tsNotaskApprovalConfigRuleService.queryListDynamic(query));
    }

    /**
     * 无任务工时审批配置规则-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("无任务工时审批配置规则-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         tsNotaskApprovalConfigRuleService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

