package com.elitesland.tw.tw5.server.prd.ts.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 工时审批配置管理
 *
 * @author carl
 * @date 2024-04-29
 */
@Entity
@Table(name = "ts_approval_config", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "ts_approval_config", comment = "工时审批配置管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TsApprovalConfigDO extends BaseModel implements Serializable {
    /**
     * 年度
     */
    @Comment("年度")
    @Column()
    private Integer finYear;
    /**
     * 成本级别
     */
    @Comment("成本级别")
    @Column()
    private String costLevel;
    /**
     * 事由类型
     */
    @Comment("事由类型")
    @Column()
    private String reasonType;
    /**
     * 工作类型
     */
    @Comment("工作类型")
    @Column()
    private String workType;
    /**
     * 交付bu_id
     */
    @Comment("交付bu_id")
    @Column()
    private Long deliBuId;
    /**
     * 资源类型
     */
    @Comment("资源类型")
    @Column()
    private String resType;
    /**
     * 预算类型（风险等级1，百分比2）
     */
    @Comment("预算类型（风险等级1，百分比2）")
    @Column()
    private String budgetType;
    /**
     * 预算情况(风险等级)
     */
    @Comment("预算情况(风险等级)")
    @Column()
    private String budgetData;
    /**
     * 预算情况(百分比)
     */
    @Comment("预算情况(百分比)")
    @Column()
    private BigDecimal budgetData0;
    /**
     * 审批类型1（指定角色1，指定用户2）
     */
    @Comment("审批类型1（指定角色1，指定用户2）")
    @Column()
    private String approvalType1;
    /**
     * 审批资源1
     */
    @Comment("审批资源1")
    @Column()
    private String approvalSource1;
    /**
     * 审批类型2
     */
    @Comment("审批类型2")
    @Column()
    private String approvalType2;
    /**
     * 审批资源2
     */
    @Comment("审批资源2")
    @Column()
    private String approvalSource2;
    /**
     * 审批类型3
     */
    @Comment("审批类型3")
    @Column()
    private String approvalType3;
    /**
     * 审批资源3
     */
    @Comment("审批资源3")
    @Column()
    private String approvalSource3;
    /**
     * 状态标记（有效1.无效0）
     */
    @Comment("状态标记（有效1.无效0）")
    @Column(columnDefinition = "tinyint  DEFAULT 1")
    private Integer statusFlag;

    public void copy(TsApprovalConfigDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
