/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.adm.service;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.adm.payload.AdmTripTicketDataPayload;
import com.elitesland.tw.tw5.api.prd.adm.payload.AdmTripTicketPayload;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmTripTicketQuery;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmTripTicketService;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmTripTicketVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.prd.adm.convert.AdmTripTicketConvert;
import com.elitesland.tw.tw5.server.prd.adm.dao.AdmTripTicketDAO;
import com.elitesland.tw.tw5.server.prd.adm.entity.AdmTripTicketDO;
import com.elitesland.tw.tw5.server.prd.adm.repo.AdmTripTicketRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class AdmTripTicketServiceImpl
extends BaseServiceImpl
implements AdmTripTicketService {
    private static final Logger log = LoggerFactory.getLogger(AdmTripTicketServiceImpl.class);
    private final AdmTripTicketRepo admTripTicketRepo;
    private final AdmTripTicketDAO admTripTicketDAO;
    private final UdcUtil udcUtil;

    public PagingVO<AdmTripTicketVO> queryPaging(AdmTripTicketQuery query) {
        return this.admTripTicketDAO.queryPaging(query);
    }

    public List<AdmTripTicketVO> queryListDynamic(AdmTripTicketQuery query) {
        return this.admTripTicketDAO.queryListDynamic(query);
    }

    public AdmTripTicketVO queryByKey(Long key) {
        AdmTripTicketDO entity = this.admTripTicketRepo.findById(key).orElseGet(AdmTripTicketDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        AdmTripTicketVO vo = AdmTripTicketConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public AdmTripTicketVO insertOrUpdate(AdmTripTicketPayload payload) {
        if (payload.getApplyId() == null) {
            throw TwException.error("", "\u51fa\u5dee\u7533\u8bf7id\u4e0d\u53ef\u4e3a\u7a7a");
        }
        AdmTripTicketDO entityDo = AdmTripTicketConvert.INSTANCE.toDo(payload);
        return AdmTripTicketConvert.INSTANCE.toVo((AdmTripTicketDO)this.admTripTicketRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public AdmTripTicketVO update(AdmTripTicketPayload payload) {
        AdmTripTicketDO entity = this.admTripTicketRepo.findById(payload.getId()).orElseGet(AdmTripTicketDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        AdmTripTicketDO entityDo = AdmTripTicketConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return AdmTripTicketConvert.INSTANCE.toVo((AdmTripTicketDO)this.admTripTicketRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(AdmTripTicketPayload payload) {
        AdmTripTicketDO entity = this.admTripTicketRepo.findById(payload.getId()).orElseGet(AdmTripTicketDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.admTripTicketDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.admTripTicketDAO.deleteSoft(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public List<AdmTripTicketVO> bacthInsert(AdmTripTicketDataPayload payload) {
        if (payload == null) {
            throw TwException.error("", "\u8ba2\u7968\u6570\u636e\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (payload.getApplyId() == null) {
            throw TwException.error("", "\u51fa\u5dee\u7533\u8bf7\u6570\u636e\u4e0d\u53ef\u4e3a\u7a7a");
        }
        List<AdmTripTicketVO> admTripTicketVOS = this.admTripTicketDAO.queryListByApplyId(payload.getApplyId());
        if (!ObjectUtils.isEmpty((Object)payload.getPayloads())) {
            ArrayList collect = new ArrayList();
            ArrayList entityDos = new ArrayList();
            payload.getPayloads().forEach(payload0 -> {
                if (payload0.getId() != null) {
                    collect.add(payload0.getId());
                }
                payload0.setApplyId(payload.getApplyId());
                entityDos.add(AdmTripTicketConvert.INSTANCE.toDo((AdmTripTicketPayload)payload0));
            });
            List<Long> delIds = admTripTicketVOS.stream().filter(vo -> !collect.contains(vo.getId())).map(BaseViewModel::getId).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(delIds)) {
                this.admTripTicketDAO.deleteSoft(delIds);
            }
            List admTripTicketDOS = this.admTripTicketRepo.saveAll(entityDos);
            return AdmTripTicketConvert.INSTANCE.toVos(admTripTicketDOS);
        }
        return null;
    }

    public void exportList(AdmTripTicketQuery query, HttpServletResponse response) throws IOException {
        String sheetName = "\u884c\u653f\u8ba2\u7968\u62a5\u8868";
        OrderItem orderItem = OrderItem.asc((String)"createTime");
        query.defaultOrder(orderItem);
        List<AdmTripTicketVO> admTripTicketVOS = this.queryListDynamic(query);
        if (admTripTicketVOS.size() > 50000) {
            throw TwException.error("500", "\u5bfc\u51fa\u6570\u636e\u8fc7\u5927\uff0c\u8bf7\u5206\u6279\u64cd\u4f5c\uff0c\u76ee\u524d\u5bfc\u51fa\u6570\u91cf\uff1a" + admTripTicketVOS.size());
        }
        List invBatchInvdtlVOS = this.udcUtil.translateList(admTripTicketVOS);
        Iterator iterator = invBatchInvdtlVOS.iterator();
        while (iterator.hasNext()) {
            AdmTripTicketVO invBatchInvdtlVO;
            invBatchInvdtlVO.setBookingDateStr((String)((invBatchInvdtlVO = (AdmTripTicketVO)iterator.next()).getBookingDate() == null ? "" : "" + invBatchInvdtlVO.getBookingDate()));
            invBatchInvdtlVO.setTripDateStr((String)(invBatchInvdtlVO.getTripDate() == null ? "" : "" + invBatchInvdtlVO.getTripDate()));
            invBatchInvdtlVO.setReimTimeStr((String)(invBatchInvdtlVO.getReimTime() == null ? "" : "" + invBatchInvdtlVO.getReimTime()));
        }
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), AdmTripTicketVO.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        ExcelUtil.excelHelper(sheet, AdmTripTicketVO.class, null);
        sheet.doWrite(invBatchInvdtlVOS);
    }

    public AdmTripTicketServiceImpl(AdmTripTicketRepo admTripTicketRepo, AdmTripTicketDAO admTripTicketDAO, UdcUtil udcUtil) {
        this.admTripTicketRepo = admTripTicketRepo;
        this.admTripTicketDAO = admTripTicketDAO;
        this.udcUtil = udcUtil;
    }
}

