/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.cal.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalAccountFreezePayload;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalAccountPayload;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalAccountTurnoverPayload;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalResourcePayload;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalTaskSettleWithdrawPayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalAccountQuery;
import com.elitesland.tw.tw5.api.prd.cal.query.CalEqvaCostQuery;
import com.elitesland.tw.tw5.api.prd.cal.query.CalEqvaIncomeQuery;
import com.elitesland.tw.tw5.api.prd.cal.query.CalResourcePriceQuery;
import com.elitesland.tw.tw5.api.prd.cal.query.CalSettlePriceQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalAccountFreezeService;
import com.elitesland.tw.tw5.api.prd.cal.service.CalAccountService;
import com.elitesland.tw.tw5.api.prd.cal.service.CalAccountTurnoverService;
import com.elitesland.tw.tw5.api.prd.cal.service.CalEqvaCostService;
import com.elitesland.tw.tw5.api.prd.cal.service.CalEqvaIncomeService;
import com.elitesland.tw.tw5.api.prd.cal.service.CalResourceService;
import com.elitesland.tw.tw5.api.prd.cal.service.CalSettlePriceService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalAccountVO;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalEqvaCostVO;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalEqvaIncomeVO;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalNormSettleVO;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalSettlePriceVO;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalTaskSettleVO;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalWideSettleVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsDistributeVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalAccTurTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalAccTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class CalResourceServiceImpl
extends BaseServiceImpl
implements CalResourceService {
    private static final Logger log = LoggerFactory.getLogger(CalResourceServiceImpl.class);
    private final CalSettlePriceService calSettlePriceService;
    private final CalEqvaIncomeService calEqvaIncomeService;
    private final CalEqvaCostService calEqvaCostService;
    private final CacheUtil cacheUtil;
    private final CalAccountService calAccountService;
    private final CalAccountFreezeService calAccountFreezeService;
    private final CalAccountTurnoverService calAccountTurnoverService;

    public BigDecimal querySettlePrice(CalResourcePriceQuery query) {
        CalEqvaCostQuery costQuery = new CalEqvaCostQuery();
        costQuery.setBuId(query.getToBuId());
        costQuery.setJobType1(query.getJobType1());
        costQuery.setJobType2(query.getJobType2());
        CalEqvaCostVO costView = this.calEqvaCostService.getEqvaCostPlus(costQuery);
        if (costView == null) {
            throw TwException.error("", "\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u5f53\u91cf\u6210\u672c");
        }
        CalSettlePriceQuery settlePriceQuery = new CalSettlePriceQuery();
        settlePriceQuery.setFromBuId(query.getFromBuId());
        settlePriceQuery.setToBuId(query.getToBuId());
        settlePriceQuery.setJobType1(query.getJobType1());
        settlePriceQuery.setJobType2(query.getJobType2());
        settlePriceQuery.setResId(query.getResId());
        settlePriceQuery.setProjId(query.getProjId());
        CalSettlePriceVO settlePricePlus = this.calSettlePriceService.getSettlePricePlus(settlePriceQuery);
        if (settlePricePlus == null) {
            throw TwException.error("", "\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u7ed3\u7b97\u5b9a\u4ef7");
        }
        BigDecimal eqvaCost = costView.getEqvaCost();
        BigDecimal markupPrice = settlePricePlus.getMarkupPrice();
        BigDecimal price = BigDecimal.valueOf(800L);
        if (settlePricePlus.getPriceStrategy() != null) {
            if (settlePricePlus.getPriceStrategy().equals("1")) {
                price = eqvaCost.add(eqvaCost.multiply(markupPrice).divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_DOWN));
            }
            if (settlePricePlus.getPriceStrategy().equals("2")) {
                price = eqvaCost.add(markupPrice);
            }
            if (settlePricePlus.getPriceStrategy().equals("3")) {
                price = markupPrice;
            }
        }
        return price;
    }

    public BigDecimal queryIncomePrice(CalResourcePriceQuery query) {
        PrdSystemSelectionVO prdSystemSelectionVO;
        if (query.getResId() == null) {
            throw TwException.error("", "\u63a5\u6536\u8d44\u6e90\u4e0d\u53ef\u4e3a\u7a7a");
        }
        CalEqvaIncomeQuery eqvaIncomeQuery = new CalEqvaIncomeQuery();
        eqvaIncomeQuery.setJobType1(query.getJobType1());
        eqvaIncomeQuery.setJobType2(query.getJobType2());
        eqvaIncomeQuery.setResId(query.getResId());
        eqvaIncomeQuery.setProjId(query.getProjId());
        PrdOrgEmployeeRefVO userDefaultOrg = this.cacheUtil.getUserDefaultOrg(query.getResId());
        if (userDefaultOrg == null) {
            throw TwException.error("", "\u63a5\u6536\u8d44\u6e90\u4e0d\u5728\u7ec4\u7ec7\u4f53\u7cfb\u5185");
        }
        String cityLevel = "3";
        String extString5 = userDefaultOrg.getExtString5();
        if (StringUtils.hasText((String)extString5) && (prdSystemSelectionVO = this.cacheUtil.querySystemSelection("org:employee:serviceaddr", extString5)) != null) {
            cityLevel = prdSystemSelectionVO.getExtString1();
        }
        eqvaIncomeQuery.setBuId(userDefaultOrg.getOrgId());
        eqvaIncomeQuery.setCoopType(userDefaultOrg.getCooperationMode());
        eqvaIncomeQuery.setCityLevel(cityLevel);
        CalEqvaIncomeVO eqvaSalary = this.calEqvaIncomeService.getEqvaSalary(eqvaIncomeQuery);
        if (eqvaSalary == null) {
            throw TwException.error("", "\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u8d44\u6e90\u6536\u5165\u914d\u7f6e");
        }
        return eqvaSalary.getPreeqvaAmt();
    }

    @Transactional(rollbackFor={Exception.class})
    public void taskSettleTurnover(List<CalTaskSettleVO> settleVOs) {
        log.info("\u5f00\u59cb\u5904\u7406\u7ed3\u7b97\u5355\u6570\u636e: {}", (Object)settleVOs.toString());
        ArrayList<CalAccountPayload> accountPayloads = new ArrayList<CalAccountPayload>();
        settleVOs.forEach(settleVO -> {
            String auType = settleVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode()) ? CalAccTypeEnum.PROJ.getCode() : (settleVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_OPPO.getCode()) ? CalAccTypeEnum.OPP.getCode() : CalAccTypeEnum.BU_PROJ.getCode());
            CalAccountPayload p1 = new CalAccountPayload();
            p1.setAuType(auType);
            p1.setAuId(settleVO.getProjId());
            accountPayloads.add(p1);
            CalAccountPayload p2 = new CalAccountPayload();
            p2.setAuType(CalAccTypeEnum.BU.getCode());
            p2.setAuId(settleVO.getResBuId());
            accountPayloads.add(p2);
            CalAccountPayload p3 = new CalAccountPayload();
            p3.setAuType(CalAccTypeEnum.RES.getCode());
            p3.setAuId(settleVO.getIncomeResId());
            accountPayloads.add(p3);
        });
        List<CalAccountVO> calAccountVOS = this.queryAccounts(accountPayloads);
        CalResourcePayload resourcePayload = new CalResourcePayload();
        resourcePayload.setCalAccountVOS(calAccountVOS);
        settleVOs.forEach(settleVO -> this.operateTaskSettleTurnover((CalTaskSettleVO)settleVO, resourcePayload));
        List turnoverPayloads = resourcePayload.getTurnoverPayloads();
        List freezePayloads = resourcePayload.getFreezePayloads();
        List accountVOs = resourcePayload.getUpdateAccountVOs();
        log.info("\u53d8\u66f4\u540e\u7684\u8d26\u53f7\u6570\u636e: {}", (Object)accountVOs.toString());
        this.updateAccount(accountVOs);
        log.info("\u4fdd\u5b58\u6d41\u6c34\u8bb0\u5f55: {}", (Object)turnoverPayloads.toString());
        this.calAccountTurnoverService.batchInsert(turnoverPayloads);
        if (freezePayloads.size() > 0) {
            this.calAccountFreezeService.batchInsert(freezePayloads);
        }
    }

    void operateTaskSettleTurnover(CalTaskSettleVO settleVO, CalResourcePayload resourcePayload) {
        List calAccountVOS = resourcePayload.getCalAccountVOS();
        List turnoverPayloads = resourcePayload.getTurnoverPayloads();
        List freezePayloads = resourcePayload.getFreezePayloads();
        List accountVOs = resourcePayload.getUpdateAccountVOs();
        String auType = settleVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode()) ? CalAccTypeEnum.PROJ.getCode() : (settleVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_OPPO.getCode()) ? CalAccTypeEnum.OPP.getCode() : CalAccTypeEnum.BU_PROJ.getCode());
        CalAccountVO projAccountVO = calAccountVOS.stream().filter(vo -> vo.getAuType().equals(auType) && vo.getAuId().equals(settleVO.getProjId())).findFirst().get();
        accountVOs.add(projAccountVO);
        CalAccountTurnoverPayload projTurnoverPayload = this.getTaskTurnoverPayload(settleVO, projAccountVO, true, false);
        turnoverPayloads.add(projTurnoverPayload);
        CalAccountVO buAccountVO = calAccountVOS.stream().filter(vo -> vo.getAuType().equals(CalAccTypeEnum.BU.getCode()) && vo.getAuId().equals(settleVO.getResBuId())).findFirst().get();
        accountVOs.add(buAccountVO);
        CalAccountTurnoverPayload buTurnoverPayload0 = this.getTaskTurnoverPayload(settleVO, buAccountVO, true, true);
        turnoverPayloads.add(buTurnoverPayload0);
        CalAccountTurnoverPayload buTurnoverPayload1 = this.getTaskTurnoverPayload(settleVO, buAccountVO, false, false);
        turnoverPayloads.add(buTurnoverPayload1);
        CalAccountVO resAccountVO = calAccountVOS.stream().filter(vo -> vo.getAuType().equals(CalAccTypeEnum.RES.getCode()) && vo.getAuId().equals(settleVO.getIncomeResId())).findFirst().get();
        accountVOs.add(resAccountVO);
        CalAccountTurnoverPayload resTurnoverPayload = this.getTaskTurnoverPayload(settleVO, resAccountVO, false, true);
        turnoverPayloads.add(resTurnoverPayload);
        CalAccountFreezePayload taskFreezePayload = this.getTaskFreezePayload(settleVO, resAccountVO, true);
        if (taskFreezePayload != null) {
            freezePayloads.add(taskFreezePayload);
        }
    }

    public void unFreezeTaskSettle(List<CalTaskSettleVO> settleVOs) {
        ArrayList freezePayloads = new ArrayList();
        List<Long> resIds = settleVOs.stream().map(CalTaskSettleVO::getIncomeResId).distinct().collect(Collectors.toList());
        List<CalAccountVO> calAccountVOS = this.queryAccounts(CalAccTypeEnum.RES.getCode(), resIds);
        settleVOs.forEach(vo -> {
            Optional<CalAccountVO> first = calAccountVOS.stream().filter(calAccountVO -> calAccountVO.getAuId().equals(vo.getIncomeResId())).findFirst();
            if (first.isPresent()) {
                CalAccountFreezePayload taskFreezePayload = this.getTaskFreezePayload((CalTaskSettleVO)vo, first.get(), false);
                if (taskFreezePayload != null) {
                    freezePayloads.add(taskFreezePayload);
                }
            } else {
                throw TwException.error("", "\u8d26\u6237\u4e0d\u5b58\u5728");
            }
        });
        this.updateAccount(calAccountVOS);
        if (freezePayloads.size() > 0) {
            this.calAccountFreezeService.batchInsert(freezePayloads);
        }
    }

    public void taskSettleWithdrawTurnover(CalTaskSettleWithdrawPayload payload) {
        log.info("\u5f00\u59cb\u5904\u7406\u7ed3\u7b97\u5355\u63d0\u73b0\u6570\u636e: {}", (Object)payload.toString());
        CalAccountVO calAccountVO = this.queryAccount(CalAccTypeEnum.RES.getCode(), payload.getWithdrawResId());
        log.info("\u63d0\u73b0\u524d\u8d26\u6237\u6570\u636e: {}", (Object)calAccountVO.toString());
        BigDecimal totalQty = calAccountVO.getTotalQty() == null ? BigDecimal.ZERO : calAccountVO.getTotalQty();
        BigDecimal totalAmt = calAccountVO.getTotalAmt() == null ? BigDecimal.ZERO : calAccountVO.getTotalAmt();
        BigDecimal withdrawQty = payload.getWithdrawQty().negate();
        BigDecimal withdrawAmt = payload.getWithdrawAmt().negate();
        BigDecimal avalQtyNew = totalQty.add(withdrawQty);
        BigDecimal avalAmtNew = totalAmt.add(withdrawAmt);
        LocalDate localDate = LocalDate.now();
        CalAccountTurnoverPayload turnoverPayload = new CalAccountTurnoverPayload();
        turnoverPayload.setAccId(calAccountVO.getId());
        turnoverPayload.setAccName(calAccountVO.getLedgerName());
        turnoverPayload.setFinYear(Integer.valueOf(localDate.getYear()));
        turnoverPayload.setFinPeriod(Integer.valueOf(localDate.getMonthValue()));
        turnoverPayload.setIoDate(localDate);
        turnoverPayload.setIoTime(LocalDateTime.now());
        turnoverPayload.setSourceType(CalAccTurTypeEnum.EQVA_WITHDRAW.getCode());
        turnoverPayload.setSourceId(payload.getWithdrawId());
        turnoverPayload.setSourceName(payload.getWithdrawNo());
        turnoverPayload.setTurnoverQty(withdrawQty);
        turnoverPayload.setTurnoverAmt(withdrawAmt);
        turnoverPayload.setBeforeQty(totalQty);
        turnoverPayload.setBeforeAmt(totalAmt);
        turnoverPayload.setAfterQty(avalQtyNew);
        turnoverPayload.setAfterAmt(avalAmtNew);
        calAccountVO.setTotalQty(avalQtyNew);
        calAccountVO.setTotalAmt(avalAmtNew);
        calAccountVO.setAvalQty(avalQtyNew.subtract(calAccountVO.getFrozenQty() == null ? BigDecimal.ZERO : calAccountVO.getFrozenQty()));
        calAccountVO.setAvalAmt(avalAmtNew.subtract(calAccountVO.getFrozenAmt() == null ? BigDecimal.ZERO : calAccountVO.getFrozenAmt()));
        log.info("\u63d0\u73b0\u540e\u8d26\u6237\u6570\u636e: {}", (Object)calAccountVO.toString());
        this.updateAccount(List.of(calAccountVO));
        this.calAccountTurnoverService.batchInsert(List.of(turnoverPayload));
    }

    CalAccountFreezePayload getTaskFreezePayload(CalTaskSettleVO settleVO, CalAccountVO calAccountVO, Boolean isAdd) {
        BigDecimal graranteeEqva;
        BigDecimal bigDecimal = graranteeEqva = isAdd != false ? settleVO.getGraranteeEqva() : settleVO.getGraranteeEqva().negate();
        if (graranteeEqva.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        BigDecimal graranteeAmt = isAdd != false ? settleVO.getGraranteeAmt() : settleVO.getGraranteeAmt().negate();
        BigDecimal avalQty = calAccountVO.getAvalQty() == null ? BigDecimal.ZERO : calAccountVO.getAvalQty();
        BigDecimal avalAmt = calAccountVO.getAvalAmt() == null ? BigDecimal.ZERO : calAccountVO.getAvalAmt();
        BigDecimal avalQtyNew = avalQty.subtract(graranteeEqva);
        BigDecimal avalAmtNew = avalAmt.subtract(graranteeAmt);
        CalAccountFreezePayload freezePayload = new CalAccountFreezePayload();
        freezePayload.setAccId(calAccountVO.getId());
        freezePayload.setAccName(calAccountVO.getLedgerName());
        freezePayload.setFinYear(Integer.valueOf(settleVO.getSettleDate().getYear()));
        freezePayload.setFinPeriod(Integer.valueOf(settleVO.getSettleDate().getMonthValue()));
        freezePayload.setIoDate(settleVO.getSettleDate());
        freezePayload.setIoTime(LocalDateTime.now());
        freezePayload.setSourceType(isAdd != false ? "1" : "2");
        freezePayload.setSourceId(settleVO.getId());
        freezePayload.setSourceName(settleVO.getSettleNo());
        freezePayload.setFreezeQty(graranteeEqva);
        freezePayload.setFreezeAmt(graranteeAmt);
        freezePayload.setEqvaPrice(settleVO.getEqvaSalary());
        freezePayload.setBeforeQty(avalQty);
        freezePayload.setBeforeAmt(avalAmt);
        freezePayload.setAfterQty(avalQtyNew);
        freezePayload.setAfterAmt(avalAmtNew);
        calAccountVO.setAvalQty(avalQtyNew);
        calAccountVO.setAvalAmt(avalAmtNew);
        calAccountVO.setFrozenQty(calAccountVO.getTotalQty().subtract(avalQtyNew));
        calAccountVO.setFrozenAmt(calAccountVO.getTotalAmt().subtract(avalAmtNew));
        return freezePayload;
    }

    CalAccountTurnoverPayload getTaskTurnoverPayload(CalTaskSettleVO settleVO, CalAccountVO calAccountVO, Boolean isSettle, Boolean isAdd) {
        LocalDate settleDate = settleVO.getSettleDate();
        BigDecimal approveSettleEqva = isAdd != false ? settleVO.getApproveSettleEqva() : settleVO.getApproveSettleEqva().negate();
        BigDecimal amt = isAdd != false ? settleVO.getApproveSettleAmt() : settleVO.getApproveSettleAmt().negate();
        BigDecimal price = settleVO.getSettlePrice();
        if (!isSettle.booleanValue()) {
            amt = isAdd != false ? settleVO.getApproveIncomeAmt() : settleVO.getApproveIncomeAmt().negate();
            price = settleVO.getEqvaSalary();
        }
        BigDecimal totalQty = calAccountVO.getTotalQty() == null ? BigDecimal.ZERO : calAccountVO.getTotalQty();
        BigDecimal totalAmt = calAccountVO.getTotalAmt() == null ? BigDecimal.ZERO : calAccountVO.getTotalAmt();
        BigDecimal totalQtyNew = totalQty.add(approveSettleEqva);
        BigDecimal totalAmtNew = totalAmt.add(amt);
        CalAccountTurnoverPayload turnoverPayload = new CalAccountTurnoverPayload();
        turnoverPayload.setAccId(calAccountVO.getId());
        turnoverPayload.setAccName(calAccountVO.getLedgerName());
        turnoverPayload.setFinYear(Integer.valueOf(settleDate.getYear()));
        turnoverPayload.setFinPeriod(Integer.valueOf(settleDate.getMonthValue()));
        turnoverPayload.setIoDate(settleDate);
        turnoverPayload.setIoTime(LocalDateTime.now());
        turnoverPayload.setSourceType(CalAccTurTypeEnum.TASK_SETT.getCode());
        turnoverPayload.setSourceId(settleVO.getId());
        turnoverPayload.setSourceName(settleVO.getSettleNo());
        turnoverPayload.setTurnoverQty(approveSettleEqva);
        turnoverPayload.setTurnoverAmt(amt);
        turnoverPayload.setEqvaPrice(price);
        turnoverPayload.setBeforeQty(totalQty);
        turnoverPayload.setBeforeAmt(totalAmt);
        turnoverPayload.setAfterQty(totalQtyNew);
        turnoverPayload.setAfterAmt(totalAmtNew);
        turnoverPayload.setRemark(settleVO.getRemark());
        calAccountVO.setTotalQty(totalQtyNew);
        calAccountVO.setTotalAmt(totalAmtNew);
        calAccountVO.setAvalQty(totalQtyNew.subtract(calAccountVO.getFrozenQty() == null ? BigDecimal.ZERO : calAccountVO.getFrozenQty()));
        calAccountVO.setAvalAmt(totalAmtNew.subtract(calAccountVO.getFrozenAmt() == null ? BigDecimal.ZERO : calAccountVO.getFrozenAmt()));
        return turnoverPayload;
    }

    @Transactional(rollbackFor={Exception.class})
    public void wideSettleTurnover(CalWideSettleVO calWideSettleVO) {
        ArrayList<CalAccountTurnoverPayload> turnoverPayloads = new ArrayList<CalAccountTurnoverPayload>();
        ArrayList<CalAccountVO> accountVOs = new ArrayList<CalAccountVO>();
        CalAccountVO fromAccountVO = this.queryAccount(calWideSettleVO.getFromSourceType(), calWideSettleVO.getFromSourceId());
        accountVOs.add(fromAccountVO);
        CalAccountTurnoverPayload fromTurnoverPayload = this.getWideTurnoverPayload(calWideSettleVO, fromAccountVO, false);
        turnoverPayloads.add(fromTurnoverPayload);
        CalAccountVO toAccountVO = this.queryAccount(calWideSettleVO.getToSourceType(), calWideSettleVO.getToSourceId());
        accountVOs.add(toAccountVO);
        CalAccountTurnoverPayload toTurnoverPayload = this.getWideTurnoverPayload(calWideSettleVO, toAccountVO, true);
        turnoverPayloads.add(toTurnoverPayload);
        this.updateAccount(accountVOs);
        this.calAccountTurnoverService.batchInsert(turnoverPayloads);
    }

    CalAccountTurnoverPayload getWideTurnoverPayload(CalWideSettleVO calWideSettleVO, CalAccountVO calAccountVO, Boolean isAdd) {
        LocalDate settleDate = calWideSettleVO.getSettleDate();
        BigDecimal applySettleEqva = isAdd != false ? calWideSettleVO.getApplySettleEqva() : calWideSettleVO.getApplySettleEqva().negate();
        BigDecimal applySettleAmt = isAdd != false ? calWideSettleVO.getApplySettleAmt() : calWideSettleVO.getApplySettleAmt().negate();
        BigDecimal price = calWideSettleVO.getSettlePrice();
        BigDecimal totalQty = calAccountVO.getTotalQty() == null ? BigDecimal.ZERO : calAccountVO.getTotalQty();
        BigDecimal totalAmt = calAccountVO.getTotalAmt() == null ? BigDecimal.ZERO : calAccountVO.getTotalAmt();
        BigDecimal totalQtyNew = totalQty.add(applySettleEqva);
        BigDecimal totalAmtNew = totalAmt.add(applySettleAmt);
        CalAccountTurnoverPayload turnoverPayload = new CalAccountTurnoverPayload();
        turnoverPayload.setAccId(calAccountVO.getId());
        turnoverPayload.setAccName(calAccountVO.getLedgerName());
        turnoverPayload.setFinYear(Integer.valueOf(settleDate.getYear()));
        turnoverPayload.setFinPeriod(Integer.valueOf(settleDate.getMonthValue()));
        turnoverPayload.setIoDate(settleDate);
        turnoverPayload.setIoTime(LocalDateTime.now());
        turnoverPayload.setSourceType(calWideSettleVO.getSettleType());
        turnoverPayload.setSourceId(calWideSettleVO.getId());
        turnoverPayload.setSourceName(calWideSettleVO.getSettleNo());
        turnoverPayload.setTurnoverQty(applySettleEqva);
        turnoverPayload.setTurnoverAmt(applySettleAmt);
        turnoverPayload.setEqvaPrice(price);
        turnoverPayload.setBeforeQty(totalQty);
        turnoverPayload.setBeforeAmt(totalAmt);
        turnoverPayload.setAfterQty(totalQtyNew);
        turnoverPayload.setAfterAmt(totalAmtNew);
        calAccountVO.setTotalQty(totalQtyNew);
        calAccountVO.setTotalAmt(totalAmtNew);
        calAccountVO.setAvalQty(totalQtyNew.subtract(calAccountVO.getFrozenQty() == null ? BigDecimal.ZERO : calAccountVO.getFrozenQty()));
        calAccountVO.setAvalAmt(totalAmtNew.subtract(calAccountVO.getFrozenAmt() == null ? BigDecimal.ZERO : calAccountVO.getFrozenAmt()));
        return turnoverPayload;
    }

    public void amountSettleTurnover(CalNormSettleVO calNormSettleVO, Integer normType) {
        ArrayList<CalAccountTurnoverPayload> turnoverPayloads = new ArrayList<CalAccountTurnoverPayload>();
        List<Long> accIds = Arrays.asList(calNormSettleVO.getOutAccountId(), calNormSettleVO.getInAccountId());
        List calAccountVOS = this.calAccountService.queryByKeys(accIds);
        if (calAccountVOS.size() < accIds.size()) {
            throw TwException.error("", "\u8d26\u6237\u6570\u636e\u4e0d\u5b58\u5728");
        }
        calAccountVOS.forEach(vo -> {
            if (vo.getLedgerStatus().equals("0")) {
                throw TwException.error("", vo.getLedgerName() + "\u8d26\u6237\u5df2\u7981\u7528");
            }
        });
        CalAccountVO outAccountVO = calAccountVOS.stream().filter(vo -> vo.getId().equals(calNormSettleVO.getOutAccountId())).findFirst().get();
        CalAccountTurnoverPayload outTurnoverPayload = this.getAmountTurnoverPayload(calNormSettleVO, outAccountVO, normType != 1);
        turnoverPayloads.add(outTurnoverPayload);
        CalAccountVO inAccountVO = calAccountVOS.stream().filter(vo -> vo.getId().equals(calNormSettleVO.getInAccountId())).findFirst().get();
        CalAccountTurnoverPayload inTurnoverPayload = this.getAmountTurnoverPayload(calNormSettleVO, inAccountVO, normType == 1);
        turnoverPayloads.add(inTurnoverPayload);
        this.updateAccount(calAccountVOS);
        this.calAccountTurnoverService.batchInsert(turnoverPayloads);
    }

    public void amountBatchSettleTurnover(List<CalNormSettleVO> calNormSettleVOS, List<CalAccountVO> calAccountVOS) {
        ArrayList turnoverPayloads = new ArrayList();
        ArrayList<CalAccountVO> updateAccountVOS = new ArrayList<CalAccountVO>();
        calNormSettleVOS.forEach(calNormSettleVO -> {
            CalAccountVO outAccountVO = calAccountVOS.stream().filter(vo -> vo.getId().equals(calNormSettleVO.getOutAccountId())).findFirst().get();
            updateAccountVOS.add(outAccountVO);
            CalAccountTurnoverPayload outTurnoverPayload = this.getAmountTurnoverPayload((CalNormSettleVO)calNormSettleVO, outAccountVO, false);
            turnoverPayloads.add(outTurnoverPayload);
            CalAccountVO inAccountVO = calAccountVOS.stream().filter(vo -> vo.getId().equals(calNormSettleVO.getInAccountId())).findFirst().get();
            updateAccountVOS.add(inAccountVO);
            CalAccountTurnoverPayload inTurnoverPayload = this.getAmountTurnoverPayload((CalNormSettleVO)calNormSettleVO, inAccountVO, true);
            turnoverPayloads.add(inTurnoverPayload);
        });
        this.calAccountTurnoverService.batchInsert(turnoverPayloads);
        this.updateAccount(updateAccountVOS);
    }

    CalAccountTurnoverPayload getAmountTurnoverPayload(CalNormSettleVO calNormSettleVO, CalAccountVO calAccountVO, Boolean isAdd) {
        LocalDate settleDate = calNormSettleVO.getSettleDate();
        BigDecimal approveSettleAmt = isAdd != false ? calNormSettleVO.getApproveSettleAmt() : calNormSettleVO.getApproveSettleAmt().negate();
        BigDecimal totalAmt = calAccountVO.getTotalAmt() == null ? BigDecimal.ZERO : calAccountVO.getTotalAmt();
        BigDecimal totalQty = calAccountVO.getTotalQty() == null ? BigDecimal.ZERO : calAccountVO.getTotalQty();
        BigDecimal totalAmtNew = totalAmt.add(approveSettleAmt);
        CalAccountTurnoverPayload turnoverPayload = new CalAccountTurnoverPayload();
        turnoverPayload.setAccId(calAccountVO.getId());
        turnoverPayload.setAccName(calAccountVO.getLedgerName());
        turnoverPayload.setFinYear(Integer.valueOf(settleDate.getYear()));
        turnoverPayload.setFinPeriod(Integer.valueOf(settleDate.getMonthValue()));
        turnoverPayload.setIoDate(settleDate);
        turnoverPayload.setIoTime(LocalDateTime.now());
        turnoverPayload.setSourceType(CalAccTurTypeEnum.WIDE_AMT.getCode());
        turnoverPayload.setSourceId(calNormSettleVO.getId());
        turnoverPayload.setSourceName(calNormSettleVO.getSettleNo());
        turnoverPayload.setTurnoverQty(BigDecimal.ZERO);
        turnoverPayload.setTurnoverAmt(approveSettleAmt);
        turnoverPayload.setEqvaPrice(BigDecimal.ZERO);
        turnoverPayload.setBeforeQty(totalQty);
        turnoverPayload.setBeforeAmt(totalAmt);
        turnoverPayload.setAfterQty(totalQty);
        turnoverPayload.setAfterAmt(totalAmtNew);
        turnoverPayload.setRemark(calNormSettleVO.getRemark());
        calAccountVO.setTotalAmt(totalAmtNew);
        calAccountVO.setAvalAmt(totalAmtNew.subtract(calAccountVO.getFrozenAmt() == null ? BigDecimal.ZERO : calAccountVO.getFrozenAmt()));
        return turnoverPayload;
    }

    void updateAccount(List<CalAccountVO> accountVOs) {
        accountVOs.forEach(vo -> {
            this.checkAccount((CalAccountVO)vo);
            CalAccountPayload payload = new CalAccountPayload();
            payload.setId(vo.getId());
            payload.setTotalQty(vo.getTotalQty());
            payload.setTotalAmt(vo.getTotalAmt());
            payload.setAvalQty(vo.getAvalQty());
            payload.setAvalAmt(vo.getAvalAmt());
            payload.setFrozenQty(vo.getFrozenQty());
            payload.setFrozenAmt(vo.getFrozenAmt());
            this.calAccountService.updateByKeyDynamic(payload);
        });
    }

    public CalAccountVO queryAccount(String auType, Long auId) {
        return this.calAccountService.queryByAuTypeAndAuId(auType, auId);
    }

    public void checkAccount(CalAccountVO vo) {
        Boolean isCheck = true;
        if (StringUtils.hasText((String)vo.getLedgerType()) && "1".equals(vo.getLedgerType())) {
            isCheck = false;
        }
        if (vo.getAuType().equals(CalAccTypeEnum.OPP.getCode())) {
            isCheck = false;
        }
        if (isCheck.booleanValue()) {
            // empty if block
        }
    }

    public void checkDistributeAccount(PmsDistributeVO distributeVO) {
    }

    @Transactional(rollbackFor={Exception.class})
    public void resetAccount(String auType, String operType, String remark) {
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        if (!rolePermission.booleanValue()) {
            throw TwException.error("", "\u65e0\u64cd\u4f5c\u91cd\u7f6e\u8d26\u6237\u6570\u636e\u7684\u6743\u9650\uff01");
        }
        CalAccountQuery query = new CalAccountQuery();
        query.setAuType(auType);
        query.setOperType(operType);
        List calAccountVOS = this.calAccountService.queryListDynamic(query);
        ArrayList turnoverPayloads = new ArrayList();
        LocalDate now = LocalDate.now();
        calAccountVOS.forEach(calAccountVO -> {
            BigDecimal totalAmt = calAccountVO.getTotalAmt() == null ? BigDecimal.ZERO : calAccountVO.getTotalAmt();
            BigDecimal totalQty = calAccountVO.getTotalQty() == null ? BigDecimal.ZERO : calAccountVO.getTotalQty();
            BigDecimal amt = totalAmt.negate();
            BigDecimal eqva = totalQty.negate();
            BigDecimal totalAmtNew = BigDecimal.ZERO;
            BigDecimal totalQtyNew = BigDecimal.ZERO;
            CalAccountTurnoverPayload turnoverPayload = new CalAccountTurnoverPayload();
            turnoverPayload.setAccId(calAccountVO.getId());
            turnoverPayload.setAccName(calAccountVO.getLedgerName());
            turnoverPayload.setFinYear(Integer.valueOf(now.getYear()));
            turnoverPayload.setFinPeriod(Integer.valueOf(now.getMonthValue()));
            turnoverPayload.setIoDate(now);
            turnoverPayload.setIoTime(LocalDateTime.now());
            turnoverPayload.setSourceType(CalAccTurTypeEnum.HANDWORK.getCode());
            turnoverPayload.setSourceId(Long.valueOf(0L));
            turnoverPayload.setSourceName("");
            turnoverPayload.setTurnoverQty(eqva);
            turnoverPayload.setTurnoverAmt(amt);
            turnoverPayload.setEqvaPrice(BigDecimal.ZERO);
            turnoverPayload.setBeforeQty(totalQty);
            turnoverPayload.setBeforeAmt(totalAmt);
            turnoverPayload.setAfterQty(totalQtyNew);
            turnoverPayload.setAfterAmt(totalAmtNew);
            turnoverPayload.setRemark(remark);
            turnoverPayloads.add(turnoverPayload);
            calAccountVO.setTotalAmt(totalAmtNew);
            calAccountVO.setTotalQty(totalQtyNew);
            calAccountVO.setFrozenQty(BigDecimal.ZERO);
            calAccountVO.setFrozenAmt(BigDecimal.ZERO);
            calAccountVO.setAvalQty(BigDecimal.ZERO);
            calAccountVO.setAvalAmt(BigDecimal.ZERO);
        });
        if (turnoverPayloads.size() > 0) {
            this.updateAccount(calAccountVOS);
            this.calAccountTurnoverService.batchInsert(turnoverPayloads);
        }
    }

    List<CalAccountVO> queryAccounts(String auType, List<Long> auIds) {
        List calAccountVOS = this.calAccountService.queryByAuTypeAndAuIds(auType, auIds);
        if (ObjectUtils.isEmpty((Object)calAccountVOS)) {
            throw TwException.error("", "\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        if (calAccountVOS.size() != auIds.size()) {
            throw TwException.error("", "\u8d26\u6237\u6570\u636e\u5b58\u5728\u5f02\u5e38\u6216\u5df2\u7981\u7528");
        }
        return calAccountVOS;
    }

    List<CalAccountVO> queryAccounts(List<CalAccountPayload> payloads) {
        HashSet auTypes = new HashSet();
        HashSet auIds = new HashSet();
        payloads.forEach(payload -> {
            auTypes.add(payload.getAuType());
            auIds.add(payload.getAuId());
        });
        List calAccountVOS = this.calAccountService.queryByAuTypesAndAuIds(new ArrayList(auTypes), new ArrayList(auIds));
        payloads.forEach(payload -> {
            String auType = payload.getAuType();
            Optional<CalAccountVO> first = calAccountVOS.stream().filter(vo -> vo.getAuType().equals(auType) && vo.getAuId().equals(payload.getAuId())).findFirst();
            if (!first.isPresent()) {
                String name = "";
                if (auType.equals(CalAccTypeEnum.PROJ.getCode())) {
                    name = CalAccTypeEnum.PROJ.getDesc();
                }
                if (auType.equals(CalAccTypeEnum.BU.getCode())) {
                    name = CalAccTypeEnum.BU.getDesc();
                }
                if (auType.equals(CalAccTypeEnum.RES.getCode())) {
                    name = CalAccTypeEnum.RES.getDesc();
                }
                if (auType.equals(CalAccTypeEnum.OPP.getCode())) {
                    name = CalAccTypeEnum.OPP.getDesc();
                }
                if (auType.equals(CalAccTypeEnum.BU_PROJ.getCode())) {
                    name = CalAccTypeEnum.BU_PROJ.getDesc();
                }
                log.error(name + "\u8d26\u6237\u4e0d\u5b58\u5728,auId:" + payload.getAuId());
                throw TwException.error("", name + "\u8d26\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528,auId:" + payload.getAuId());
            }
        });
        return calAccountVOS;
    }

    public CalResourceServiceImpl(CalSettlePriceService calSettlePriceService, CalEqvaIncomeService calEqvaIncomeService, CalEqvaCostService calEqvaCostService, CacheUtil cacheUtil, CalAccountService calAccountService, CalAccountFreezeService calAccountFreezeService, CalAccountTurnoverService calAccountTurnoverService) {
        this.calSettlePriceService = calSettlePriceService;
        this.calEqvaIncomeService = calEqvaIncomeService;
        this.calEqvaCostService = calEqvaCostService;
        this.cacheUtil = cacheUtil;
        this.calAccountService = calAccountService;
        this.calAccountFreezeService = calAccountFreezeService;
        this.calAccountTurnoverService = calAccountTurnoverService;
    }
}

