/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOperationPlanDetailMemberListPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOperationPlanDetailMemberPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOperationPlanDetailMemberQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanDetailMemberService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOperationPlanDetailMemberVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOperationPlanDetailMemberConvert;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOperationPlanDetailDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOperationPlanDetailMemberDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOperationPlanDetailMemberDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOperationPlanDetailMemberRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOperationPlanDetailRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class CrmOperationPlanDetailMemberServiceImpl
implements CrmOperationPlanDetailMemberService {
    private static final Logger log = LoggerFactory.getLogger(CrmOperationPlanDetailMemberServiceImpl.class);
    private final CrmOperationPlanDetailMemberRepo repo;
    private final CrmOperationPlanDetailRepo crmOperationPlanDetailRepo;
    private final PrdSystemLogService logService;
    private final CacheUtil cacheUtil;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final JPAQueryFactory jpaQueryFactory;

    @Transactional(rollbackFor={Exception.class})
    public CrmOperationPlanDetailMemberVO insert(CrmOperationPlanDetailMemberPayload payload) {
        this.check(payload);
        this.initDefaultValue(payload);
        CrmOperationPlanDetailMemberDO entityDo = CrmOperationPlanDetailMemberConvert.INSTANCE.toDo(payload);
        this.repo.save((Object)entityDo);
        String createLog = this.changeFieldLogUtil.getFieldsCreateLog(entityDo, "\u6dfb\u52a0\u4e86");
        this.logService.saveNewLog(entityDo.getPlanDetailId(), PrdSystemObjectEnum.CUSTOMER_OPERATION_PLAN_DETAIL.getCode(), createLog);
        return CrmOperationPlanDetailMemberConvert.INSTANCE.toVo(entityDo);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<CrmOperationPlanDetailMemberVO> savaAll(CrmOperationPlanDetailMemberListPayload payload) {
        List memberList = payload.getMemberList();
        ArrayList<CrmOperationPlanDetailMemberVO> list = new ArrayList<CrmOperationPlanDetailMemberVO>();
        if (!CollectionUtils.isEmpty((Collection)memberList)) {
            memberList.forEach(crmOperationPlanDetailMemberPayload -> list.add(this.insert((CrmOperationPlanDetailMemberPayload)crmOperationPlanDetailMemberPayload)));
        }
        return list;
    }

    private void initDefaultValue(CrmOperationPlanDetailMemberPayload payload) {
        if (!StringUtils.hasText((String)payload.getUserName())) {
            String userName = this.cacheUtil.getUserName(payload.getUserId());
            payload.setUserName(userName);
        }
        if (null == payload.getOperId()) {
            CrmOperationPlanDetailDO operationPlanDetailDO = (CrmOperationPlanDetailDO)((Object)this.crmOperationPlanDetailRepo.getById(payload.getPlanDetailId()));
            Long operId = operationPlanDetailDO.getOperId();
            payload.setOperId(operId);
        }
    }

    private void check(CrmOperationPlanDetailMemberPayload payload) {
        if (null == payload.getPlanDetailId()) {
            throw TwException.error("", "planDetailId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public CrmOperationPlanDetailMemberVO update(CrmOperationPlanDetailMemberPayload payload) {
        CrmOperationPlanDetailMemberDO entity = this.repo.findById(payload.getId()).orElseGet(CrmOperationPlanDetailMemberDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        CrmOperationPlanDetailMemberDO entityLog = new CrmOperationPlanDetailMemberDO();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)entityLog));
        CrmOperationPlanDetailMemberDO entityDo = CrmOperationPlanDetailMemberConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        StringBuilder fieldsUpdateLog = this.changeFieldLogUtil.nullFieldsProcess((TwCommonPayload)payload, entityLog, entity);
        CrmOperationPlanDetailMemberDO save = (CrmOperationPlanDetailMemberDO)((Object)this.repo.save((Object)entity));
        fieldsUpdateLog.append(this.changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
        if (StringUtils.hasText((CharSequence)fieldsUpdateLog)) {
            this.logService.saveNewLog(entityDo.getPlanDetailId(), PrdSystemObjectEnum.CUSTOMER_OPERATION_PLAN_DETAIL.getCode(), fieldsUpdateLog.toString());
        }
        return CrmOperationPlanDetailMemberConvert.INSTANCE.toVo(save);
    }

    public CrmOperationPlanDetailMemberVO queryByKey(Long key) {
        CrmOperationPlanDetailMemberDO entity = this.repo.findById(key).orElseGet(CrmOperationPlanDetailMemberDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        CrmOperationPlanDetailMemberVO crmCustomerOperationVO = CrmOperationPlanDetailMemberConvert.INSTANCE.toVo(entity);
        return crmCustomerOperationVO;
    }

    public List<CrmOperationPlanDetailMemberVO> queryList(CrmOperationPlanDetailMemberQuery query) {
        OrderItem orderItem = OrderItem.desc((String)"createTime");
        query.defaultOrder(orderItem);
        return CrmOperationPlanDetailMemberConvert.INSTANCE.toVoList(this.repo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    public PagingVO<CrmOperationPlanDetailMemberVO> paging(CrmOperationPlanDetailMemberQuery query) {
        OrderItem orderItem = OrderItem.desc((String)"createTime");
        query.defaultOrder(orderItem);
        Page page = this.repo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(CrmOperationPlanDetailMemberConvert.INSTANCE::toVo));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.repo.findById(id);
                if (!optional.isEmpty()) {
                    CrmOperationPlanDetailMemberDO entity = (CrmOperationPlanDetailMemberDO)((Object)((Object)optional.get()));
                    this.logService.saveNewLog(entity.getPlanDetailId(), PrdSystemObjectEnum.CUSTOMER_OPERATION_PLAN_DETAIL.getCode(), "\u5220\u9664\u4e86\u53c2\u4e0e\u8005 " + entity.getUserName());
                }
            });
            this.repo.deleteSoft(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoftByPlanDetailIds(List<Long> planDetailIds) {
        if (!planDetailIds.isEmpty()) {
            QCrmOperationPlanDetailMemberDO qdo = QCrmOperationPlanDetailMemberDO.crmOperationPlanDetailMemberDO;
            JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)qdo).set(qdo.deleteFlag, (Object)1).where(new Predicate[]{qdo.planDetailId.in(planDetailIds)});
            update.execute();
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoftByOperIds(List<Long> operIds) {
        if (!operIds.isEmpty()) {
            QCrmOperationPlanDetailMemberDO qdo = QCrmOperationPlanDetailMemberDO.crmOperationPlanDetailMemberDO;
            JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)qdo).set(qdo.deleteFlag, (Object)1).where(new Predicate[]{qdo.operId.in(operIds)});
            update.execute();
        }
    }

    public void saveAll(List<CrmOperationPlanDetailMemberPayload> planDetailPayloadS) {
        List<CrmOperationPlanDetailMemberDO> list = CrmOperationPlanDetailMemberConvert.INSTANCE.toDoList(planDetailPayloadS);
        this.repo.saveAll(list);
    }

    public CrmOperationPlanDetailMemberServiceImpl(CrmOperationPlanDetailMemberRepo repo, CrmOperationPlanDetailRepo crmOperationPlanDetailRepo, PrdSystemLogService logService, CacheUtil cacheUtil, ChangeFieldLogUtil changeFieldLogUtil, JPAQueryFactory jpaQueryFactory) {
        this.repo = repo;
        this.crmOperationPlanDetailRepo = crmOperationPlanDetailRepo;
        this.logService = logService;
        this.cacheUtil = cacheUtil;
        this.changeFieldLogUtil = changeFieldLogUtil;
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

