/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityStakeholderPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityStakeholderService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityStakeholderVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOpportunityStakeholderConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityStakeholderDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityStakeholderDO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CrmOpportunityStakeholderServiceImpl
implements CrmOpportunityStakeholderService {
    private static final Logger log = LoggerFactory.getLogger(CrmOpportunityStakeholderServiceImpl.class);
    private final CacheUtil cacheUtil;
    private final CrmOpportunityStakeholderDAO dao;
    private final CrmOpportunityDAO opportunityDAO;
    private final PrdSystemLogService logService;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;
    @Value(value="${tw4.opportunity.stakeholder_operation}")
    private String stakeholder_operation;
    @Value(value="${tw4.opportunity.stakeholder_del}")
    private String stakeholder_del;

    @Transactional
    public CrmOpportunityStakeholderVO insert(CrmOpportunityStakeholderPayload payload) {
        if (payload.getOppoIdV4() != null) {
            payload.setOppoId(this.opportunityDAO.getIdByV4(payload.getOppoIdV4()));
        }
        if (payload.getShsIdV4() != null) {
            payload.setId(this.dao.getIdByV4(payload.getShsIdV4()));
        }
        CrmOpportunityStakeholderDO ado = CrmOpportunityStakeholderConvert.INSTANCE.toDo(payload);
        this.dao.save(ado);
        this.logService.saveNewLog(payload.getOppoId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.ADD.getDesc() + "\u5e72\u7cfb\u4eba");
        return CrmOpportunityStakeholderConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    public Long update(CrmOpportunityStakeholderPayload payload) {
        if (payload.getOppoIdV4() != null) {
            payload.setOppoId(this.opportunityDAO.getIdByV4(payload.getOppoIdV4()));
        }
        if (payload.getShsIdV4() != null) {
            payload.setId(this.dao.getIdByV4(payload.getShsIdV4()));
        }
        Long stakeholderIdV4 = this.dao.queryTW4IdById(payload.getId());
        CrmOpportunityStakeholderDO ado = CrmOpportunityStakeholderConvert.INSTANCE.toDo(payload);
        ado.setStakeholderIdV4(stakeholderIdV4);
        this.dao.save(ado);
        this.logService.saveNewLog(payload.getOppoId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.UPDATE.getDesc() + "\u5e72\u7cfb\u4eba");
        return 0L;
    }

    public List<CrmOpportunityStakeholderVO> queryList(Long oppoId) {
        List<CrmOpportunityStakeholderVO> stakeholderVOS = this.dao.queryList(oppoId);
        stakeholderVOS.forEach(stakeholderVO -> this.transferSystemSelection((CrmOpportunityStakeholderVO)stakeholderVO));
        return stakeholderVOS;
    }

    @Transactional
    public boolean deleteSoft(Long oppoId, List<Long> keys) {
        this.dao.deleteSoft(keys);
        this.logService.saveNewLog(oppoId, PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.DELETE.getDesc() + "\u5e72\u7cfb\u4eba");
        return true;
    }

    void transferSystemSelection(CrmOpportunityStakeholderVO vo) {
        vo.setRoleTypeName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoRoleType.getCode(), vo.getRoleType()));
        vo.setStandpointName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoStandpoint.getCode(), vo.getStandpoint()));
    }

    public CrmOpportunityStakeholderServiceImpl(CacheUtil cacheUtil, CrmOpportunityStakeholderDAO dao, CrmOpportunityDAO opportunityDAO, PrdSystemLogService logService, TransferUtilServiceImpl transferUtilService, HttpUtil httpUtil) {
        this.cacheUtil = cacheUtil;
        this.dao = dao;
        this.opportunityDAO = opportunityDAO;
        this.logService = logService;
        this.transferUtilService = transferUtilService;
        this.httpUtil = httpUtil;
    }
}

