/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.basebu.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimService;
import com.elitesland.tw.tw5.api.prd.cal.query.CalTaskSettleQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalTaskSettleService;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdBaseBuChangePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdBuChangeTodoPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdBaseBuChangeQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdBuChangeTodoQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdBaseBuChangeService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdBuChangeTodoService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdBaseBuChangeVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdBuChangeTodoVO;
import com.elitesland.tw.tw5.api.prd.my.service.TimesheetService;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeeRefPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgRolePayload;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdMessageConfigPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.task.query.TaskInfoQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalSettleStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.base.HrBaseEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.basebu.dao.PrdBaseBuChangeDao;
import com.elitesland.tw.tw5.server.prd.humanresources.basebu.entity.PrdBaseBuChangeDO;
import com.elitesland.tw.tw5.server.prd.humanresources.basebu.repo.PrdBaseBuChangeRepo;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdBaseBuChangeConvert;
import com.elitesland.tw.tw5.server.prd.my.constant.TaskStatusEnum;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgRoleDO;
import com.elitesland.tw.tw5.server.prd.system.constant.MessageNoticeTypeEnum;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PrdBaseBuChangeServiceImpl
implements PrdBaseBuChangeService {
    private static final Logger log = LoggerFactory.getLogger(PrdBaseBuChangeServiceImpl.class);
    private final PrdBaseBuChangeDao prdBaseBuChangeDao;
    private final PrdBaseBuChangeRepo prdBaseBuChangeRepo;
    private final WorkflowUtil workflowUtil;
    private final PrdSystemRoleDAO prdSystemRoleDAO;
    private final PrdOrgOrganizationService prdOrgOrganizationService;
    private final PrdBuChangeTodoService prdBuChangeTodoService;
    private final PrdOrgEmployeeDAO prdOrgEmployeeDAO;
    private final CacheUtil cacheUtil;
    private final TimesheetService timesheetService;
    private final AccReimService accReimService;
    private final CalTaskSettleService calTaskSettleService;
    private final TaskInfoService taskInfoService;
    private final PrdOrgOrganizationDAO prdOrgOrganizationDAO;
    private final PrdMessageConfigService messageConfigService;
    private final PrdSystemRoleService roleService;

    @Transactional(rollbackFor={Exception.class})
    public PrdBaseBuChangeVO save(PrdBaseBuChangePayload prdBaseBuChangePayload) {
        this.checkData(prdBaseBuChangePayload);
        PrdBaseBuChangeQuery prdBaseBuChangeQuery = new PrdBaseBuChangeQuery();
        prdBaseBuChangeQuery.setProcInstStatus(ProcInstStatus.APPROVING);
        prdBaseBuChangeQuery.setUserId(prdBaseBuChangePayload.getUserId());
        Long count = this.prdBaseBuChangeDao.count(prdBaseBuChangeQuery);
        if (count > 0L) {
            throw new BusinessException(HrBaseEnum.FLOW_REPEAT_ERR.getDesc());
        }
        PrdBaseBuChangeDO prdBaseBuChangeDO = new PrdBaseBuChangeDO();
        prdBaseBuChangeDO = PrdBaseBuChangeConvert.INSTANCE.p2d(prdBaseBuChangePayload);
        PrdBaseBuChangeDO res = (PrdBaseBuChangeDO)((Object)this.prdBaseBuChangeRepo.save((Object)prdBaseBuChangeDO));
        PrdBuChangeTodoPayload prdBuChangeTodoPayload = new PrdBuChangeTodoPayload();
        prdBuChangeTodoPayload.setChangeId(res.getId());
        this.prdBuChangeTodoService.save(prdBuChangeTodoPayload);
        this.startWorkFlow(res);
        PrdOrgEmployeePayload prdOrgEmployeePayload = new PrdOrgEmployeePayload();
        prdOrgEmployeePayload.setUserId(prdBaseBuChangePayload.getUserId());
        prdOrgEmployeePayload.setResourceStatus("5");
        this.prdOrgEmployeeDAO.updateByUserId(prdOrgEmployeePayload);
        return PrdBaseBuChangeConvert.INSTANCE.d2v(res);
    }

    public void startWorkFlow(PrdBaseBuChangeDO res) {
        HashMap<String, Object> varMaps = new HashMap<String, Object>();
        Assert.notNull((Object)res.getOldPUserId(), (String)"\u539f\u4e0a\u7ea7\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        varMaps.put("Activity_16mcrqv", res.getOldPUserId());
        Assert.notNull((Object)res.getOldBuId(), (String)"\u539fbuid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long oldBuId = res.getOldBuId();
        PrdOrgOrganizationVO prdOrgOrganizationVO = this.prdOrgOrganizationService.queryDetailSimpleByOrgId(oldBuId);
        varMaps.put("Activity_0xsrxe2", prdOrgOrganizationVO.getManageId());
        Assert.notNull((Object)res.getNewPUserId(), (String)"\u65b0\u4e0a\u7ea7\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        varMaps.put("Activity_1eu9loy", res.getNewPUserId());
        Assert.notNull((Object)res.getNewBuId(), (String)"\u65b0buid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long newBuId = res.getNewBuId();
        PrdOrgOrganizationVO prdOrgOrganizationVO1 = this.prdOrgOrganizationService.queryDetailSimpleByOrgId(newBuId);
        varMaps.put("Activity_1cjxcqq", prdOrgOrganizationVO1.getManageId());
        List<Long> hrdUserIds = this.prdSystemRoleDAO.queryUserIdByRoleCode(RoleEnum.PLAT_HRD.getCode());
        varMaps.put("Activity_0hx8664", hrdUserIds);
        List<Long> xcUserIds = this.prdSystemRoleDAO.queryUserIdByRoleCodes(List.of(RoleEnum.PLAT_ERM.getCode(), RoleEnum.PLAT_ERS.getCode()));
        varMaps.put("Activity_0bubp55", xcUserIds);
        varMaps.put("Activity_111kevq", res.getUserId());
        ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)HrBaseEnum.BASE_BU_CHANGE.getCode(), (String)("A62.BaseBU\u53d8\u66f4\u6d41\u7a0b-" + this.cacheUtil.getUserName(res.getUserId())), (String)res.getId().toString(), varMaps), new Long[0]);
        String procInstId = processInfo.getProcInstId();
        ProcInstStatus procInstStatus = processInfo.getProcInstStatus();
        PrdBaseBuChangePayload payload = new PrdBaseBuChangePayload();
        payload.setProcInstId(procInstId);
        payload.setProcInstStatus(procInstStatus);
        payload.setId(res.getId());
        Long update = this.prdBaseBuChangeDao.update(payload);
        String userName = this.cacheUtil.getUserName(res.getUserId());
        String oldBuName = this.cacheUtil.getOrgName(res.getOldBuId());
        String newBuName = this.cacheUtil.getOrgName(res.getNewBuId());
        String title = "BaseBU\u53d8\u66f4-" + userName;
        String content = "\u5458\u5de5" + userName + "\u53d1\u8d77\u4e86BaseBU\u53d8\u66f4\uff0c\u539fBaseBU\uff1a" + oldBuName + "\uff0c\u65b0BaseBU\u4e3a\uff1a" + newBuName;
        this.sendMessage(res.getId(), title, content);
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdBaseBuChangeVO update(PrdBaseBuChangePayload prdBaseBuChangePayload) {
        Assert.notNull((Object)prdBaseBuChangePayload.getId(), (String)"id is null", (Object[])new Object[0]);
        PrdBaseBuChangeVO res = this.save(prdBaseBuChangePayload);
        return res;
    }

    public PrdBaseBuChangeVO get(Long id) {
        if (null == id) {
            return null;
        }
        PrdBaseBuChangeVO res = this.prdBaseBuChangeDao.get(id);
        if (null != res) {
            PrdBuChangeTodoQuery prdBuChangeTodoQuery = new PrdBuChangeTodoQuery();
            prdBuChangeTodoQuery.setChangeId(id);
            List dtlList = this.prdBuChangeTodoService.getList(prdBuChangeTodoQuery, res.getUserId());
            this.updateState(dtlList, res.getUserId());
            res.setPrdBuChangeTodoVOList(dtlList);
        }
        return res;
    }

    public void updateState(List<PrdBuChangeTodoVO> dtlList, Long userId) {
        Assert.notNull((Object)userId, (String)"userId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (PrdBuChangeTodoVO prdBuChangeTodoVO : dtlList) {
            if (prdBuChangeTodoVO.getTodoTitle() == 0) {
                CalTaskSettleQuery calTaskSettleQuery = new CalTaskSettleQuery();
                calTaskSettleQuery.setIncomeResId(userId);
                calTaskSettleQuery.setSettleStatusList(List.of(CalSettleStatusEnum.CREATE.getCode(), CalSettleStatusEnum.IN_PROCESS.getCode()));
                List calTaskSettleVOS = this.calTaskSettleService.queryListDynamic(calTaskSettleQuery);
                prdBuChangeTodoVO.setState(Integer.valueOf(CollectionUtil.isNotEmpty((Collection)calTaskSettleVOS) ? 0 : 1));
                continue;
            }
            if (prdBuChangeTodoVO.getTodoTitle() == 1) {
                boolean bo = this.accReimService.myReimCheck(userId);
                prdBuChangeTodoVO.setState(Integer.valueOf(bo ? 0 : 1));
                continue;
            }
            if (prdBuChangeTodoVO.getTodoTitle() == 2) {
                boolean bo = this.timesheetService.checkTimeSheetStatueInCreateAndRejected(null, LocalDate.now(), userId);
                prdBuChangeTodoVO.setState(Integer.valueOf(bo ? 0 : 1));
                continue;
            }
            if (prdBuChangeTodoVO.getTodoTitle() != 3) continue;
            TaskInfoQuery taskInfoQuery = new TaskInfoQuery();
            taskInfoQuery.setTaskResId(userId);
            taskInfoQuery.setTaskStatusFlag(Integer.valueOf(0));
            taskInfoQuery.setTaskStatus(TaskStatusEnum.CLOSE.getCode());
            List taskInfoVOS = this.taskInfoService.queryList(taskInfoQuery);
            prdBuChangeTodoVO.setState(Integer.valueOf(CollectionUtil.isNotEmpty((Collection)taskInfoVOS) ? 0 : 1));
        }
    }

    @Transactional
    public Boolean changeByTask(Long userId, LocalDate joinDate, String param) {
        PrdBaseBuChangeQuery prdBaseBuChangeQuery = new PrdBaseBuChangeQuery();
        prdBaseBuChangeQuery.setProcInstStatus(ProcInstStatus.APPROVED);
        prdBaseBuChangeQuery.setNewJoinDate(joinDate);
        prdBaseBuChangeQuery.setUserId(userId);
        List<PrdBaseBuChangeVO> list = this.getList(prdBaseBuChangeQuery);
        for (PrdBaseBuChangeVO prdBaseBuChangeVO : list) {
            String[] roleIds;
            PrdOrgEmployeePayload prdOrgEmployeePayload = new PrdOrgEmployeePayload();
            prdOrgEmployeePayload.setResourceStatus("3");
            prdOrgEmployeePayload.setUserId(prdBaseBuChangeVO.getUserId());
            prdOrgEmployeePayload.setSalaryMethod(prdBaseBuChangeVO.getSalaryType());
            prdOrgEmployeePayload.setSalaryPeriod(prdBaseBuChangeVO.getSalaryCycle());
            prdOrgEmployeePayload.setCooperationMode(prdBaseBuChangeVO.getCooperateType());
            prdOrgEmployeePayload.setEqvaRatio(prdBaseBuChangeVO.getDlRatio());
            prdOrgEmployeePayload.setExtString1(prdBaseBuChangeVO.getJobGrade());
            this.prdOrgEmployeeDAO.updateByUserId(prdOrgEmployeePayload);
            PrdOrgEmployeeRefPayload prdOrgEmployeeRefPayload = new PrdOrgEmployeeRefPayload();
            prdOrgEmployeeRefPayload.setOrgId(prdBaseBuChangeVO.getOldBuId());
            prdOrgEmployeeRefPayload.setNewOrgId(prdBaseBuChangeVO.getNewBuId());
            prdOrgEmployeeRefPayload.setUserId(prdBaseBuChangeVO.getUserId());
            prdOrgEmployeeRefPayload.setParentId(prdBaseBuChangeVO.getNewPUserId());
            prdOrgEmployeeRefPayload.setJoinDate(LocalDate.now());
            this.prdOrgEmployeeDAO.updateEmployeeRefByUserId(prdOrgEmployeeRefPayload);
            if (!StringUtils.isNotBlank((CharSequence)prdBaseBuChangeVO.getNewRoleId())) continue;
            for (String str : roleIds = prdBaseBuChangeVO.getNewRoleId().split(",")) {
                PrdOrgRoleDO prdOrgRoleDO = this.prdOrgOrganizationDAO.queryRoleByKey(Long.valueOf(str));
                if (null == prdOrgRoleDO) {
                    throw new BusinessException("\u672a\u627e\u5230\u8be5\u89d2\u8272" + str);
                }
                Object roleEmployees = prdOrgRoleDO.getRoleEmployees();
                if (StringUtils.isNotBlank((CharSequence)roleEmployees)) {
                    roleEmployees = (String)roleEmployees + ",";
                }
                roleEmployees = (String)roleEmployees + prdBaseBuChangeVO.getUserId();
                PrdOrgRolePayload prdOrgRolePayload = new PrdOrgRolePayload();
                prdOrgRolePayload.setId(Long.valueOf(str));
                prdOrgRolePayload.setRoleEmployees((String)roleEmployees);
                long l = this.prdOrgOrganizationDAO.updateRole(prdOrgRolePayload);
            }
        }
        return true;
    }

    public PagingVO<PrdBaseBuChangeVO> page(PrdBaseBuChangeQuery prdBaseBuChangeQuery) {
        PagingVO<PrdBaseBuChangeVO> res = this.prdBaseBuChangeDao.page(prdBaseBuChangeQuery);
        return res;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = this.prdBaseBuChangeDao.del(ids);
        return res;
    }

    public List<PrdBaseBuChangeVO> getList(PrdBaseBuChangeQuery prdBaseBuChangeQuery) {
        List<PrdBaseBuChangeVO> res = this.prdBaseBuChangeDao.getList(prdBaseBuChangeQuery);
        return res;
    }

    @Transactional
    public Long updateByCondition(PrdBaseBuChangePayload prdBaseBuChangePayload) {
        Long res = this.prdBaseBuChangeDao.update(prdBaseBuChangePayload);
        return res;
    }

    private void checkData(PrdBaseBuChangePayload prdBaseBuChangePayload) {
        Assert.notNull((Object)prdBaseBuChangePayload.getUserId(), (String)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)prdBaseBuChangePayload.getOldBuId(), (String)"OldBuId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)prdBaseBuChangePayload.getNewBuId(), (String)"NewBuId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    public void sendMessage(Long objectId, String messageTitle, String content) {
        PrdMessageConfigPayload ado = new PrdMessageConfigPayload();
        ado.setObjectId(objectId);
        ado.setMessageTitle(messageTitle);
        ado.setMessageType(Integer.valueOf(2));
        ado.setContentBigType("businessMessage");
        ado.setContentType(MessageNoticeTypeEnum.personnelMessage.getCode());
        ado.setMessageTag("important");
        ado.setIsEnable(Integer.valueOf(0));
        ado.setNoticeScope("appoint_people");
        ado.setNoticeWay("instation");
        ado.setReleaseSource("profileMessage");
        ado.setReleaseStatus(Integer.valueOf(3));
        ado.setMessageContent(content);
        ArrayList list = new ArrayList();
        list.addAll(this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_HRD.getCode()));
        list.addAll(this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_SALARY_MANAGER.getCode()));
        if (!CollectionUtils.isEmpty(list)) {
            String noticeSource = list.stream().map(p -> p.toString()).collect(Collectors.joining(","));
            ado.setNoticeSource(noticeSource);
            this.messageConfigService.insert(ado);
        }
    }

    public PrdBaseBuChangeServiceImpl(PrdBaseBuChangeDao prdBaseBuChangeDao, PrdBaseBuChangeRepo prdBaseBuChangeRepo, WorkflowUtil workflowUtil, PrdSystemRoleDAO prdSystemRoleDAO, PrdOrgOrganizationService prdOrgOrganizationService, PrdBuChangeTodoService prdBuChangeTodoService, PrdOrgEmployeeDAO prdOrgEmployeeDAO, CacheUtil cacheUtil, TimesheetService timesheetService, AccReimService accReimService, CalTaskSettleService calTaskSettleService, TaskInfoService taskInfoService, PrdOrgOrganizationDAO prdOrgOrganizationDAO, PrdMessageConfigService messageConfigService, PrdSystemRoleService roleService) {
        this.prdBaseBuChangeDao = prdBaseBuChangeDao;
        this.prdBaseBuChangeRepo = prdBaseBuChangeRepo;
        this.workflowUtil = workflowUtil;
        this.prdSystemRoleDAO = prdSystemRoleDAO;
        this.prdOrgOrganizationService = prdOrgOrganizationService;
        this.prdBuChangeTodoService = prdBuChangeTodoService;
        this.prdOrgEmployeeDAO = prdOrgEmployeeDAO;
        this.cacheUtil = cacheUtil;
        this.timesheetService = timesheetService;
        this.accReimService = accReimService;
        this.calTaskSettleService = calTaskSettleService;
        this.taskInfoService = taskInfoService;
        this.prdOrgOrganizationDAO = prdOrgOrganizationDAO;
        this.messageConfigService = messageConfigService;
        this.roleService = roleService;
    }
}

