/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.personnel.service;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.PersonEduExperiencePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonEduExperienceService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonEduExperienceVO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.convert.PersonEduExperienceConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao.PersonEduExperienceDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.PersonEduExperienceDO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.repo.PersonEduExperienceRepo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PersonEduExperienceServiceImpl
implements PersonEduExperienceService {
    private static final Logger log = LoggerFactory.getLogger(PersonEduExperienceServiceImpl.class);
    private final PersonEduExperienceRepo personEduExperienceRepo;
    private final PersonEduExperienceDAO personEduExperienceDAO;

    public void save(PersonEduExperiencePayload save) {
        PersonEduExperienceDO personEduExperienceDO = PersonEduExperienceConvert.INSTANCE.toDo(save);
        this.personEduExperienceRepo.save((Object)personEduExperienceDO);
    }

    public List<PersonEduExperienceVO> findAllByPersonId(Long personId) {
        List<PersonEduExperienceDO> personEduExperienceDOList = this.personEduExperienceRepo.findAllByPersonId(personId);
        return PersonEduExperienceConvert.INSTANCE.toVos(personEduExperienceDOList);
    }

    public void saveAll(List<PersonEduExperienceVO> eduExperienceVOList, Long personId) {
        if (eduExperienceVOList != null) {
            if (eduExperienceVOList.size() == 0) {
                this.personEduExperienceDAO.deleteAllByPersonId(personId);
            } else {
                for (PersonEduExperienceVO personEduExperienceVO : eduExperienceVOList) {
                    if (personEduExperienceVO.getPersonId() != null) continue;
                    personEduExperienceVO.setPersonId(personId);
                }
                this.personEduExperienceDAO.saveAll(PersonEduExperienceConvert.INSTANCE.toDos(eduExperienceVOList));
            }
        }
    }

    public void deleteAllByPersonId(Long personId) {
        this.personEduExperienceDAO.deleteAllByPersonId(personId);
    }

    public PersonEduExperienceServiceImpl(PersonEduExperienceRepo personEduExperienceRepo, PersonEduExperienceDAO personEduExperienceDAO) {
        this.personEduExperienceRepo = personEduExperienceRepo;
        this.personEduExperienceDAO = personEduExperienceDAO;
    }
}

