/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.UserVacationApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.UserVacationApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.service.UserVacationApplyService;
import com.elitesland.tw.tw5.api.prd.my.vo.UserVacationApplyExcelVO;
import com.elitesland.tw.tw5.api.prd.my.vo.UserVacationApplyVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.prd.my.convert.UserVacationApplyConvert;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/my/applyVacation"})
public class UserVacationApplyController {
    private static final Logger log = LoggerFactory.getLogger(UserVacationApplyController.class);
    private final UserVacationApplyService userVacationApplyService;
    private final UdcUtil udcUtil;

    @GetMapping(value={"/paging"})
    @UdcNameClass
    public TwOutputUtil paging(UserVacationApplyQuery query) {
        PagingVO paging = this.userVacationApplyService.paging(query);
        return TwOutputUtil.ok(paging);
    }

    @GetMapping(value={"/queryList"})
    @UdcNameClass
    public TwOutputUtil queryList(UserVacationApplyQuery query) {
        List userVacationApplyVOS = this.userVacationApplyService.queryList(query);
        return TwOutputUtil.ok(userVacationApplyVOS);
    }

    @GetMapping(value={"/exportExcel"})
    public void exportExcel(UserVacationApplyQuery query, HttpServletResponse response) throws IOException {
        List list = this.userVacationApplyService.list(query);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list = this.udcUtil.translateList(list);
            List<UserVacationApplyExcelVO> resultList = UserVacationApplyConvert.INSTANCE.voListVoExcelExport(list);
            String sheetName = "\u8bf7\u5047\u7533\u8bf7";
            String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), UserVacationApplyExcelVO.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
            ExcelUtil.excelHelper(sheet, UserVacationApplyExcelVO.class, null);
            sheet.doWrite(resultList);
        }
    }

    @GetMapping(value={"/{applyId}"})
    public TwOutputUtil getDetailByApplyKey(@PathVariable(value="applyId") Long applyId) {
        List list = this.userVacationApplyService.getDetailByApplyKey(applyId);
        return TwOutputUtil.ok(list);
    }

    @ApiModelProperty(value="\u8bf7\u5047\u7533\u8bf7\u63d0\u4ea4")
    @PostMapping(value={"/apply"})
    public TwOutputUtil apply(@RequestBody UserVacationApplyPayload payload) {
        this.userVacationApplyService.userVacationApply(payload);
        return TwOutputUtil.ok();
    }

    @ApiModelProperty(value="\u8bf7\u5047\u7533\u8bf7\u6d41\u7a0b\u4fe1\u606f-\u6d41\u7a0bid")
    @GetMapping(value={"/apply/query/{prcoInstId}"})
    public TwOutputUtil<UserVacationApplyVO> query(@PathVariable String prcoInstId) {
        return TwOutputUtil.ok(this.userVacationApplyService.queryApply(prcoInstId));
    }

    @ApiModelProperty(value="\u8bf7\u5047\u7533\u8bf7\u6d41\u7a0b\u4fe1\u606f")
    @GetMapping(value={"/apply/queryByKey/{businessKey}"})
    @UdcNameClass
    public TwOutputUtil<UserVacationApplyVO> queryByKey(@PathVariable String businessKey) {
        return TwOutputUtil.ok(this.userVacationApplyService.queryApplyByKey(businessKey));
    }

    @ApiModelProperty(value="\u8bf7\u5047\u7533\u8bf7\u65b0\u589e")
    @PostMapping(value={"/insert"})
    public TwOutputUtil<UserVacationApplyVO> insert(@RequestBody UserVacationApplyPayload payload) {
        return TwOutputUtil.ok(this.userVacationApplyService.userVacationInsert(payload));
    }

    @ApiModelProperty(value="\u8bf7\u5047\u7533\u8bf7\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public TwOutputUtil<UserVacationApplyVO> update(@RequestBody UserVacationApplyPayload payload) {
        return TwOutputUtil.ok(this.userVacationApplyService.userVacationUpdate(payload));
    }

    public UserVacationApplyController(UserVacationApplyService userVacationApplyService, UdcUtil udcUtil) {
        this.userVacationApplyService = userVacationApplyService;
        this.udcUtil = udcUtil;
    }
}

