/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.org.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.EmployeeBlackListQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.OfferEntryApplyQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.OfferEntryApplyVO;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgPersonPayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgPersonQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgPersonService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgPersonBSVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgPersonDetailVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgPersonVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.permission.annotation.FunctionDetail;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionDomain;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionFunction;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionCodeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionTypeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionTypeEnum;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.seata.spring.annotation.GlobalTransactional;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4eba\u624d\u5e93\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/api/org"})
@PermissionDomain(domain=PermissionDomainEnum.PRD_ORG_PERSON)
public class PrdOrgPersonController {
    private static final Logger log = LoggerFactory.getLogger(PrdOrgPersonController.class);
    private final PrdOrgPersonService personService;

    @ApiOperation(value="\u5206\u9875\u6761\u4ef6\u67e5\u8be2")
    @GetMapping(value={"/person/paging"})
    @UdcNameClass
    public TwOutputUtil<PagingVO<PrdOrgPersonVO>> queryPaging(PrdOrgPersonQuery query) {
        PagingVO paging = this.personService.paging(query);
        return TwOutputUtil.ok(paging);
    }

    @ApiOperation(value="\u6743\u9650-\u5206\u9875\u6761\u4ef6\u67e5\u8be2")
    @PostMapping(value={"/permission/person/paging"})
    @UdcNameClass
    @PermissionFunction(functions={@FunctionDetail(functionCode=FunctionCodeEnum.PRD_ORG_PERSON, type=FunctionTypeEnum.TAB)}, fieldPermission=true, permissionType=PermissionTypeEnum.DATA_PERMISSION)
    public TwOutputUtil<PagingVO<PrdOrgPersonBSVO>> permissionPaging(@RequestBody PrdOrgPersonQuery query) {
        PagingVO paging = this.personService.permissionPaging(query);
        return TwOutputUtil.ok(paging);
    }

    @ApiOperation(value="\u4fdd\u5b58\u57fa\u672c\u4fe1\u606f")
    @PostMapping(value={"/person/insert"})
    public TwOutputUtil<Long> insert(@RequestBody PrdOrgPersonPayload entity) {
        return TwOutputUtil.ok(this.personService.insert(entity));
    }

    @ApiOperation(value="\u4fee\u6539\u4fe1\u606f")
    @PostMapping(value={"/person/update"})
    public TwOutputUtil update(@RequestBody PrdOrgPersonDetailVO entity) {
        this.personService.update(entity);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="id\u67e5\u8be2")
    @GetMapping(value={"/person/{id}"})
    public TwOutputUtil<PrdOrgPersonDetailVO> findById(@PathVariable Long id) {
        return TwOutputUtil.ok(this.personService.findById(id));
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/person/delete/{id}"})
    public TwOutputUtil deleteById(@PathVariable Long id) {
        this.personService.deleteById(id);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="offer\u5165\u804c\u53d1\u653e")
    @PutMapping(value={"/person/entry"})
    @GlobalTransactional
    public TwOutputUtil personEntry(@RequestBody PrdOrgEmployeePayload entity) {
        this.personService.personEntry(entity);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="offer\u5165\u804c\u53d1\u653e\u4fe1\u606f\u4fee\u6539")
    @PutMapping(value={"/person/entry/update"})
    @GlobalTransactional
    public TwOutputUtil personEntryUpdate(@RequestBody PrdOrgEmployeePayload entity) {
        this.personService.personEntryUpdate(entity);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="offer\u5165\u804c\u53d1\u653e\u4fe1\u606f\u67e5\u8be2")
    @GetMapping(value={"/person/entry/query/{procId}"})
    public TwOutputUtil<PrdOrgEmployeePayload> personEntryQuery(@PathVariable String procId) {
        return TwOutputUtil.ok(this.personService.personEntryQuery(procId));
    }

    @ApiOperation(value="\u79fb\u5165\u9ed1\u540d\u5355")
    @GetMapping(value={"/employee/inBlack/{id}"})
    public TwOutputUtil inBlackList(@PathVariable Long id) {
        this.personService.inBlackList(id);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u79fb\u51fa\u9ed1\u540d\u5355")
    @GetMapping(value={"/employee/outBlack/{id}"})
    public TwOutputUtil outBlackList(@PathVariable Long id) {
        this.personService.outBlackList(id);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u9ed1\u540d\u5355\u5217\u8868")
    @GetMapping(value={"/employee/blackList"})
    public TwOutputUtil queryBlackList(EmployeeBlackListQuery query) {
        return TwOutputUtil.ok(this.personService.queryBlackList(query));
    }

    @ApiOperation(value="offer\u5165\u804c\u7533\u8bf7\u5217\u8868\u5206\u9875")
    @GetMapping(value={"/offer/page"})
    @UdcNameClass
    public TwOutputUtil<PagingVO<OfferEntryApplyVO>> offerApplyPage(OfferEntryApplyQuery query) {
        return TwOutputUtil.ok(this.personService.offerApplyPage(query));
    }

    @ApiOperation(value="offer\u5165\u804c\u7533\u8bf7\u5217\u8868\u5206\u9875")
    @GetMapping(value={"/offer/queryBykey/{applyId}"})
    @UdcNameClass
    public TwOutputUtil<OfferEntryApplyVO> offerApplyPage(@PathVariable Long applyId) {
        return TwOutputUtil.ok(this.personService.queryOfferByKey(applyId));
    }

    public PrdOrgPersonController(PrdOrgPersonService personService) {
        this.personService = personService;
    }
}

