/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.org.controller;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baiwang.bop.client.BopException;
import com.baiwang.open.entity.request.OutputEinvoiceQueryRequest;
import com.baiwang.open.entity.request.node.OutputEinvoiceQueryInvoiceQueryParam;
import com.baiwang.open.entity.response.OutputEinvoiceQueryResponse;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationService;
import com.elitesland.tw.tw5.api.prd.inv.service.TwInvoiceSendMsgService;
import com.elitesland.tw.tw5.api.prd.my.service.TAttendanceNormalService;
import com.elitesland.tw.tw5.api.prd.my.service.TAttendanceOtherService;
import com.elitesland.tw.tw5.api.prd.my.service.TAttendanceRecordService;
import com.elitesland.tw.tw5.api.prd.my.service.TAttendanceRemarkService;
import com.elitesland.tw.tw5.api.prd.my.service.TimesheetService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgSyncDataService;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectPayload;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectBriefService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConAchieveService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConEpibolyCostConService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConInvBatchService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConPurchaseDemandService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivableDService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivableService;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvBatchVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConReceivablePlanRepo;
import io.swagger.annotations.Api;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u7ef4\u5ea6\u7248\u672c\u7ba1\u7406")
@RestController
@RequestMapping(value={"/api/org"})
public class PrdOrgTestController {
    private static final Logger log = LoggerFactory.getLogger(PrdOrgTestController.class);
    private final PrdOrgSyncDataService service;
    private final CrmOpportunityDAO opportunityDAO;
    private final TransferUtilServiceImpl transferUtilService;
    private final SaleConContractService saleConContractService;
    private final ConReceivablePlanService conReceivablePlanService;
    private final ConReceivableService conReceivableService;
    private final ConReceivableDService conReceivableDService;
    private final ConPurchaseDemandService conPurchaseDemandService;
    private final ConEpibolyCostConService conEpibolyCostConService;
    private final ConAchieveService conAchieveService;
    private final ConInvBatchService invBatchService;
    private final TimesheetService timesheetService;
    private final HttpUtil httpUtil;
    @Value(value="${tw4.opportunity.operation}")
    private String opportunity_operation;
    @Autowired
    private TwInvoiceSendMsgService invoiceSendMsgService;
    private final TAttendanceNormalService tAttendanceNormalService;
    private final TAttendanceOtherService tAttendanceOtherService;
    private final TAttendanceRecordService tAttendanceRecordService;
    private final TAttendanceRemarkService tAttendanceRemarkService;
    private final PmsProjectBriefService pmsProjectBriefService;
    private final PmsProjectService pmsProjectService;
    private final CrmCustomerOperationService crmCustomerOperationService;
    private final ConReceivablePlanRepo conReceivablePlanRepo;

    @GetMapping(value={"/test/syncUsers"})
    public TwOutputUtil syncUsers() {
        this.service.syncUsers();
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/syncEmployeeEqvaRatio"})
    public TwOutputUtil syncEmployeeEqvaRatio() {
        this.service.syncEqvaRatio();
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/syncOrgs"})
    public TwOutputUtil syncOrgs() {
        this.service.syncOrgs();
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/syncOrgRefUsers"})
    public TwOutputUtil syncOrgRefUsers() {
        this.service.syncOrgRefUsers();
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/bangwo8/projectsprd"})
    public TwOutputUtil syncProjectsToBangwo8Pro(String param) {
        this.service.syncProjectsToBangwo8Pro(param);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/bangwo8/advisers"})
    public TwOutputUtil syncAdvisersToBangwo8() {
        this.service.syncAdvisersToBangwo8(null);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/bangwo8/tickets"})
    public TwOutputUtil syncTicketsToBangwo8(String date) {
        if (ObjectUtils.isEmpty((Object)date)) {
            return TwOutputUtil.error("\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DateTime parse = DateUtil.parse((CharSequence)date);
        LocalDateTime localDateTime = parse.toLocalDateTime();
        this.service.syncTicketsFromBangwo8(localDateTime);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/purchaseContract/main"})
    public TwOutputUtil syncPurchaseContract(@RequestParam String param) {
        this.service.syncPurchaseContractTo5(param);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/finYear"})
    public TwOutputUtil syncFinYearTo5(@RequestParam String param) {
        this.service.syncFinYearTo5(param);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/finPeriod"})
    public TwOutputUtil syncFinPeriodTo5(@RequestParam String param) {
        this.service.syncFinPeriodTo5(param);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/productClass"})
    public TwOutputUtil syncProductClassTo5(@RequestParam String param) {
        this.service.syncProductClassTo5(param);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/product"})
    public TwOutputUtil syncProductTo5(@RequestParam String param) {
        this.service.syncProductTo5(param);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/syncContractRecvplanTo4"})
    public TwOutputUtil syncContractRecvplanTo4(@RequestParam String param) {
        this.conReceivablePlanService.syncContractRecvplanTo4(param);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/syncContractInvBatchTo4"})
    public TwOutputUtil syncContractInvBatchTo4(@RequestParam String param) {
        this.invBatchService.syncContractInvBatchTo4(param);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/syncContractInvBatchInvDtlTo4"})
    public TwOutputUtil syncContractInvBatchInvDtlTo4(@RequestParam String param) {
        this.invBatchService.syncContractInvBatchInvDtlTo4(param);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/syncConReceivableTo4"})
    public TwOutputUtil syncConReceivableTo4(@RequestParam String param) {
        this.conReceivableService.syncConReceivableTo4(param);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/syncConReceivableDTo4"})
    public TwOutputUtil syncConReceivableDTo4(@RequestParam String param) {
        this.conReceivableDService.syncConReceivableDTo4(param);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/syncCostConTo4"})
    public TwOutputUtil syncCostConTo4(@RequestParam String param) {
        this.conEpibolyCostConService.syncCostConTo4(param);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/syncConAchieveTo4"})
    public TwOutputUtil syncConAchieveTo4(@RequestParam String param) {
        this.conAchieveService.syncConAchieveTo4(param);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/syncPurcDemandTo5"})
    public TwOutputUtil syncPurcDemandTo5(@RequestParam String param) {
        this.service.syncPurcDemandTo5(param);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/syncContractRecvplanTo5"})
    public TwOutputUtil syncContractRecvplanTo5(@RequestParam String param) {
        this.service.syncContractRecvplanTo5(param);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/syncCostConTo5"})
    public TwOutputUtil syncCostConTo5(@RequestParam String param) {
        this.service.syncCostConTo5(param);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/contractAchieve"})
    public TwOutputUtil syncContractAchieveTo5(@RequestParam String param) {
        this.service.syncContractAchieveTo5(param);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/receivePlan"})
    public TwOutputUtil syncReceivePlanTo5(@RequestParam String param) {
        this.service.syncReceivePlanTo5(param);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/invBatch"})
    public TwOutputUtil syncInvBatchTo5(@RequestParam String param) {
        this.service.syncInvBatchTo5(param);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/invBatchInvdtl"})
    public TwOutputUtil syncInvBatchInvdtlTo5(@RequestParam String param) {
        this.service.syncInvBatchInvdtlTo5(param);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/channelCostCon"})
    public TwOutputUtil syncChannelCostConTo5(@RequestParam String param) {
        this.service.syncChannelCostConTo5(param);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/channelCostCond"})
    public TwOutputUtil syncChannelCostCondTo5(@RequestParam String param) {
        this.service.syncChannelCostCondTo5(param);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/testOverdueOperNotice"})
    public TwOutputUtil testOverdueOperNotice(String param) {
        this.crmCustomerOperationService.overdueCompleteCustOperation(param);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/testautoCustOperation"})
    public TwOutputUtil testautoCustOperation(String param) {
        this.crmCustomerOperationService.autoCustOperation(param);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/testInvBatch/{batchId}"})
    public TwOutputUtil testautoCustOperation(@PathVariable Long batchId) {
        this.invBatchService.deleteInvInfoToBaiwang(batchId, Integer.valueOf(1));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/testPlanUpdate/{batchId}"})
    public TwOutputUtil testPlanUpdate(@PathVariable Long batchId) {
        this.conReceivablePlanRepo.updateReceStatusByBatchId(batchId, "testcode");
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/timesheetAlertAll"})
    public TwOutputUtil timesheetAlertAll(@RequestParam String param) {
        Long employeeId = !StringUtils.hasText((String)param) ? null : Long.valueOf(Long.parseLong(param));
        this.timesheetService.timesheetAlertAll(employeeId);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/timesheetAlertAllBack"})
    public TwOutputUtil timesheetAlertAllBack(@RequestParam String param) {
        Long employeeId = !StringUtils.hasText((String)param) ? null : Long.valueOf(Long.parseLong(param));
        this.timesheetService.timesheetAlertAllBack(employeeId);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/sync/bangwo8timesheet/{ticketId}"})
    public TwOutputUtil timesheetAlertAll(@PathVariable Long ticketId) {
        this.service.syncTicketsFromBangwo8Single(ticketId);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/projectBriefJobHandler"})
    public TwOutputUtil projectBriefJobHandler(@RequestParam String date) {
        this.pmsProjectBriefService.projectBriefJobHandler(date);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/sync/invoicing"})
    public TwOutputUtil invoicingAll() {
        this.invBatchService.getInvoicesFromBaiwang();
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/sendEmail/{invBatchId}"})
    public TwOutputUtil sendEmail(@PathVariable Long invBatchId) {
        ConInvBatchVO conInvBatchVO = this.invBatchService.queryByKey(invBatchId);
        this.invBatchService.sendEmail(conInvBatchVO);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/getBatchDetail/{tempBatchNo}"})
    public TwOutputUtil getBatchInv(@PathVariable String tempBatchNo) {
        OutputEinvoiceQueryRequest request = new OutputEinvoiceQueryRequest();
        OutputEinvoiceQueryInvoiceQueryParam data = new OutputEinvoiceQueryInvoiceQueryParam();
        data.setPageNo(Integer.valueOf(1));
        data.setPageSize(Integer.valueOf(500));
        data.setSerialNo(tempBatchNo);
        request.setData(data);
        request.setTaxNo("91310000766919029T");
        try {
            OutputEinvoiceQueryResponse response = this.invoiceSendMsgService.invoiceQuery(request);
            if (response.getSuccess().booleanValue() && response.getResponse().size() > 0) {
                List reInvs = response.getResponse();
                return TwOutputUtil.ok(reInvs);
            }
        }
        catch (BopException e) {
            log.error("[\u767e\u671b\u7cfb\u7edf\u83b7\u53d6\u5f00\u7968\u4fe1\u606f\u5931\u8d25],TW\u6279\u6b21\u53f7\uff1a", new Object[]{",\u767e\u671b\u6d41\u6c34\u53f7\uff1a", tempBatchNo, ",response=", e});
        }
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/sync/attendanceNormalTo5"})
    public TwOutputUtil attendanceNormalTo5(@RequestParam String param) {
        this.tAttendanceNormalService.attendanceNormalTo5(param);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/sync/attendanceOtherTo5"})
    public TwOutputUtil attendanceOtherTo5(@RequestParam String param) {
        this.tAttendanceOtherService.attendanceOtherTo5(param);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/sync/attendanceRecordTo5"})
    public TwOutputUtil attendanceRecordTo5(@RequestParam String param) {
        this.tAttendanceRecordService.attendanceRecordTo5(param);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/sync/attendanceRemarkTo5"})
    public TwOutputUtil attendanceRemarkTo5(@RequestParam String param) {
        this.tAttendanceRemarkService.attendanceRemarkTo5(param);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/test/sync/autoCreateProject"})
    public TwOutputUtil autoCreateProject(@RequestParam String contractId) {
        long id = Long.parseLong(contractId);
        SaleConContractVO saleConContractVO = this.saleConContractService.queryByKey(Long.valueOf(id), new Boolean[0]);
        PmsProjectPayload pmsProjectPayload = this.pmsProjectService.autoCreateProject(saleConContractVO);
        this.pmsProjectService.insertOrUpdate(pmsProjectPayload);
        return TwOutputUtil.ok();
    }

    public PrdOrgTestController(PrdOrgSyncDataService service, CrmOpportunityDAO opportunityDAO, TransferUtilServiceImpl transferUtilService, SaleConContractService saleConContractService, ConReceivablePlanService conReceivablePlanService, ConReceivableService conReceivableService, ConReceivableDService conReceivableDService, ConPurchaseDemandService conPurchaseDemandService, ConEpibolyCostConService conEpibolyCostConService, ConAchieveService conAchieveService, ConInvBatchService invBatchService, TimesheetService timesheetService, HttpUtil httpUtil, TAttendanceNormalService tAttendanceNormalService, TAttendanceOtherService tAttendanceOtherService, TAttendanceRecordService tAttendanceRecordService, TAttendanceRemarkService tAttendanceRemarkService, PmsProjectBriefService pmsProjectBriefService, PmsProjectService pmsProjectService, CrmCustomerOperationService crmCustomerOperationService, ConReceivablePlanRepo conReceivablePlanRepo) {
        this.service = service;
        this.opportunityDAO = opportunityDAO;
        this.transferUtilService = transferUtilService;
        this.saleConContractService = saleConContractService;
        this.conReceivablePlanService = conReceivablePlanService;
        this.conReceivableService = conReceivableService;
        this.conReceivableDService = conReceivableDService;
        this.conPurchaseDemandService = conPurchaseDemandService;
        this.conEpibolyCostConService = conEpibolyCostConService;
        this.conAchieveService = conAchieveService;
        this.invBatchService = invBatchService;
        this.timesheetService = timesheetService;
        this.httpUtil = httpUtil;
        this.tAttendanceNormalService = tAttendanceNormalService;
        this.tAttendanceOtherService = tAttendanceOtherService;
        this.tAttendanceRecordService = tAttendanceRecordService;
        this.tAttendanceRemarkService = tAttendanceRemarkService;
        this.pmsProjectBriefService = pmsProjectBriefService;
        this.pmsProjectService = pmsProjectService;
        this.crmCustomerOperationService = crmCustomerOperationService;
        this.conReceivablePlanRepo = conReceivablePlanRepo;
    }
}

