/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.partner.common.service;

import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmPeoplePayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmPeopleService;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BookContactsPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookContactsQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookContactsService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookContactsVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.partner.common.convert.BookContactsConvert;
import com.elitesland.tw.tw5.server.prd.partner.common.dao.BookContactsDAO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.BookContactsDO;
import com.elitesland.tw.tw5.server.prd.partner.common.repo.BookContactsRepo;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BookContactsServiceImpl
extends BaseServiceImpl
implements BookContactsService {
    private static final Logger log = LoggerFactory.getLogger(BookContactsServiceImpl.class);
    private final BookContactsRepo bookContactsRepo;
    private final BookContactsDAO bookContactsDAO;
    private final PrdSystemLogService logService;
    private final ChangeFieldLogUtil changeFieldLogUtil;

    public PagingVO<BookContactsVO> queryPaging(BookContactsQuery query) {
        return this.bookContactsDAO.queryPaging(query);
    }

    public List<BookContactsVO> queryListDynamic(BookContactsQuery query) {
        return this.bookContactsDAO.queryListDynamic(query);
    }

    public BookContactsVO queryByKey(Long key) {
        BookContactsVO bookContactsVO = this.bookContactsDAO.queryByKey(key);
        if (bookContactsVO == null) {
            throw TwException.error("", "\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        return bookContactsVO;
    }

    public BookContactsVO queryDefaultByBookId(Long bookId) {
        return this.bookContactsDAO.queryDefaultByBookId(bookId);
    }

    @Transactional(rollbackFor={Exception.class})
    public BookContactsVO insert(BookContactsPayload payload, Boolean logFlag) {
        BookContactsDO defaultDO = this.bookContactsRepo.findByBookIdAndIsDefault(payload.getBookId(), true);
        if (payload.getIsDefault() != null && payload.getIsDefault().booleanValue() && defaultDO != null) {
            defaultDO.setIsDefault(false);
            this.bookContactsRepo.save(defaultDO);
        }
        if (defaultDO == null) {
            payload.setIsDefault(Boolean.valueOf(true));
        }
        BookContactsDO entityDo = BookContactsConvert.INSTANCE.toDo(payload);
        CrmPeopleService crmPeopleService = (CrmPeopleService)SpringUtil.getBean(CrmPeopleService.class);
        CrmPeoplePayload crmPeoplePayload = new CrmPeoplePayload();
        crmPeoplePayload.setPeopleName(entityDo.getContactsName());
        crmPeoplePayload.setCustomerId(payload.getPartnerId());
        crmPeoplePayload.setBirthday(entityDo.getBirthday());
        crmPeoplePayload.setMobile(entityDo.getContactsPhone());
        crmPeoplePayload.setEmail(entityDo.getContactsEmail());
        crmPeoplePayload.setSocialIdentity(entityDo.getSocialAccountType());
        crmPeoplePayload.setJobs(entityDo.getContactsPosition());
        crmPeoplePayload.setLocationDetail(entityDo.getContactsAddress());
        crmPeoplePayload.setSex(entityDo.getSex());
        crmPeopleService.insertOrUpdate(crmPeoplePayload);
        if (logFlag.booleanValue() && payload.getPartnerId() != null) {
            this.logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "\u65b0\u589e\u4e86\u4e00\u6761\u8054\u7cfb\u4eba\u4fe1\u606f");
        }
        BusinessPartnerService businessPartnerService = (BusinessPartnerService)SpringUtil.getBean(BusinessPartnerService.class);
        businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(payload.getBookId()));
        return BookContactsConvert.INSTANCE.toVo((BookContactsDO)this.bookContactsRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public BookContactsVO update(BookContactsPayload payload, Boolean logFlag) {
        BookContactsDO defaultDO;
        BookContactsDO entity = this.bookContactsRepo.findById(payload.getId()).orElseGet(BookContactsDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        if (payload.getIsDefault() != null && payload.getIsDefault().booleanValue() && (defaultDO = this.bookContactsRepo.findByBookIdAndIsDefault(payload.getBookId(), true)) != null && !defaultDO.getId().equals(payload.getId())) {
            defaultDO.setIsDefault(false);
            this.bookContactsRepo.save(defaultDO);
        }
        BookContactsDO entityDo = BookContactsConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        if (logFlag.booleanValue() && null != payload.getPartnerId()) {
            this.logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "\u4fee\u6539\u4e86\u4e00\u6761\u8054\u7cfb\u4eba\u4fe1\u606f");
        }
        BusinessPartnerService businessPartnerService = (BusinessPartnerService)SpringUtil.getBean(BusinessPartnerService.class);
        businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(entity.getBookId()));
        return BookContactsConvert.INSTANCE.toVo((BookContactsDO)this.bookContactsRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys, Long bookId, Long partnerId, Boolean logFlag) {
        if (!keys.isEmpty()) {
            this.bookContactsDAO.deleteSoft(keys);
            List<BookContactsDO> dos = this.bookContactsDAO.queryByBookId(bookId);
            if (dos != null && dos.size() == 1) {
                BookContactsDO bookContactsDO = dos.get(0);
                bookContactsDO.setIsDefault(true);
                this.bookContactsRepo.save(bookContactsDO);
            }
            if (logFlag.booleanValue()) {
                this.logService.saveNewLog(partnerId, PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "\u5220\u9664\u4e86 " + keys.size() + " \u6761\u8054\u7cfb\u4eba\u4fe1\u606f");
            }
            BusinessPartnerService businessPartnerService = (BusinessPartnerService)SpringUtil.getBean(BusinessPartnerService.class);
            businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(bookId));
        }
    }

    public List<BookContactsVO> listSimple() {
        return this.bookContactsDAO.queryListDynamic(new BookContactsQuery());
    }

    public Long count(BookContactsQuery query) {
        return this.bookContactsDAO.count(query);
    }

    public BookContactsServiceImpl(BookContactsRepo bookContactsRepo, BookContactsDAO bookContactsDAO, PrdSystemLogService logService, ChangeFieldLogUtil changeFieldLogUtil) {
        this.bookContactsRepo = bookContactsRepo;
        this.bookContactsDAO = bookContactsDAO;
        this.logService = logService;
        this.changeFieldLogUtil = changeFieldLogUtil;
    }
}

