/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.partner.strategy.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyRefPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessStrategyRefQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.service.BusinessStrategyRefService;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyCustomerVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyRefVO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.convert.BusinessStrategyRefConvert;
import com.elitesland.tw.tw5.server.prd.partner.strategy.dao.BusinessStrategyRefDAO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.entity.BusinessStrategyRefDO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.repo.BusinessStrategyRefRepo;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BusinessStrategyRefServiceImpl
extends BaseServiceImpl
implements BusinessStrategyRefService {
    private static final Logger log = LoggerFactory.getLogger(BusinessStrategyRefServiceImpl.class);
    private final BusinessStrategyRefRepo businessStrategyRefRepo;
    private final BusinessStrategyRefDAO businessStrategyRefDAO;

    public PagingVO<BusinessStrategyRefVO> queryPaging(BusinessStrategyRefQuery query) {
        return this.businessStrategyRefDAO.queryPaging(query);
    }

    public List<BusinessStrategyRefVO> queryListDynamic(BusinessStrategyRefQuery query) {
        return this.businessStrategyRefDAO.queryListDynamic(query);
    }

    public BusinessStrategyRefVO queryByKey(Long key) {
        BusinessStrategyRefDO entity = this.businessStrategyRefRepo.findById(key).orElseGet(BusinessStrategyRefDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessStrategyRefVO vo = BusinessStrategyRefConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessStrategyRefVO insert(BusinessStrategyRefPayload payload) {
        BusinessStrategyRefDO entityDo = BusinessStrategyRefConvert.INSTANCE.toDo(payload);
        return BusinessStrategyRefConvert.INSTANCE.toVo((BusinessStrategyRefDO)this.businessStrategyRefRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessStrategyRefVO update(BusinessStrategyRefPayload payload) {
        BusinessStrategyRefDO entity = this.businessStrategyRefRepo.findById(payload.getId()).orElseGet(BusinessStrategyRefDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessStrategyRefDO entityDo = BusinessStrategyRefConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessStrategyRefConvert.INSTANCE.toVo((BusinessStrategyRefDO)this.businessStrategyRefRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(BusinessStrategyRefPayload payload) {
        BusinessStrategyRefDO entity = this.businessStrategyRefRepo.findById(payload.getId()).orElseGet(BusinessStrategyRefDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.businessStrategyRefDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.businessStrategyRefDAO.deleteSoft(keys);
        }
    }

    public void saveAll(List<BusinessStrategyRefPayload> payloadList, Long strategyId) {
        List BusinessStrategyRefDOList = payloadList.stream().map(payLoad -> {
            BusinessStrategyRefDO businessStrategyRefDO = new BusinessStrategyRefDO();
            BeanUtil.copyProperties((Object)payLoad, (Object)businessStrategyRefDO, (CopyOptions)CopyOptions.create().setIgnoreNullValue(true));
            businessStrategyRefDO.setStrategyId(strategyId);
            return businessStrategyRefDO;
        }).collect(Collectors.toList());
        this.businessStrategyRefRepo.saveAll(BusinessStrategyRefDOList);
    }

    public List<BusinessStrategyRefVO> queryListByStrategyId(Long strategyId) {
        List<BusinessStrategyRefVO> businessStrategyRefVOList = this.businessStrategyRefDAO.findByStrategyId(strategyId);
        return businessStrategyRefVOList;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoftByStrategyId(Long strategyId) {
        this.businessStrategyRefDAO.deleteSoftByStrategyId(strategyId);
    }

    public List<BusinessStrategyCustomerVO> queryAppointCustomerInfoByStrategyId(Long strategyId) {
        return this.businessStrategyRefDAO.queryAppointCustomerInfoByStrategyId(strategyId);
    }

    public BusinessStrategyRefServiceImpl(BusinessStrategyRefRepo businessStrategyRefRepo, BusinessStrategyRefDAO businessStrategyRefDAO) {
        this.businessStrategyRefRepo = businessStrategyRefRepo;
        this.businessStrategyRefDAO = businessStrategyRefDAO;
    }
}

