/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PersonPlanDtlPayload;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PersonPlanPayload;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsInnerProjectApplyPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsInnerProjectApplyQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsInnerProjectApplyService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsInnerProjectApplyVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectTemplateVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.SaleConContractPayload;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.common.util.DataUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SaleConEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.personplan.constants.PersonPlanTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsProcDefKey;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsInnerProjectApplyConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsInnerProjectApplyDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectTemplateDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsInnerProjectApplyDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsInnerProjectApplyRepo;
import com.elitesland.tw.tw5.server.yeedocref.YeedocUtils;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ActionType;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class PmsInnerProjectApplyServiceImpl
extends BaseServiceImpl
implements PmsInnerProjectApplyService {
    private static final Logger log = LoggerFactory.getLogger(PmsInnerProjectApplyServiceImpl.class);
    private final PmsInnerProjectApplyRepo pmsInnerProjectApplyRepo;
    private final PmsInnerProjectApplyDAO pmsInnerProjectApplyDAO;
    private final WorkflowUtil workflowUtil;
    private final FileUtil fileUtil;
    private final CacheUtil cacheUtil;
    private final PrdSystemRoleService roleService;
    private final SaleConContractService saleConContractService;
    private final PmsProjectTemplateDAO pmsProjectTemplateDAO;
    private final PmsProjectDAO pmsProjectDAO;
    private final PersonPlanService personPlanService;
    @Value(value="${tw5.sys_default.ou_book_id:1001}")
    private Long ou_book_id;
    private final YeedocUtils yeedocUtils;

    public PagingVO<PmsInnerProjectApplyVO> queryPaging(PmsInnerProjectApplyQuery query) {
        this.operPermissionFlag(query);
        return this.pmsInnerProjectApplyDAO.queryPaging(query);
    }

    void operPermissionFlag(PmsInnerProjectApplyQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        query.setLoginUserId(loginUserId);
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.OPS.getCode()));
        query.setPermissionFlag(Boolean.valueOf(rolePermission == false));
    }

    public List<PmsInnerProjectApplyVO> queryListDynamic(PmsInnerProjectApplyQuery query) {
        return this.pmsInnerProjectApplyDAO.queryListDynamic(query);
    }

    public PmsInnerProjectApplyVO queryByKey(Long key) {
        PmsInnerProjectApplyDO entity = this.pmsInnerProjectApplyRepo.findById(key).orElseGet(PmsInnerProjectApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsInnerProjectApplyVO vo = PmsInnerProjectApplyConvert.INSTANCE.toVo(entity);
        this.transferData(vo);
        vo.setProcInstName("P08.\u5185\u90e8\u9879\u76ee\u7acb\u9879\u7533\u8bf7-" + vo.getProjName());
        return vo;
    }

    public void addProject(long id, long projId) {
        this.pmsInnerProjectApplyDAO.addProjId(id, projId);
        PmsInnerProjectApplyVO innerProjectApplyVO = this.pmsInnerProjectApplyDAO.queryByKey(id);
        this.pmsProjectDAO.addContractId(projId, innerProjectApplyVO.getContractId());
        PersonPlanVO personPlanVO = this.personPlanService.getByObjIdAndPlanType(Long.valueOf(id), Arrays.asList(PersonPlanTypeEnum.INNER_PROJECT.getCode()));
        if (personPlanVO != null) {
            PersonPlanPayload personPlanPayload = new PersonPlanPayload();
            BeanUtils.copyProperties((Object)personPlanVO, (Object)personPlanPayload);
            personPlanPayload.setId(null);
            personPlanPayload.setVersion("0");
            personPlanPayload.setPlanType(PersonPlanTypeEnum.PROJECT.getCode());
            personPlanPayload.setObjId(Long.valueOf(projId));
            List personPlanDtlVOList = personPlanVO.getPersonPlanDtlVOList();
            if (!CollectionUtils.isEmpty((Collection)personPlanDtlVOList)) {
                ArrayList personPlanDtlPayloadList = new ArrayList();
                personPlanDtlVOList.stream().forEach(personPlanDtlVO -> {
                    PersonPlanDtlPayload personPlanDtlPayload = new PersonPlanDtlPayload();
                    BeanUtils.copyProperties((Object)personPlanDtlVO, (Object)personPlanDtlPayload);
                    personPlanDtlPayload.setId(null);
                    personPlanDtlPayload.setPlanId(null);
                    personPlanDtlPayloadList.add(personPlanDtlPayload);
                });
                personPlanPayload.setPersonPlanDtlPayloadList(personPlanDtlPayloadList);
            }
            this.personPlanService.save(personPlanPayload);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsInnerProjectApplyVO save(PmsInnerProjectApplyPayload payload) {
        List<PmsProjectVO> pmsProjectVOS;
        PrdSystemSelectionVO systemSelectionVO;
        Optional<PrdSystemSelectionVO> optional;
        DataUtil.checkDataLength(payload, null);
        Boolean errFlag = true;
        PrdSystemSelectionVO selection = this.cacheUtil.getSystemSelection("salecon:work_type");
        if (!ObjectUtils.isEmpty((Object)selection) && (optional = selection.getChildren().stream().filter(v -> v.getSelectionValue().equals(payload.getWorkType())).findFirst()).isPresent() && "NO_CONTRACT".equals((systemSelectionVO = optional.get()).getExtString3())) {
            errFlag = false;
        }
        if (errFlag.booleanValue()) {
            throw TwException.error("", "\u5185\u90e8\u9879\u76ee\u5de5\u4f5c\u7c7b\u578b\u9009\u62e9\u4e0d\u7b26\u5408\u9650\u5236,\u8bf7\u6838\u9a8c\uff01");
        }
        String code = this.generateSeqNum("PMS_APPLY_PROJECT", new String[0]);
        payload.setApplyNo(code);
        payload.setApprStatus(ProjectStatusEnum.ACTIVE.getCode());
        SaleConContractVO contract = this.createContract(payload);
        this.innerPrjFileHandle(payload);
        PmsInnerProjectApplyDO entityDo = PmsInnerProjectApplyConvert.INSTANCE.toDo(payload);
        PmsProjectDO pmsProjectDO = new PmsProjectDO();
        BeanUtils.copyProperties((Object)entityDo, (Object)pmsProjectDO);
        pmsProjectDO.setProjStatus(ProjectStatusEnum.ACTIVE.getCode());
        pmsProjectDO.setProjNo(code);
        pmsProjectDO.setContractId(contract.getId());
        pmsProjectDO.setPlanStartDate(entityDo.getStartDate());
        pmsProjectDO.setPlanEndDate(entityDo.getEndDate());
        if (pmsProjectDO.getRelatedProjId() != null && !ObjectUtils.isEmpty(pmsProjectVOS = this.pmsProjectDAO.queryByKeys(Arrays.asList(pmsProjectDO.getRelatedProjId())))) {
            pmsProjectDO.setRelatedProjNo(pmsProjectVOS.get(0).getProjNo());
        }
        PmsProjectTemplateVO pmsProjectTemplateVO = this.pmsProjectTemplateDAO.queryByKey(pmsProjectDO.getProjTempId());
        pmsProjectDO.setSubjectTempId(pmsProjectTemplateVO.getSubjectTemplateId());
        PmsProjectDO save = this.pmsProjectDAO.save(pmsProjectDO);
        entityDo.setProjId(save.getId());
        entityDo.setContractId(contract.getId());
        entityDo = this.pmsInnerProjectApplyDAO.save(entityDo);
        PmsInnerProjectApplyVO innerProjectApplyVO = PmsInnerProjectApplyConvert.INSTANCE.toVo(entityDo);
        return innerProjectApplyVO;
    }

    SaleConContractVO createContract(PmsInnerProjectApplyPayload projApplyNoContract) {
        SaleConContractPayload payload = new SaleConContractPayload();
        payload.setName(projApplyNoContract.getProjName() + "-\u865a\u62df\u5408\u540c");
        payload.setStatus("ACTIVE");
        payload.setMainType(SaleConEnum.MAIN.getCode());
        payload.setPlatType(SaleConEnum.FICTITIOUS.getCode());
        payload.setOuBookId(this.ou_book_id);
        payload.setAmt(BigDecimal.ZERO);
        payload.setExtraAmt(BigDecimal.ZERO);
        payload.setTaxRate(BigDecimal.ZERO);
        payload.setEffectiveAmt(BigDecimal.ZERO);
        payload.setGrossProfit(BigDecimal.ZERO);
        payload.setRatedEqva(BigDecimal.ZERO);
        payload.setRatedExpense(BigDecimal.ZERO);
        payload.setProductClass("05");
        payload.setProductSubClass("TW");
        payload.setCustBarExpense("0");
        payload.setWorkType(projApplyNoContract.getWorkType());
        payload.setCurrCode(projApplyNoContract.getCurrCode());
        payload.setDeliUserId(projApplyNoContract.getDeliResId());
        payload.setDeliBuId(projApplyNoContract.getDeliBuId());
        payload.setSaleManUserId(projApplyNoContract.getSalesmanResId());
        payload.setSignDate(LocalDate.now());
        payload.setProcInstStatus(ProcInstStatus.APPROVED);
        payload.setApprovedTime(LocalDateTime.now());
        payload.setCreateUserId(projApplyNoContract.getCreateUserId());
        payload.setFileFlag(Boolean.valueOf(false));
        SaleConContractVO conContractVO = this.saleConContractService.insert(payload);
        payload.setParentId(conContractVO.getId());
        payload.setId(null);
        payload.setMainType(SaleConEnum.SUB.getCode());
        payload.setName(projApplyNoContract.getProjName() + "-\u865a\u62df\u5b50\u5408\u540c");
        conContractVO = this.saleConContractService.insert(payload);
        return conContractVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsInnerProjectApplyVO insert(PmsInnerProjectApplyPayload payload) {
        PmsInnerProjectApplyDO entityDo = PmsInnerProjectApplyConvert.INSTANCE.toDo(payload);
        return PmsInnerProjectApplyConvert.INSTANCE.toVo((PmsInnerProjectApplyDO)this.pmsInnerProjectApplyRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsInnerProjectApplyVO update(PmsInnerProjectApplyPayload payload) {
        PmsInnerProjectApplyDO entity = this.pmsInnerProjectApplyRepo.findById(payload.getId()).orElseGet(PmsInnerProjectApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsInnerProjectApplyDO entityDo = PmsInnerProjectApplyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsInnerProjectApplyConvert.INSTANCE.toVo((PmsInnerProjectApplyDO)this.pmsInnerProjectApplyRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PmsInnerProjectApplyPayload payload) {
        PmsInnerProjectApplyDO entity = this.pmsInnerProjectApplyRepo.findById(payload.getId()).orElseGet(PmsInnerProjectApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        this.innerPrjFileHandle(payload);
        long result = this.pmsInnerProjectApplyDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.pmsInnerProjectApplyDAO.deleteSoft(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void createContract(long id) {
        PmsInnerProjectApplyVO projApplyNoContract = this.pmsInnerProjectApplyDAO.queryByKey(id);
        if (projApplyNoContract != null) {
            SaleConContractPayload payload = new SaleConContractPayload();
            payload.setName(projApplyNoContract.getProjName() + "-\u865a\u62df\u5408\u540c");
            payload.setStatus("ACTIVE");
            payload.setMainType(SaleConEnum.MAIN.getCode());
            payload.setPlatType(SaleConEnum.FICTITIOUS.getCode());
            payload.setOuBookId(this.ou_book_id);
            payload.setAmt(BigDecimal.ZERO);
            payload.setExtraAmt(BigDecimal.ZERO);
            payload.setTaxRate(BigDecimal.ZERO);
            payload.setEffectiveAmt(BigDecimal.ZERO);
            payload.setGrossProfit(BigDecimal.ZERO);
            payload.setRatedEqva(BigDecimal.ZERO);
            payload.setRatedExpense(BigDecimal.ZERO);
            payload.setProductClass("50");
            payload.setProductSubClass("TW");
            payload.setCustBarExpense("0");
            payload.setWorkType(projApplyNoContract.getWorkType());
            payload.setCurrCode(projApplyNoContract.getCurrCode());
            payload.setDeliUserId(projApplyNoContract.getDeliResId());
            payload.setDeliBuId(projApplyNoContract.getDeliBuId());
            payload.setSaleManUserId(projApplyNoContract.getSalesmanResId());
            payload.setSignDate(LocalDate.now());
            payload.setProcInstStatus(ProcInstStatus.APPROVED);
            payload.setApprovedTime(LocalDateTime.now());
            payload.setCreateUserId(projApplyNoContract.getCreateUserId());
            payload.setFileFlag(Boolean.valueOf(false));
            SaleConContractVO conContractVO = this.saleConContractService.insert(payload);
            payload.setParentId(conContractVO.getId());
            payload.setId(null);
            payload.setMainType(SaleConEnum.SUB.getCode());
            payload.setName(projApplyNoContract.getProjName() + "-\u865a\u62df\u5b50\u5408\u540c");
            conContractVO = this.saleConContractService.insert(payload);
            this.pmsInnerProjectApplyDAO.addContractId(id, conContractVO.getId());
        }
    }

    public void taskCreated(TaskCreatedPayload payload) {
        String businessKey = payload.getBusinessKey();
        CommentInfo commentInfo = payload.getCommentInfo();
        if (!ObjectUtils.isEmpty((Object)commentInfo)) {
            ActionType actionType = commentInfo.getType();
            String nextTaskKey = payload.getTaskKey();
            String apprStatus = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            ProcInstStatus procInstStatus = ProcInstStatus.APPROVING;
            switch (actionType) {
                case REJECTED: {
                    if ("Activity_1jdr3h2".equals(nextTaskKey) || "Activity_14wzm2o".equals(nextTaskKey) || "Activity_0597v9a".equals(nextTaskKey) || "Activity_1gc7tub".equals(nextTaskKey) || "Activity_1wuw7tu".equals(nextTaskKey)) break;
                    apprStatus = WorkFlowStatusEnum.CREATE_WORK.getCode();
                    procInstStatus = ProcInstStatus.REJECTED;
                    break;
                }
                case REVOKE: {
                    apprStatus = WorkFlowStatusEnum.CREATE_WORK.getCode();
                    procInstStatus = ProcInstStatus.NOTSUBMIT;
                    break;
                }
                case AGREE: {
                    if (!"Activity_07xa87t".equals(nextTaskKey)) break;
                    this.createContract(Long.valueOf(businessKey));
                    break;
                }
                case AUTO_AGREE: {
                    if (!"Activity_07xa87t".equals(nextTaskKey)) break;
                    this.createContract(Long.valueOf(businessKey));
                }
            }
            if (!ObjectUtils.isEmpty((Object)apprStatus)) {
                PmsInnerProjectApplyPayload innerProjectApplyPayload = new PmsInnerProjectApplyPayload();
                innerProjectApplyPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
                innerProjectApplyPayload.setApprStatus(apprStatus);
                innerProjectApplyPayload.setProcInstStatus(procInstStatus);
                this.pmsInnerProjectApplyDAO.updateWorkFlow(innerProjectApplyPayload);
            }
        }
    }

    public void processStatusChange(ProcessStatusChangePayload payload) {
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        PmsInnerProjectApplyVO processVO = this.pmsInnerProjectApplyDAO.queryByKey(Long.valueOf(businessKey));
        if (processVO != null) {
            PmsInnerProjectApplyPayload innerProjectApplyPayload = new PmsInnerProjectApplyPayload();
            innerProjectApplyPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    innerProjectApplyPayload.setApprStatus(ProjectStatusEnum.CREATE.getCode());
                    innerProjectApplyPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                }
                case INTERRUPT: {
                    innerProjectApplyPayload.setApprStatus(ProjectStatusEnum.CREATE.getCode());
                    break;
                }
                case INVALID: {
                    innerProjectApplyPayload.setDeleteFlag(Integer.valueOf(1));
                    innerProjectApplyPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                }
                case REJECTED: {
                    innerProjectApplyPayload.setApprStatus(ProjectStatusEnum.CREATE.getCode());
                    innerProjectApplyPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    innerProjectApplyPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    innerProjectApplyPayload.setApprovedTime(LocalDateTime.now());
                    innerProjectApplyPayload.setApprStatus(ProjectStatusEnum.ACTIVE.getCode());
                    break;
                }
            }
            this.pmsInnerProjectApplyDAO.updateWorkFlow(innerProjectApplyPayload);
        }
    }

    private void submitReportProc(PmsInnerProjectApplyVO innerProjectApplyVO) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("Activity_0vqr33g", this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_RESOURCE_DIRECTOR.getCode()));
        PrdOrgOrganizationVO expenseBu = this.cacheUtil.getOrg(innerProjectApplyVO.getExpenseBuId());
        variables.put("Activity_1jdr3h2", CollUtil.newArrayList((Object[])new Long[]{expenseBu.getManageId()}));
        PrdOrgOrganizationVO deliBu = this.cacheUtil.getOrg(innerProjectApplyVO.getDeliBuId());
        variables.put("Activity_14wzm2o", CollUtil.newArrayList((Object[])new Long[]{deliBu.getManageId()}));
        variables.put("develop", "DEVELOP".equals(innerProjectApplyVO.getWorkType()));
        variables.put("Activity_0597v9a", this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_ALL_PIC.getCode()));
        variables.put("Activity_1gc7tub", CollUtil.newArrayList((Collection)this.roleService.queryUserIdByRoleCode(RoleEnum.DEVELIP_PIC.getCode())));
        variables.put("Activity_1wuw7tu", this.roleService.queryUserIdByRoleCode(RoleEnum.PROJECT_CHECK_INFORM_FIN.getCode()));
        variables.put("Activity_07xa87t", CollUtil.newArrayList((Object[])new Long[]{innerProjectApplyVO.getCreateUserId()}));
        String procInstName = "P08.\u5185\u90e8\u9879\u76ee\u7acb\u9879\u7533\u8bf7-" + innerProjectApplyVO.getProjName();
        ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)PmsProcDefKey.PMS_INNER_PROJECT.name(), (String)procInstName, (String)("" + innerProjectApplyVO.getId()), variables), new Long[0]);
        PmsInnerProjectApplyPayload payload = new PmsInnerProjectApplyPayload();
        payload.setId(innerProjectApplyVO.getId());
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setApprStatus(ProjectStatusEnum.APPROVING.getCode());
        this.pmsInnerProjectApplyDAO.updateWorkFlow(payload);
    }

    void transferData(PmsInnerProjectApplyVO vo) {
        vo.setSowFilesData(this.fileUtil.getFileDatas(vo.getSowFiles()));
        vo.setBudgetFilesData(this.fileUtil.getFileDatas(vo.getBudgetFiles()));
        vo.setResearchFilesData(this.fileUtil.getFileDatas(vo.getResearchFiles()));
        vo.setCreator(this.cacheUtil.getUserName(vo.getCreateUserId()));
        if (!ObjectUtils.isEmpty((Object)vo.getProjTempId())) {
            PmsProjectTemplateVO pmsProjectTemplateVO = this.pmsProjectTemplateDAO.queryByKey(vo.getProjTempId());
            vo.setProjTempName(pmsProjectTemplateVO.getTemplateName());
        }
    }

    private void innerPrjFileHandle(PmsInnerProjectApplyPayload payload) {
        Map<String, Object> context = BeanUtil.beanToMap(payload);
        String researchFilesStr = this.yeedocUtils.saveYeedocFileByFieldConfig(context, payload.getResearchFiles());
        payload.setResearchFiles(researchFilesStr);
    }

    public PmsInnerProjectApplyServiceImpl(PmsInnerProjectApplyRepo pmsInnerProjectApplyRepo, PmsInnerProjectApplyDAO pmsInnerProjectApplyDAO, WorkflowUtil workflowUtil, FileUtil fileUtil, CacheUtil cacheUtil, PrdSystemRoleService roleService, SaleConContractService saleConContractService, PmsProjectTemplateDAO pmsProjectTemplateDAO, PmsProjectDAO pmsProjectDAO, PersonPlanService personPlanService, YeedocUtils yeedocUtils) {
        this.pmsInnerProjectApplyRepo = pmsInnerProjectApplyRepo;
        this.pmsInnerProjectApplyDAO = pmsInnerProjectApplyDAO;
        this.workflowUtil = workflowUtil;
        this.fileUtil = fileUtil;
        this.cacheUtil = cacheUtil;
        this.roleService = roleService;
        this.saleConContractService = saleConContractService;
        this.pmsProjectTemplateDAO = pmsProjectTemplateDAO;
        this.pmsProjectDAO = pmsProjectDAO;
        this.personPlanService = personPlanService;
        this.yeedocUtils = yeedocUtils;
    }
}

