/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdAbilityLevelQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdCompositeAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdAbilityLevelService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdCompositeAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdAbilityLevelVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdCompositeAbilityVO;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PmsTimesheetCommonService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsResourcePlanDaysPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsResourcePlanPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsResourcePlanRolePayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectMembersQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsResourcePlanDaysQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsResourcePlanRoleQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectMembersService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsResourcePlanDaysService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsResourcePlanRoleService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectMembersVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsResourcePlanDaysVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsResourcePlanRoleVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsResourcePlanVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.my.constant.TimesheetStatus;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ResourcePlanningCycleEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsResourcePlanRoleConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsResourcePlanDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsResourcePlanRoleDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsResourcePlanRoleDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsResourcePlanRoleRepo;
import java.math.BigDecimal;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class PmsResourcePlanRoleServiceImpl
extends BaseServiceImpl
implements PmsResourcePlanRoleService {
    private static final Logger log = LoggerFactory.getLogger(PmsResourcePlanRoleServiceImpl.class);
    private final PmsResourcePlanRoleRepo pmsResourcePlanRoleRepo;
    private final PmsResourcePlanRoleDAO pmsResourcePlanRoleDAO;
    private final PmsResourcePlanDAO pmsResourcePlanDAO;
    private final CacheUtil cacheUtil;
    private final PrdCompositeAbilityService prdCompositeAbilityService;
    private final PrdAbilityLevelService prdAbilityLevelService;
    private final PmsResourcePlanDaysService pmsResourcePlanDaysService;
    private final PmsProjectMembersService pmsProjectMembersService;
    private final PmsProjectDAO pmsProjectDAO;
    private final PmsTimesheetCommonService pmsTimesheetCommonService;
    private final PrdOrgEmployeeEqvaRatioService prdOrgEmployeeEqvaRatioService;

    public PagingVO<PmsResourcePlanRoleVO> queryPaging(PmsResourcePlanRoleQuery query) {
        if (ObjectUtils.isEmpty((Object)query.getPlanId())) {
            throw TwException.error("", "\u5173\u8054\u8d44\u6e90\u8ba1\u5212ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        PmsResourcePlanVO planVO = this.pmsResourcePlanDAO.queryByKey(query.getPlanId());
        if (ObjectUtils.isEmpty((Object)planVO)) {
            throw TwException.error("", "\u5173\u8054\u8d44\u6e90\u8ba1\u5212\u4e0d\u5b58\u5728!");
        }
        PagingVO<PmsResourcePlanRoleVO> page = this.pmsResourcePlanRoleDAO.queryPaging(query);
        if (!ObjectUtils.isEmpty((Object)page.getRecords())) {
            this.transSysSelectionAndName(planVO, page.getRecords());
        }
        return page;
    }

    public List<PmsResourcePlanRoleVO> queryList(PmsResourcePlanRoleQuery query) {
        if (ObjectUtils.isEmpty((Object)query.getPlanId())) {
            throw TwException.error("", "\u5173\u8054\u8d44\u6e90\u8ba1\u5212ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        PmsResourcePlanVO planVO = this.pmsResourcePlanDAO.queryByKey(query.getPlanId());
        if (ObjectUtils.isEmpty((Object)planVO)) {
            throw TwException.error("", "\u5173\u8054\u8d44\u6e90\u8ba1\u5212\u4e0d\u5b58\u5728!");
        }
        List<PmsResourcePlanRoleVO> list = this.pmsResourcePlanRoleDAO.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(list)) {
            this.transSysSelectionAndName(planVO, list);
        }
        return list;
    }

    public List<PmsResourcePlanRoleVO> queryListByPlanIdList(PmsResourcePlanRoleQuery query) {
        if (ObjectUtils.isEmpty((Object)query.getPlanIdList())) {
            throw TwException.error("", "\u5173\u8054\u8d44\u6e90\u8ba1\u5212ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        List<PmsResourcePlanRoleVO> list = this.pmsResourcePlanRoleDAO.queryListDynamic(query);
        return list;
    }

    public List<PmsResourcePlanRoleVO> querySimpleList(PmsResourcePlanRoleQuery query) {
        List<PmsResourcePlanRoleVO> list = this.pmsResourcePlanRoleDAO.queryListDynamic(query);
        if (list.size() > 0) {
            List<Long> planIds = list.stream().map(PmsResourcePlanRoleVO::getPlanId).distinct().collect(Collectors.toList());
            List<PmsResourcePlanVO> pmsResourcePlanVOS = this.pmsResourcePlanDAO.queryByKeys(planIds);
            List roleDetailIds = list.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            PmsResourcePlanDaysQuery daysQuery = new PmsResourcePlanDaysQuery();
            daysQuery.setRoleDetailIds(roleDetailIds);
            Collection pmsResourcePlanDaysList = null;
            if (!ObjectUtils.isEmpty(pmsResourcePlanDaysList)) {
                HashMap<Long, List<PmsResourcePlanDaysVO>> daysInfo = new HashMap<Long, List<PmsResourcePlanDaysVO>>(roleDetailIds.size());
                Map<Long, List<PmsResourcePlanDaysVO>> groupByRole = pmsResourcePlanDaysList.stream().collect(Collectors.groupingBy(b -> b.getRoleDetailId()));
                for (Long roleDetailId : roleDetailIds) {
                    List<PmsResourcePlanDaysVO> daysVOS = groupByRole.get(roleDetailId);
                    if (ObjectUtils.isEmpty(daysVOS)) continue;
                    Collections.sort(daysVOS, Comparator.comparing(PmsResourcePlanDaysVO::getStartDate));
                    daysInfo.put(roleDetailId, daysVOS);
                }
                list.forEach(v -> {
                    List daysVOS;
                    Optional<PmsResourcePlanVO> first = pmsResourcePlanVOS.stream().filter(planVO -> planVO.getId().equals(v.getPlanId())).findFirst();
                    if (first.isPresent()) {
                        PmsResourcePlanVO pmsResourcePlanVO = first.get();
                        v.setObjId(pmsResourcePlanVO.getObjId());
                        v.setObjName(pmsResourcePlanVO.getObjName());
                    }
                    if (!ObjectUtils.isEmpty((Object)(daysVOS = (List)daysInfo.get(v.getId())))) {
                        v.setDaysInfo(daysVOS);
                    } else {
                        v.setTotalDays(BigDecimal.ZERO);
                        v.setTotalEqva(BigDecimal.ZERO);
                    }
                });
            }
        }
        return list;
    }

    public PmsResourcePlanVO queryResourcePlanVOByObj(Long objId, String planType) {
        PmsResourcePlanVO planVO = this.pmsResourcePlanDAO.queryByObjId(objId, planType);
        List<PmsResourcePlanRoleVO> list = new ArrayList<PmsResourcePlanRoleVO>();
        if (!ObjectUtils.isEmpty((Object)planVO)) {
            PmsResourcePlanRoleQuery pmsResourcePlanRoleQuery = new PmsResourcePlanRoleQuery();
            pmsResourcePlanRoleQuery.setPlanId(planVO.getId());
            list = this.pmsResourcePlanRoleDAO.queryListDynamic(pmsResourcePlanRoleQuery);
        }
        if (!ObjectUtils.isEmpty(list)) {
            this.transSysSelectionAndName(planVO, list);
            planVO.setResourcePlanRoleVOS(list);
        }
        return planVO;
    }

    public List<PmsResourcePlanRoleVO> queryByObj(Long objId, String planType) {
        List<PmsResourcePlanRoleVO> list = new ArrayList<PmsResourcePlanRoleVO>();
        PmsResourcePlanVO planVO = this.pmsResourcePlanDAO.queryByObjId(objId, planType);
        if (!ObjectUtils.isEmpty((Object)planVO)) {
            PmsResourcePlanRoleQuery pmsResourcePlanRoleQuery = new PmsResourcePlanRoleQuery();
            pmsResourcePlanRoleQuery.setPlanId(planVO.getId());
            list = this.pmsResourcePlanRoleDAO.queryListDynamic(pmsResourcePlanRoleQuery);
        }
        if (!ObjectUtils.isEmpty(list)) {
            this.transSysSelectionAndName(planVO, list);
        }
        return list;
    }

    public PmsResourcePlanRoleVO queryByKey(Long key) {
        PmsResourcePlanRoleDO entity = this.pmsResourcePlanRoleRepo.findById(key).orElseGet(PmsResourcePlanRoleDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsResourcePlanRoleVO vo = PmsResourcePlanRoleConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsResourcePlanRoleVO insert(PmsResourcePlanRolePayload payload) {
        PmsResourcePlanRoleDO entityDo = PmsResourcePlanRoleConvert.INSTANCE.toDo(payload);
        return PmsResourcePlanRoleConvert.INSTANCE.toVo((PmsResourcePlanRoleDO)this.pmsResourcePlanRoleRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsResourcePlanRoleVO update(PmsResourcePlanRolePayload payload) {
        PmsResourcePlanRoleDO entity = this.pmsResourcePlanRoleRepo.findById(payload.getId()).orElseGet(PmsResourcePlanRoleDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsResourcePlanRoleDO entityDo = PmsResourcePlanRoleConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsResourcePlanRoleConvert.INSTANCE.toVo((PmsResourcePlanRoleDO)this.pmsResourcePlanRoleRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PmsResourcePlanRolePayload payload) {
        PmsResourcePlanRoleDO entity = this.pmsResourcePlanRoleRepo.findById(payload.getId()).orElseGet(PmsResourcePlanRoleDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.pmsResourcePlanRoleDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.pmsResourcePlanRoleRepo.findById(id);
                if (!optional.isEmpty()) {
                    PmsResourcePlanRoleDO entity = (PmsResourcePlanRoleDO)optional.get();
                    PmsResourcePlanVO pmsResourcePlanVO = this.pmsResourcePlanDAO.queryByKey(entity.getPlanId());
                    Assert.notNull((Object)pmsResourcePlanVO, (String)"\u8ba1\u5212\u4e0d\u5b58\u5728");
                    Long objId = pmsResourcePlanVO.getObjId();
                    String planType = pmsResourcePlanVO.getPlanType();
                    TimesheetQuery timesheetQuery = new TimesheetQuery();
                    timesheetQuery.setReasonId(objId);
                    timesheetQuery.setReasonType(planType);
                    timesheetQuery.setTsStatusList(Arrays.asList(TimesheetStatus.APPROVED.getCode(), TimesheetStatus.APPROVING.getCode(), TimesheetStatus.SETTLED.getCode()));
                    timesheetQuery.setTsUserId(entity.getResId());
                    long count = this.pmsTimesheetCommonService.count(timesheetQuery);
                    if (count > 0L) {
                        throw TwException.error("", "\u5b58\u5728\u6b64\u9879\u76ee\u7684\u5de5\u65f6\u6570\u636e\uff0c\u4e0d\u53ef\u5220\u9664");
                    }
                }
            });
            this.pmsResourcePlanRoleDAO.deleteSoft(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void hiddenRole(List<Long> keys, Integer hiddenFlag) {
        if (ObjectUtils.isEmpty((Object)hiddenFlag)) {
            throw TwException.error("", "\u9690\u85cf\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!keys.isEmpty()) {
            this.pmsResourcePlanRoleDAO.hiddenRole(keys, hiddenFlag);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void importPlanRole(PmsResourcePlanRoleQuery query) {
        PmsResourcePlanVO planVO = this.pmsResourcePlanDAO.queryByKey(query.getPlanId());
        if (ObjectUtils.isEmpty((Object)planVO)) {
            throw TwException.error("", "\u5173\u8054\u8d44\u6e90\u8ba1\u5212\u4e0d\u5b58\u5728!");
        }
        List<PmsResourcePlanRoleVO> list = this.pmsResourcePlanRoleDAO.queryListDynamic(query);
        List resIds = list.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getResId())).map(v -> v.getResId()).collect(Collectors.toList());
        if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(planVO.getPlanType())) {
            PmsProjectMembersQuery membersQuery = new PmsProjectMembersQuery();
            membersQuery.setProjId(planVO.getObjId());
            List membersVOS = this.pmsProjectMembersService.queryListDynamic(membersQuery);
            if (!ObjectUtils.isEmpty((Object)membersVOS)) {
                membersVOS = membersVOS.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getResId()) && !resIds.contains(v.getResId())).collect(Collectors.toList());
                ArrayList<PmsResourcePlanRoleDO> addList = new ArrayList<PmsResourcePlanRoleDO>();
                LocalDate now = LocalDate.now();
                for (PmsProjectMembersVO vo : membersVOS) {
                    PmsResourcePlanRoleDO roleVO = new PmsResourcePlanRoleDO();
                    roleVO.setHiddenFlag(0);
                    roleVO.setPlanId(query.getPlanId());
                    roleVO.setRole(vo.getRole());
                    roleVO.setResId(vo.getResId());
                    roleVO.setStartDate(vo.getPlanStartDate());
                    roleVO.setEndDate(vo.getPlanEndDate());
                    roleVO.setCapasetLevelId(vo.getCapasetLevelId());
                    roleVO.setTotalDays(BigDecimal.ZERO);
                    roleVO.setTotalEqva(BigDecimal.ZERO);
                    BigDecimal eqvaRatio = this.prdOrgEmployeeEqvaRatioService.getEqvaRatio(vo.getResId(), null);
                    roleVO.setDistributeRate(eqvaRatio);
                    if (!ObjectUtils.isEmpty((Object)vo.getEqvaRatio())) {
                        roleVO.setDistributeRate(vo.getEqvaRatio());
                    }
                    addList.add(roleVO);
                }
                if (!ObjectUtils.isEmpty(addList)) {
                    this.pmsResourcePlanRoleRepo.saveAll(addList);
                }
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void insertOrUpdate(PmsResourcePlanRolePayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getPlanId())) {
            throw TwException.error("", "\u5173\u8054\u8d44\u6e90\u8ba1\u5212ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        PmsResourcePlanVO planVO = this.pmsResourcePlanDAO.queryByKey(payload.getPlanId());
        if (ObjectUtils.isEmpty((Object)payload.getRole())) {
            throw TwException.error("", "\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ObjectUtils.isEmpty((Object)payload.getCapasetLevelId())) {
            throw TwException.error("", payload.getRole() + "\uff1a\u590d\u5408\u80fd\u529b\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ObjectUtils.isEmpty((Object)payload.getDistributeRate())) {
            throw TwException.error("", payload.getRole() + "\uff1a\u6d3e\u53d1\u7cfb\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (payload.getStartDate() != null && payload.getEndDate() != null && payload.getStartDate().isAfter(payload.getEndDate())) {
            throw TwException.error("", payload.getRole() + "\uff1a\u5165\u573a\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u79bb\u573a\u65e5\u671f!");
        }
        Object[] days = payload.getDays();
        if (ObjectUtils.isEmpty((Object[])days)) {
            throw TwException.error("", payload.getRole() + "\uff1a\u5929\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!ObjectUtils.isEmpty((Object)payload.getResId())) {
            PmsResourcePlanRoleQuery query = new PmsResourcePlanRoleQuery();
            query.setPlanId(payload.getPlanId());
            query.setResId(payload.getResId());
            List<PmsResourcePlanRoleVO> list = this.pmsResourcePlanRoleDAO.queryListDynamic(query);
            if (!ObjectUtils.isEmpty(list)) {
                if (ObjectUtils.isEmpty((Object)payload.getId())) {
                    throw TwException.error("", "\u4e00\u4e2a\u4eba\u5728\u8d44\u6e90\u89c4\u5212\u4e2d\u53ea\u80fd\u6709\u4e00\u884c");
                }
                if (!payload.getId().equals(list.get(0).getId())) {
                    throw TwException.error("", "\u4e00\u4e2a\u4eba\u5728\u8d44\u6e90\u89c4\u5212\u4e2d\u53ea\u80fd\u6709\u4e00\u884c");
                }
            }
        }
        if (ObjectUtils.isEmpty((Object)payload.getHiddenFlag())) {
            payload.setHiddenFlag(Integer.valueOf(0));
        }
        BigDecimal totalDays = BigDecimal.ZERO;
        ArrayList<PmsResourcePlanDaysPayload> daysPayloads = new ArrayList<PmsResourcePlanDaysPayload>();
        String resourcePlanningCycle = planVO.getResourcePlanningCycle();
        LocalDate start = planVO.getStartDate();
        LocalDate end = planVO.getEndDate();
        if (ResourcePlanningCycleEnum.WEEK.getCode().equals(resourcePlanningCycle)) {
            List<LocalDate> weeks = this.calculateWeeksBetweenLocalDates(start, end);
            if (days.length != weeks.size()) {
                throw TwException.error("", "\u8ba1\u7b97\u7684\u6301\u7eed\u5468\u6570\u4e0d\u5bf9");
            }
            num = weeks.size();
            for (i = 0; i < num; ++i) {
                int daysBetween;
                Object object = day = days[i] == null ? BigDecimal.ZERO : days[i];
                if (((BigDecimal)day).compareTo(BigDecimal.ZERO) < 0) {
                    throw TwException.error("", "\u89d2\u8272 " + payload.getRole() + ":\u7b2c" + (i + 1) + "\u5468\u7684\u5929\u6570\u8981\u5927\u4e8e\u7b49\u4e8e0\uff01");
                }
                if (((BigDecimal)day).compareTo(new BigDecimal(7)) > 0) {
                    throw TwException.error("", "\u89d2\u8272 " + payload.getRole() + ":\u7b2c" + (i + 1) + "\u5468\u7684\u5929\u6570\u8981\u5c0f\u4e8e\u7b49\u4e8e7\uff01");
                }
                time = weeks.get(i);
                if (i == 0) {
                    int daysBetween2 = this.daysBetween(start, start.with(DayOfWeek.SUNDAY));
                    if (((BigDecimal)day).compareTo(new BigDecimal(daysBetween2)) > 0) {
                        throw TwException.error("", "\u89d2\u8272 " + payload.getRole() + ":\u7b2c" + (i + 1) + "\u5468\u7684\u5929\u6570\u8981\u5c0f\u4e8e\u7b49\u4e8e" + daysBetween2 + "\uff01");
                    }
                } else if (i == num - 1 && ((BigDecimal)day).compareTo(new BigDecimal(daysBetween = this.daysBetween(time, end))) > 0) {
                    throw TwException.error("", "\u89d2\u8272 " + payload.getRole() + ":\u7b2c" + (i + 1) + "\u5468\u7684\u5929\u6570\u8981\u5c0f\u4e8e\u7b49\u4e8e" + daysBetween + "\uff01");
                }
                totalDays = totalDays.add((BigDecimal)day);
                daysDetail = new PmsResourcePlanDaysPayload();
                daysDetail.setDays((BigDecimal)day);
                daysDetail.setStartDate(time);
                daysPayloads.add(daysDetail);
            }
        } else {
            List<LocalDate> months = this.calculateMonthsBetweenLocalDates(start, end);
            if (days.length != months.size()) {
                throw TwException.error("", "\u8ba1\u7b97\u7684\u6301\u7eed\u6708\u6570\u4e0d\u5bf9");
            }
            num = months.size();
            for (i = 0; i < num; ++i) {
                long daysBetween;
                day = days[i];
                if (((BigDecimal)day).compareTo(BigDecimal.ZERO) < 0) {
                    throw TwException.error("", "\u89d2\u8272 " + payload.getRole() + ":\u7b2c" + (i + 1) + "\u6708\u7684\u5929\u6570\u8981\u5927\u4e8e\u7b49\u4e8e0\uff01");
                }
                time = months.get(i);
                if (i == 0 ? ((BigDecimal)day).compareTo(new BigDecimal(daysBetween = (long)this.daysBetween(start, time.plusMonths(1L).plusDays(-1L)))) > 0 : (i == num - 1 ? ((BigDecimal)day).compareTo(new BigDecimal(daysBetween = (long)this.daysBetween(time, end))) > 0 : ((BigDecimal)day).compareTo(new BigDecimal(daysBetween = (long)time.lengthOfMonth())) > 0)) {
                    throw TwException.error("", "\u89d2\u8272 " + payload.getRole() + ":\u7b2c" + (i + 1) + "\u6708\u7684\u5929\u6570\u8981\u5c0f\u4e8e\u7b49\u4e8e" + daysBetween + "\uff01");
                }
                totalDays = totalDays.add((BigDecimal)day);
                daysDetail = new PmsResourcePlanDaysPayload();
                daysDetail.setDays((BigDecimal)day);
                daysDetail.setStartDate(months.get(i));
                daysPayloads.add(daysDetail);
            }
        }
        payload.setTotalDays(totalDays);
        payload.setTotalEqva(payload.getDistributeRate().multiply(totalDays));
        Long roleDetailId = payload.getId();
        if (ObjectUtils.isEmpty((Object)roleDetailId)) {
            PmsResourcePlanRoleVO roleVO = this.insert(payload);
            roleDetailId = roleVO.getId();
        } else {
            this.pmsResourcePlanRoleDAO.updateByKeyDynamic(payload);
        }
        for (PmsResourcePlanDaysPayload daysDetail : daysPayloads) {
            daysDetail.setPlanId(payload.getPlanId());
            daysDetail.setRoleDetailId(roleDetailId);
        }
        if (!ObjectUtils.isEmpty(daysPayloads)) {
            // empty if block
        }
        PmsResourcePlanPayload planPayload = new PmsResourcePlanPayload();
        planPayload.setId(payload.getPlanId());
        this.pmsResourcePlanDAO.updateByKeyDynamic(planPayload);
        PmsProjectPayload payloadProject = new PmsProjectPayload();
        payloadProject.setId(planVO.getObjId());
        payloadProject.setPlanUpdateDate(LocalDateTime.now());
        this.pmsProjectDAO.updateByKeyDynamic(payloadProject);
    }

    private void transSysSelectionAndName(PmsResourcePlanVO planVO, List<PmsResourcePlanRoleVO> list) {
        List<PmsResourcePlanDaysVO> initDaysData = this.initDaysData(planVO.getStartDate(), planVO.getEndDate(), planVO.getResourcePlanningCycle());
        ArrayList roleDetailIds = new ArrayList();
        ArrayList capasetLevelIds = new ArrayList();
        list.forEach(v -> {
            roleDetailIds.add(v.getId());
            if (!ObjectUtils.isEmpty((Object)v.getCapasetLevelId())) {
                capasetLevelIds.add(v.getCapasetLevelId());
            }
            v.setDaysInfo(initDaysData);
            if (!ObjectUtils.isEmpty((Object)v.getResId())) {
                TimesheetQuery timesheetQuery = new TimesheetQuery();
                timesheetQuery.setReasonId(planVO.getObjId());
                timesheetQuery.setReasonType(planVO.getPlanType());
                timesheetQuery.setTsStatusList(Arrays.asList(TimesheetStatus.APPROVED.getCode(), TimesheetStatus.APPROVING.getCode(), TimesheetStatus.SETTLED.getCode()));
                timesheetQuery.setTsUserId(v.getResId());
                long count = this.pmsTimesheetCommonService.count(timesheetQuery);
                if (count > 0L) {
                    v.setTimeSheetFlag(Boolean.valueOf(true));
                }
            }
        });
        if (!ObjectUtils.isEmpty(capasetLevelIds)) {
            PrdAbilityLevelQuery abilityLevelQuery = new PrdAbilityLevelQuery();
            abilityLevelQuery.setIds(capasetLevelIds);
            List abilityLevelVOS = this.prdAbilityLevelService.getList(abilityLevelQuery);
            HashMap<Long, String> levelMap = new HashMap<Long, String>();
            HashMap<Long, Long> abilityMap = new HashMap<Long, Long>();
            for (PrdAbilityLevelVO levelVO : abilityLevelVOS) {
                levelMap.put(levelVO.getId(), levelVO.getLevelDtlName());
                abilityMap.put(levelVO.getId(), levelVO.getAbilityId());
            }
            List abilityIds = abilityLevelVOS.stream().map(e -> e.getAbilityId()).collect(Collectors.toList());
            PrdCompositeAbilityQuery prdCompositeAbilityQuery = new PrdCompositeAbilityQuery();
            prdCompositeAbilityQuery.setIds(abilityIds);
            List levelVOS = this.prdCompositeAbilityService.getList(prdCompositeAbilityQuery);
            HashMap<Long, String> compositeAbilityMap = new HashMap<Long, String>();
            for (PrdCompositeAbilityVO compositeAbilityVO : levelVOS) {
                compositeAbilityMap.put(compositeAbilityVO.getId(), compositeAbilityVO.getName());
            }
            list.forEach(v -> {
                Long capasetLevelId = v.getCapasetLevelId();
                if (!ObjectUtils.isEmpty((Object)capasetLevelId)) {
                    String levelDesc = (String)levelMap.get(capasetLevelId);
                    Long compositeAbilityId = (Long)abilityMap.get(capasetLevelId);
                    if (compositeAbilityId != null) {
                        String compositeAbilityName = (String)compositeAbilityMap.get(compositeAbilityId);
                        v.setCapasetLevelDesc(compositeAbilityName + "-" + levelDesc);
                    }
                }
            });
        }
        PmsResourcePlanDaysQuery daysQuery = new PmsResourcePlanDaysQuery();
        daysQuery.setPlanId(planVO.getId());
        daysQuery.setRoleDetailIds(roleDetailIds);
    }

    public List<LocalDate> calculateWeeksBetweenLocalDates(LocalDate start, LocalDate end) {
        ArrayList<LocalDate> mondays = new ArrayList<LocalDate>();
        mondays.add(PmsResourcePlanRoleServiceImpl.getMondayOfCurrentWeek(start));
        mondays.add(PmsResourcePlanRoleServiceImpl.getMondayOfCurrentWeek(end));
        LocalDate current = start;
        while (current.isBefore(end)) {
            if (current.getDayOfWeek() == DayOfWeek.MONDAY && !mondays.contains(current)) {
                mondays.add(current);
            }
            current = current.plusDays(1L);
        }
        Collections.sort(mondays);
        return mondays;
    }

    public static LocalDate getMondayOfCurrentWeek(LocalDate currentDate) {
        int dayOfWeek = currentDate.getDayOfWeek().getValue();
        return currentDate.minusDays(dayOfWeek - 1);
    }

    public List<LocalDate> calculateMonthsBetweenLocalDates(LocalDate start, LocalDate end) {
        ArrayList<LocalDate> months = new ArrayList<LocalDate>();
        months.add(start);
        months.add(end);
        LocalDate current = start;
        while (current.isBefore(end)) {
            months.add(current);
            current = current.plusMonths(1L);
        }
        ArrayList<LocalDate> result = new ArrayList<LocalDate>();
        for (LocalDate time : months) {
            LocalDate newTime = time.withDayOfMonth(1);
            if (result.contains(newTime)) continue;
            result.add(newTime);
        }
        Collections.sort(result);
        return result;
    }

    public List<PmsResourcePlanDaysVO> initDaysData(LocalDate start, LocalDate end, String resourcePlanningCycle) {
        ArrayList<PmsResourcePlanDaysVO> planDaysVOS = new ArrayList<PmsResourcePlanDaysVO>();
        if (ResourcePlanningCycleEnum.WEEK.getCode().equals(resourcePlanningCycle)) {
            List<LocalDate> weeks = this.calculateWeeksBetweenLocalDates(start, end);
            int num = weeks.size();
            for (int i = 0; i < num; ++i) {
                PmsResourcePlanDaysVO daysDetail = new PmsResourcePlanDaysVO();
                LocalDate time = weeks.get(i);
                daysDetail.setStartDate(time);
                daysDetail.setDays(BigDecimal.ZERO);
                planDaysVOS.add(daysDetail);
            }
        } else {
            List<LocalDate> months = this.calculateMonthsBetweenLocalDates(start, end);
            int num = months.size();
            for (int i = 0; i < num; ++i) {
                PmsResourcePlanDaysVO daysDetail = new PmsResourcePlanDaysVO();
                LocalDate time = months.get(i);
                daysDetail.setStartDate(time);
                daysDetail.setDays(BigDecimal.ZERO);
                planDaysVOS.add(daysDetail);
            }
        }
        return planDaysVOS;
    }

    public int daysBetween(LocalDate start, LocalDate end) {
        ArrayList<LocalDate> dateRange = new ArrayList<LocalDate>();
        dateRange.add(start);
        dateRange.add(end);
        LocalDate currentDate = start;
        while (!currentDate.isAfter(end)) {
            dateRange.add(currentDate);
            currentDate = currentDate.plusDays(1L);
        }
        Set uniqueDateSet = dateRange.stream().collect(Collectors.toSet());
        return uniqueDateSet.size();
    }

    public PmsResourcePlanRoleVO getByObjectIdAndUserId(Long objId, Long userId, String objType) {
        Assert.notNull((Object)objId, (String)"\u5173\u8054\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)userId, (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)objType, (String)"\u5173\u8054\u5bf9\u8c61\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        PmsResourcePlanVO planVO = this.pmsResourcePlanDAO.queryByObjId(objId, objType);
        if (null == planVO) {
            throw TwException.error("", "\u8d44\u6e90\u8ba1\u5212\u4e0d\u5b58\u5728");
        }
        PmsResourcePlanRoleQuery pmsResourcePlanRoleQuery = new PmsResourcePlanRoleQuery();
        pmsResourcePlanRoleQuery.setPlanId(planVO.getId());
        pmsResourcePlanRoleQuery.setResId(userId);
        List<PmsResourcePlanRoleVO> pmsResourcePlanRoleVOS = this.pmsResourcePlanRoleDAO.queryListDynamic(pmsResourcePlanRoleQuery);
        if (!CollectionUtils.isEmpty(pmsResourcePlanRoleVOS)) {
            if (pmsResourcePlanRoleVOS.size() > 1) {
                log.error("\u8d44\u6e90\u89c4\u5212\u6570\u636e\u5f02\u5e38\uff0c\u5339\u914d\u5230\u591a\u6761\u8ba1\u5212; objId:{};userId:{};objType:{}", new Object[]{objId, userId, objType});
                log.error("\u8d44\u6e90\u89c4\u5212\u6570\u636e\u5f02\u5e38\uff0c\u5339\u914d\u5230\u591a\u6761\u8ba1\u5212", pmsResourcePlanRoleVOS);
                throw TwException.error("", "\u8d44\u6e90\u89c4\u5212\u6570\u636e\u5f02\u5e38\uff0c\u5339\u914d\u5230\u591a\u6761\u8ba1\u5212");
            }
            PmsResourcePlanRoleVO pmsResourcePlanRoleVO = pmsResourcePlanRoleVOS.get(0);
            return pmsResourcePlanRoleVO;
        }
        return null;
    }

    public BigDecimal getByObjectId(Long objId, String objType) {
        Assert.notNull((Object)objId, (String)"\u5173\u8054\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)objType, (String)"\u5173\u8054\u5bf9\u8c61\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        PmsResourcePlanVO planVO = this.pmsResourcePlanDAO.queryByObjId(objId, objType);
        if (null == planVO) {
            throw TwException.error("", "\u8d44\u6e90\u8ba1\u5212\u4e0d\u5b58\u5728");
        }
        PmsResourcePlanRoleQuery pmsResourcePlanRoleQuery = new PmsResourcePlanRoleQuery();
        pmsResourcePlanRoleQuery.setPlanId(planVO.getId());
        List<PmsResourcePlanRoleVO> pmsResourcePlanRoleVOS = this.pmsResourcePlanRoleDAO.queryListDynamic(pmsResourcePlanRoleQuery);
        if (!CollectionUtils.isEmpty(pmsResourcePlanRoleVOS)) {
            BigDecimal totalDays = pmsResourcePlanRoleVOS.stream().map(PmsResourcePlanRoleVO::getTotalDays).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            return totalDays;
        }
        return BigDecimal.ZERO;
    }

    public PmsResourcePlanRoleServiceImpl(PmsResourcePlanRoleRepo pmsResourcePlanRoleRepo, PmsResourcePlanRoleDAO pmsResourcePlanRoleDAO, PmsResourcePlanDAO pmsResourcePlanDAO, CacheUtil cacheUtil, PrdCompositeAbilityService prdCompositeAbilityService, PrdAbilityLevelService prdAbilityLevelService, PmsResourcePlanDaysService pmsResourcePlanDaysService, PmsProjectMembersService pmsProjectMembersService, PmsProjectDAO pmsProjectDAO, PmsTimesheetCommonService pmsTimesheetCommonService, PrdOrgEmployeeEqvaRatioService prdOrgEmployeeEqvaRatioService) {
        this.pmsResourcePlanRoleRepo = pmsResourcePlanRoleRepo;
        this.pmsResourcePlanRoleDAO = pmsResourcePlanRoleDAO;
        this.pmsResourcePlanDAO = pmsResourcePlanDAO;
        this.cacheUtil = cacheUtil;
        this.prdCompositeAbilityService = prdCompositeAbilityService;
        this.prdAbilityLevelService = prdAbilityLevelService;
        this.pmsResourcePlanDaysService = pmsResourcePlanDaysService;
        this.pmsProjectMembersService = pmsProjectMembersService;
        this.pmsProjectDAO = pmsProjectDAO;
        this.pmsTimesheetCommonService = pmsTimesheetCommonService;
        this.prdOrgEmployeeEqvaRatioService = prdOrgEmployeeEqvaRatioService;
    }
}

