/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.salecon.service;

import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConPurchaseDemandDPayload;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConPurchaseDemandPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConPurchaseDemandQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConPurchaseDemandDService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConPurchaseDemandService;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConPurchaseDemandDVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConPurchaseDemandVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.elitesland.tw.tw5.server.prd.product.repo.PrdProductClassRepo;
import com.elitesland.tw.tw5.server.prd.product.repo.PrdProductRepo;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchaseContractManagerRepo;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConPurchaseDemandConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConPurchaseDemandDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.SaleConContractDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConPurchaseDemandDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConPurchaseDemandDRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConPurchaseDemandRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.SaleConContractRepo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class ConPurchaseDemandServiceImpl
extends BaseServiceImpl
implements ConPurchaseDemandService {
    private static final Logger log = LoggerFactory.getLogger(ConPurchaseDemandServiceImpl.class);
    private final ConPurchaseDemandRepo conPurchaseDemandRepo;
    private final ConPurchaseDemandDAO conPurchaseDemandDAO;
    private final ConPurchaseDemandDService purDemandDService;
    private final HttpUtil httpUtil;
    private final PrdOrgSyncLogDAO daoLog;
    private final ConPurchaseDemandDRepo conPurchaseDemandDRepo;
    private final PrdProductRepo prdProductRepo;
    private final PrdProductClassRepo prdProductClassRepo;
    private final SaleConContractDAO saleConContractDAO;
    private final SaleConContractRepo saleConContractRepo;
    private final PrdOrgEmployeeService employeeService;
    private final PurchaseContractManagerRepo purchaseContractManagerRepo;
    @Value(value="${tw4.sale.contractProcurDemand}")
    private String contractProcurDemand;

    public PagingVO<ConPurchaseDemandVO> paging(ConPurchaseDemandQuery query) {
        Page page = this.conPurchaseDemandRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(ConPurchaseDemandConvert.INSTANCE::toVo));
    }

    public PagingVO<ConPurchaseDemandVO> queryPaging(ConPurchaseDemandQuery query) {
        return this.conPurchaseDemandDAO.queryPaging(query);
    }

    public List<ConPurchaseDemandVO> queryList(ConPurchaseDemandQuery query) {
        return ConPurchaseDemandConvert.INSTANCE.toVoList(this.conPurchaseDemandRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest().getSort()));
    }

    public List<ConPurchaseDemandVO> queryListDynamic(ConPurchaseDemandQuery query) {
        return this.conPurchaseDemandDAO.queryListDynamic(query);
    }

    public ConPurchaseDemandVO queryByKey(Long key) {
        ConPurchaseDemandDO entity = this.conPurchaseDemandRepo.findById(key).orElseGet(ConPurchaseDemandDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ConPurchaseDemandVO vo = ConPurchaseDemandConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public ConPurchaseDemandVO insert(ConPurchaseDemandPayload payload) {
        ConPurchaseDemandDO entityDo = ConPurchaseDemandConvert.INSTANCE.toDo(payload);
        ConPurchaseDemandDO save = (ConPurchaseDemandDO)this.conPurchaseDemandRepo.save(entityDo);
        BigDecimal demandTotalAmt = BigDecimal.ZERO;
        payload.setId(save.getId());
        List<ConPurchaseDemandDVO> conPurchaseDemandDVOS = this.insertOrUpdateDemandD(payload);
        for (ConPurchaseDemandDVO conPurchaseDemandDVO : conPurchaseDemandDVOS) {
            if (conPurchaseDemandDVO.getNotTaxAmt() == null) continue;
            demandTotalAmt = demandTotalAmt.add(conPurchaseDemandDVO.getNotTaxAmt());
        }
        if (demandTotalAmt.compareTo(BigDecimal.ZERO) != 0) {
            SaleConContractService saleConContractService = (SaleConContractService)SpringUtil.getBean(SaleConContractService.class);
            SaleConContractVO saleConContractVO = saleConContractService.queryByKey(payload.getSaleConId(), new Boolean[0]);
            BigDecimal newEffectiveAmt = saleConContractVO.getNotTaxAmt().subtract(demandTotalAmt).subtract(saleConContractVO.getExtraAmt());
            BigDecimal sysGross = this.calcSysGross(saleConContractVO, demandTotalAmt);
            this.conPurchaseDemandDAO.updateSubConEffectiveAmt(newEffectiveAmt, payload.getSaleConId(), sysGross);
        }
        return ConPurchaseDemandConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public ConPurchaseDemandVO update(ConPurchaseDemandPayload payload) {
        ConPurchaseDemandDO entity = this.conPurchaseDemandRepo.findById(payload.getId()).orElseGet(ConPurchaseDemandDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BigDecimal demandTotalAmt = BigDecimal.ZERO;
        List<ConPurchaseDemandDVO> conPurchaseDemandDVOS = this.insertOrUpdateDemandD(payload);
        for (ConPurchaseDemandDVO conPurchaseDemandDVO : conPurchaseDemandDVOS) {
            if (conPurchaseDemandDVO.getNotTaxAmt() == null) continue;
            demandTotalAmt = demandTotalAmt.add(conPurchaseDemandDVO.getNotTaxAmt());
        }
        ConPurchaseDemandDO entityDo = ConPurchaseDemandConvert.INSTANCE.toDo(payload);
        SaleConContractService saleConContractService = (SaleConContractService)SpringUtil.getBean(SaleConContractService.class);
        SaleConContractVO saleConContractVO = saleConContractService.queryByKey(payload.getSaleConId(), new Boolean[0]);
        BigDecimal effectiveAmt = saleConContractVO.getEffectiveAmt();
        BigDecimal newEffectiveAmt = saleConContractVO.getNotTaxAmt().subtract(demandTotalAmt).subtract(saleConContractVO.getExtraAmt());
        BigDecimal sysGross = this.calcSysGross(saleConContractVO, demandTotalAmt);
        this.conPurchaseDemandDAO.updateSubConEffectiveAmt(newEffectiveAmt, payload.getSaleConId(), sysGross);
        entityDo.setDemandTotalAmt(demandTotalAmt);
        entity.copy(entityDo);
        return ConPurchaseDemandConvert.INSTANCE.toVo((ConPurchaseDemandDO)this.conPurchaseDemandRepo.save(entity));
    }

    private BigDecimal calcSysGross(SaleConContractVO saleConContractVO, BigDecimal demandTotalAmt) {
        BigDecimal sysGross = null;
        BigDecimal ratedEqva = ObjectUtils.isEmpty((Object)saleConContractVO.getRatedEqva()) ? BigDecimal.ZERO : saleConContractVO.getRatedEqva();
        BigDecimal ratedEqvaAmt = new BigDecimal(800).multiply(ratedEqva);
        BigDecimal ratedExpense = ObjectUtils.isEmpty((Object)saleConContractVO.getRatedExpense()) ? BigDecimal.ZERO : saleConContractVO.getRatedExpense();
        BigDecimal notTaxAmt = saleConContractVO.getNotTaxAmt();
        notTaxAmt = notTaxAmt.subtract(demandTotalAmt).subtract(ratedEqvaAmt).subtract(ratedExpense);
        sysGross = notTaxAmt.divide(saleConContractVO.getNotTaxAmt(), 4, RoundingMode.HALF_UP);
        return sysGross;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.conPurchaseDemandDAO.deleteSoft(keys);
        }
    }

    public ConPurchaseDemandVO queryBySaleConId(Long saleConId) {
        ConPurchaseDemandVO vo = this.conPurchaseDemandDAO.queryBySaleConId(saleConId);
        if (vo == null) {
            return null;
        }
        List dvoList = this.purDemandDService.queryByPurDemandId(vo.getId());
        vo.setConPurchaseDemandDVOS(dvoList);
        return vo;
    }

    private PrdOrgSyncLogDO saveSyncLog(String syncType, String syncData, LocalDateTime currentTime) {
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        this.daoLog.save(logDO);
        return logDO;
    }

    private List<ConPurchaseDemandDVO> insertOrUpdateDemandD(ConPurchaseDemandPayload payload) {
        List purDemandDPayloadList = payload.getPurDemandDPayloadList();
        ArrayList<ConPurchaseDemandDVO> conPurchaseDemandDVOS = new ArrayList<ConPurchaseDemandDVO>();
        Optional.ofNullable(purDemandDPayloadList).ifPresent(list -> {
            for (ConPurchaseDemandDPayload demandDPayload : list) {
                demandDPayload.setPurDemandId(payload.getId());
                if (ObjectUtils.isEmpty((Object)demandDPayload.getId()) || demandDPayload.getId() < 0L) {
                    ConPurchaseDemandDVO insert = this.purDemandDService.insert(demandDPayload);
                    conPurchaseDemandDVOS.add(insert);
                    continue;
                }
                ConPurchaseDemandDVO update = this.purDemandDService.update(demandDPayload);
                conPurchaseDemandDVOS.add(update);
            }
        });
        return conPurchaseDemandDVOS;
    }

    public ConPurchaseDemandServiceImpl(ConPurchaseDemandRepo conPurchaseDemandRepo, ConPurchaseDemandDAO conPurchaseDemandDAO, ConPurchaseDemandDService purDemandDService, HttpUtil httpUtil, PrdOrgSyncLogDAO daoLog, ConPurchaseDemandDRepo conPurchaseDemandDRepo, PrdProductRepo prdProductRepo, PrdProductClassRepo prdProductClassRepo, SaleConContractDAO saleConContractDAO, SaleConContractRepo saleConContractRepo, PrdOrgEmployeeService employeeService, PurchaseContractManagerRepo purchaseContractManagerRepo) {
        this.conPurchaseDemandRepo = conPurchaseDemandRepo;
        this.conPurchaseDemandDAO = conPurchaseDemandDAO;
        this.purDemandDService = purDemandDService;
        this.httpUtil = httpUtil;
        this.daoLog = daoLog;
        this.conPurchaseDemandDRepo = conPurchaseDemandDRepo;
        this.prdProductRepo = prdProductRepo;
        this.prdProductClassRepo = prdProductClassRepo;
        this.saleConContractDAO = saleConContractDAO;
        this.saleConContractRepo = saleConContractRepo;
        this.employeeService = employeeService;
        this.purchaseContractManagerRepo = purchaseContractManagerRepo;
    }
}

