/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.salecon.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivableDPayload;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivablePayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivablePlanQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivableQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivableDService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivableService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivableVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConReceivableConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConInvBatchDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConReceivableDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConReceivablePlanDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConReceivableDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConReceivablePlanRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConReceivableRepo;
import com.xxl.job.core.log.XxlJobLogger;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class ConReceivableServiceImpl
implements ConReceivableService {
    private static final Logger log = LoggerFactory.getLogger(ConReceivableServiceImpl.class);
    private final PrdMessageConfigService messageConfigService;
    private final ConReceivableRepo conReceivableRepo;
    private final ConReceivableDAO conReceivableDAO;
    private final ConReceivablePlanDAO conReceivablePlanDAO;
    private final ConReceivableDService conReceivableDService;
    private final ConReceivablePlanRepo planRepo;
    private final ConReceivablePlanDAO planDAO;
    private final ConInvBatchDAO invBatchDAO;
    private final PrdOrgEmployeeService employeeService;
    private final PrdOrgOrganizationService prdOrgOrganizationService;
    private final PrdOrgSyncLogDAO daoLog;
    private final HttpUtil httpUtil;
    @Value(value="${tw4.sale.conReceivable}")
    private String conReceivable;

    public PagingVO<ConReceivableVO> queryPaging(ConReceivableQuery query) {
        return this.conReceivableDAO.queryPaging(query);
    }

    public List<ConReceivableVO> queryListDynamic(ConReceivableQuery query) {
        return this.conReceivableDAO.queryListDynamic(query);
    }

    public ConReceivableVO queryByKey(Long key) {
        ConReceivableVO vo = this.conReceivableDAO.queryByKey(key);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public int insert(ConReceivablePayload payload) {
        ConReceivableDO conReceivableDO = this.insertContractRecv(payload);
        log.debug("\u5f00\u59cb\u751f\u6210\u90ae\u4ef6\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a");
        Long invBatchId = payload.getSourceId();
        ConReceivablePlanVO conReceivablePlanVO = this.conReceivablePlanDAO.queryByInvBatchId(invBatchId);
        PrdMessageConfigVO configVO = this.messageConfigService.queryByMessageCode("MC20231127001501");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("custName", conReceivablePlanVO.getCustName());
        result.put("contractName", conReceivablePlanVO.getSaleConName());
        result.put("phaseDesc", conReceivablePlanVO.getReceStage());
        result.put("recvDate", conReceivableDO.getRecvDate().toString());
        result.put("recvAmt", conReceivableDO.getRecvAmt() == null ? BigDecimal.valueOf(0L).setScale(2) : conReceivableDO.getRecvAmt().setScale(2, RoundingMode.HALF_UP));
        ArrayList<CallSite> noticeSourceList = new ArrayList<CallSite>();
        if (conReceivablePlanVO.getSaleManUserId() != null) {
            noticeSourceList.add((CallSite)((Object)("" + conReceivablePlanVO.getSaleManUserId())));
        } else {
            log.error("", (Object)"\u9500\u552e\u8d1f\u8d23\u4eba\u7f3a\u5931\uff0c\u65e0\u6cd5\u5c06\u6536\u6b3e\u5f55\u5165\u90ae\u4ef6\u53d1\u9001\u7ed9\u9500\u552e\u8d1f\u8d23\u4eba\uff01");
        }
        if (conReceivablePlanVO.getDeliUserId() != null) {
            noticeSourceList.add((CallSite)((Object)("" + conReceivablePlanVO.getDeliUserId())));
        } else {
            log.error("", (Object)"\u4ea4\u4ed8\u8d1f\u8d23\u4eba\u7f3a\u5931\uff0c\u65e0\u6cd5\u5c06\u6536\u6b3e\u5f55\u5165\u90ae\u4ef6\u53d1\u9001\u7ed9\u4ea4\u4ed8\u8d1f\u8d23\u4eba\uff01");
        }
        if (conReceivablePlanVO.getCreateUserId() != null) {
            noticeSourceList.add((CallSite)((Object)("" + conReceivablePlanVO.getCreateUserId())));
        } else {
            log.error("", (Object)"\u5f00\u7968\u53d1\u8d77\u4eba\u7f3a\u5931\uff0c\u65e0\u6cd5\u5c06\u6536\u6b3e\u5f55\u5165\u90ae\u4ef6\u53d1\u9001\u7ed9\u5f00\u7968\u53d1\u8d77\u4eba\uff01");
        }
        if (conReceivablePlanVO.getPmUserId() != null) {
            noticeSourceList.add((CallSite)((Object)("" + conReceivablePlanVO.getPmUserId())));
        } else {
            log.error("", (Object)"\u9879\u76ee\u7ecf\u7406\u7f3a\u5931\uff0c\u65e0\u6cd5\u5c06\u6536\u6b3e\u5f55\u5165\u90ae\u4ef6\u53d1\u9001\u7ed9\u9879\u76ee\u7ecf\u7406\uff01");
        }
        if (conReceivablePlanVO.getDeliBuId() != null) {
            PrdOrgOrganizationVO prdOrgOrganizationVO = this.prdOrgOrganizationService.queryDetailSimpleByOrgId(conReceivablePlanVO.getDeliBuId());
            Long manageId = prdOrgOrganizationVO.getManageId();
            noticeSourceList.add((CallSite)((Object)("" + manageId)));
        } else {
            log.error("", (Object)"\u4ea4\u4ed8BU\u8d1f\u8d23\u4eba\u7f3a\u5931\uff0c\u65e0\u6cd5\u5c06\u6536\u6b3e\u5f55\u5165\u90ae\u4ef6\u53d1\u9001\u7ed9\u4ea4\u8d1f\u8d23\u4eba\uff01");
        }
        Long signBuId = conReceivablePlanVO.getSignBuId();
        if (signBuId != null) {
            PrdOrgOrganizationVO prdOrgOrganizationVO = this.prdOrgOrganizationService.queryDetailSimpleByOrgId(signBuId);
            Long manageId = prdOrgOrganizationVO.getManageId();
            noticeSourceList.add((CallSite)((Object)("" + manageId)));
        } else {
            log.error("", (Object)"\u7b7e\u5355BU\u8d1f\u8d23\u4eba\u7f3a\u5931\uff0c\u65e0\u6cd5\u5c06\u6536\u6b3e\u5f55\u5165\u90ae\u4ef6\u53d1\u9001\u7ed9\u7b7e\u5355BU\u8d1f\u8d23\u4eba\uff01");
        }
        log.debug("\u7b7e\u5355bu\u8d1f\u8d23\u4eba\u5217\u8868\uff1a\uff1a\uff1a\uff1a\uff1a" + noticeSourceList);
        if (!ObjectUtils.isEmpty(noticeSourceList)) {
            String noticeSource = String.join((CharSequence)",", noticeSourceList);
            log.debug("\u53d1\u9001\u90ae\u4ef6\uff1a\uff1a\uff1a\uff1a\uff1a" + noticeSource);
            this.messageConfigService.sendMessageConfig(configVO, result, "appoint_people", noticeSource);
            log.debug("\u53d1\u9001\u90ae\u4ef6\u5b8c\u6210\uff1a\uff1a\uff1a\uff1a\uff1a" + noticeSource);
        }
        return 1;
    }

    public ConReceivableDO insertContractRecv(ConReceivablePayload payload) {
        this.validateRecvAmt(payload);
        ConReceivableDO entityDo = ConReceivableConvert.INSTANCE.toDo(payload);
        ConReceivableDO save = (ConReceivableDO)this.conReceivableRepo.save(entityDo);
        for (ConReceivableDPayload recvd : payload.getDetailList()) {
            recvd.setRecvId(save.getId());
            this.conReceivableDService.insert(recvd);
            this.planRepo.increamentActualRecvAmt(recvd.getRecvplanId(), recvd.getRecvAmt(), payload.getRecvDate());
            this.planRepo.setRecvStatus(recvd.getRecvplanId(), "3");
            this.setInvBatchStatus(recvd.getRecvplanId());
        }
        return save;
    }

    public void validateRecvAmt(ConReceivablePayload entity) {
        BigDecimal recvdAmtSum = new BigDecimal("0.00");
        List recvds = entity.getDetailList();
        for (ConReceivableDPayload recvd : recvds) {
            recvdAmtSum = recvdAmtSum.add(recvd.getRecvAmt());
        }
        if (recvdAmtSum.compareTo(entity.getRecvAmt()) != 0) {
            throw TwException.error("", "\u6536\u6b3e\u660e\u7ec6\u8868\u91d1\u989d:" + recvdAmtSum + "\u4e0e\u6536\u6b3e\u4e3b\u8868\u91d1\u989d:" + entity.getRecvAmt() + "\u4e0d\u76f8\u7b49\u3002");
        }
    }

    private void setInvBatchStatus(long recvPlanId) {
        ConReceivablePlanVO planVO = this.planDAO.queryByKey(recvPlanId);
        Long invBatchId = planVO.getInvBatchId();
        if (invBatchId != null) {
            ConReceivablePlanQuery planQuery = new ConReceivablePlanQuery();
            planQuery.setInvBatchId(invBatchId);
            List<ConReceivablePlanVO> plans = this.planDAO.queryListDynamic(planQuery);
            boolean isComplete = true;
            if (plans != null) {
                for (ConReceivablePlanVO plan : plans) {
                    if (plan.getReceStatus().equals("3")) continue;
                    this.invBatchDAO.updateBatchStatusById(invBatchId, "6");
                    isComplete = false;
                    break;
                }
                if (isComplete) {
                    this.invBatchDAO.updateBatchStatusById(invBatchId, "7");
                }
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public ConReceivableVO update(ConReceivablePayload payload) {
        ConReceivableDO entity = this.conReceivableRepo.findById(payload.getId()).orElseGet(ConReceivableDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ConReceivableDO entityDo = ConReceivableConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ConReceivableConvert.INSTANCE.toVo((ConReceivableDO)this.conReceivableRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(ConReceivablePayload payload) {
        ConReceivableDO entity = this.conReceivableRepo.findById(payload.getId()).orElseGet(ConReceivableDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.conReceivableDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.conReceivableDAO.deleteSoft(keys);
        }
    }

    @Transactional
    public Integer updateRecvAccount(Long invId, String accountNo, String ledgerDate) {
        this.conReceivableDAO.updateRecvAccount(invId, accountNo, ledgerDate);
        return 1;
    }

    public void syncConReceivableTo4(String param) {
        LocalDateTime syncTime;
        String syncType = "con_receivable_to4";
        syncTime = StringUtils.hasText((String)param) ? LocalDateTime.parse(param) : ((syncTime = this.daoLog.queryOrgSyncLog(syncType)) == null ? LocalDateTime.of(2023, 11, 1, 0, 0) : syncTime.minusSeconds(30L));
        XxlJobLogger.log((String)"\u5408\u540c\u6536\u6b3e\u540c\u6b65\u52304.0\u5f00\u59cb...", (Object[])new Object[0]);
        XxlJobLogger.log((String)("syncContractInvBatchTo4 localDateTime\uff1a" + syncTime), (Object[])new Object[0]);
        String format = DateUtil.format((LocalDateTime)syncTime, (String)"yyyy-MM-dd HH:mm:ss");
        List<ConReceivableDO> conReceivableDOS = this.conReceivableRepo.findByModifyTimeStart(format);
        Object syncData = "";
        LocalDateTime syncNow = LocalDateTime.now();
        if (!ObjectUtils.isEmpty(conReceivableDOS)) {
            Map<Long, Long> v4AndV5UserIds = this.employeeService.getV4AndV5UserIds().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            int failNum = 0;
            for (ConReceivableDO temDo : conReceivableDOS) {
                LocalDateTime syncStartTime = LocalDateTime.now();
                try {
                    Map<String, Object> map = BeanUtil.beanToMap(temDo);
                    map.put("delFlag", temDo.getDeleteFlag());
                    map.put("createUserId", v4AndV5UserIds.get(temDo.getCreateUserId()));
                    map.put("modifyUserId", v4AndV5UserIds.get(temDo.getModifyUserId()));
                    HashMap data = new HashMap();
                    if (("" + data.get("ok")).equals("true")) {
                        Long idV4 = Long.parseLong(data.get("datum").toString());
                        this.conReceivableRepo.updateConReceivableIdV4(idV4, temDo.getId());
                        continue;
                    }
                    LocalDateTime syncEndTime = LocalDateTime.now();
                    this.saveSyncLog(syncType + "_exception", "\u5408\u540c\u6536\u6b3eid" + temDo.getId() + "\u540c\u6b65\u5f02\u5e38\uff0c" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "\u8be6\u60c5\uff1a" + data.get("datum"), null);
                    this.conReceivableRepo.updateRemark(temDo.getId());
                    ++failNum;
                }
                catch (Exception e) {
                    XxlJobLogger.log((String)("\u5408\u540c\u6536\u6b3e" + temDo.getRecvNo() + "\u540c\u6b65\u5f02\u5e38......" + e), (Object[])new Object[0]);
                    LocalDateTime syncEndTime = LocalDateTime.now();
                    this.saveSyncLog(syncType + "_exception", "\u5408\u540c\u6536\u6b3eid" + temDo.getId() + "\u540c\u6b65\u5f02\u5e38\uff0c" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "\u8be6\u60c5\uff1a" + e, null);
                    ++failNum;
                    this.conReceivableRepo.updateRemark(temDo.getId());
                }
            }
            syncData = "\u66f4\u65b0\u4e86" + (conReceivableDOS.size() - failNum) + "\u6570\u636e,\u6709" + failNum + "\u6761\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff01";
        } else {
            syncData = "\u5408\u540c\u6536\u6b3e\u6570\u636e\u672a\u53d8\u5316";
        }
        PrdOrgSyncLogDO logDO = this.saveSyncLog(syncType, (String)syncData, syncNow);
        XxlJobLogger.log((String)("\u540c\u6b65\u5408\u540c\u6536\u6b3e\u53d1\u7968\u7ed3\u675f..." + logDO), (Object[])new Object[0]);
    }

    private PrdOrgSyncLogDO saveSyncLog(String syncType, String syncData, LocalDateTime currentTime) {
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        this.daoLog.save(logDO);
        return logDO;
    }

    public ConReceivableServiceImpl(PrdMessageConfigService messageConfigService, ConReceivableRepo conReceivableRepo, ConReceivableDAO conReceivableDAO, ConReceivablePlanDAO conReceivablePlanDAO, ConReceivableDService conReceivableDService, ConReceivablePlanRepo planRepo, ConReceivablePlanDAO planDAO, ConInvBatchDAO invBatchDAO, PrdOrgEmployeeService employeeService, PrdOrgOrganizationService prdOrgOrganizationService, PrdOrgSyncLogDAO daoLog, HttpUtil httpUtil) {
        this.messageConfigService = messageConfigService;
        this.conReceivableRepo = conReceivableRepo;
        this.conReceivableDAO = conReceivableDAO;
        this.conReceivablePlanDAO = conReceivablePlanDAO;
        this.conReceivableDService = conReceivableDService;
        this.planRepo = planRepo;
        this.planDAO = planDAO;
        this.invBatchDAO = invBatchDAO;
        this.employeeService = employeeService;
        this.prdOrgOrganizationService = prdOrgOrganizationService;
        this.daoLog = daoLog;
        this.httpUtil = httpUtil;
    }
}

