/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemFunctionDataPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFunctionDataQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemFunctionDataService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFunctionDataVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemFunctionDataConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemFunctionDataDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemFunctionDataDO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrdSystemFunctionDataServiceImpl
implements PrdSystemFunctionDataService {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemFunctionDataServiceImpl.class);
    private final PrdSystemFunctionDataDAO dao;
    private final CacheUtil cacheUtil;

    @Transactional
    public PrdSystemFunctionDataVO insert(PrdSystemFunctionDataPayload payload) {
        PrdSystemFunctionDataDO ado = PrdSystemFunctionDataConvert.INSTANCE.toDo(payload);
        this.dao.save(ado);
        this.cacheUtil.loadSystemFunctionDataCache();
        return PrdSystemFunctionDataConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    public Long update(PrdSystemFunctionDataPayload payload) {
        this.dao.updateByKeyDynamic(payload);
        this.cacheUtil.loadSystemFunctionDataCache();
        return 0L;
    }

    @Transactional
    public boolean delete(List<Long> keys) {
        boolean isDelete = true;
        long delNum = this.dao.delete(keys);
        if (delNum <= 0L) {
            isDelete = false;
        }
        this.cacheUtil.loadSystemFunctionDataCache();
        return isDelete;
    }

    public PrdSystemFunctionDataVO queryByKey(Long key) {
        return this.dao.queryByKey(key);
    }

    public PagingVO<PrdSystemFunctionDataVO> paging(PrdSystemFunctionDataQuery query) {
        return this.dao.queryPaging(query);
    }

    public PrdSystemFunctionDataServiceImpl(PrdSystemFunctionDataDAO dao, CacheUtil cacheUtil) {
        this.dao = dao;
        this.cacheUtil = cacheUtil;
    }
}

