/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.yeedocref;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessTableFieldsVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.funConfig.dao.BusinessTableFieldsDAO;
import com.elitesland.tw.tw5.server.yeedoc.service.YeedocService;
import com.elitesland.tw.tw5.server.yeedocref.CommonFormulaFunction;
import com.elitesland.tw.tw5.server.yeedocref.YeedocFileVO;
import com.google.common.collect.Lists;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
public class YeedocUtils {
    private static final Logger log = LoggerFactory.getLogger(YeedocUtils.class);
    private Configuration cfg;
    private final Map<String, CommonFormulaFunction> functionMap;
    private final YeedocService yeedocService;
    private final BusinessTableFieldsDAO businessTableFieldsDAO;

    @PostConstruct
    public void initCfg() {
        this.cfg = new Configuration(Configuration.VERSION_2_3_31);
        StringTemplateLoader stringLoader = new StringTemplateLoader();
        this.cfg.setTemplateLoader((TemplateLoader)stringLoader);
        this.cfg.setDefaultEncoding("UTF-8");
        this.functionMap.forEach((key, value) -> this.cfg.setSharedVariable(key.replace("TwFormulaFunction_", ""), (TemplateModel)value));
    }

    public String calculatePath(Map<String, Object> context, String formula) throws IOException, TemplateException {
        StringTemplateLoader stringLoader = (StringTemplateLoader)this.cfg.getTemplateLoader();
        stringLoader.putTemplate("myTemplate", formula);
        Template template = this.cfg.getTemplate("myTemplate");
        return FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, context);
    }

    public String saveYeedocFileByFieldConfig(Map<String, Object> context, String info) {
        if (info == null || info.isEmpty()) {
            return "";
        }
        JSONObject jsonObject = JSONObject.parseObject((String)info);
        JSONArray fileList = jsonObject.getJSONArray("fileList");
        JSONArray deleteList = jsonObject.getJSONArray("deleteList");
        String tableName = jsonObject.getString("tableName");
        String fieldName = jsonObject.getString("fieldName");
        ArrayList<String> fileCodes = new ArrayList<String>(fileList.stream().map(Object::toString).filter(it -> !it.contains("Ptcent_YiDoc_Item_WebApi_TempLoadFile")).toList());
        List<String> tempFileCodes = fileList.stream().map(Object::toString).filter(it -> it.contains("Ptcent_YiDoc_Item_WebApi_TempLoadFile")).toList();
        if (!tempFileCodes.isEmpty()) {
            JSONObject configJsonObject = this.getYeedocFieldConfig(tableName, fieldName);
            Map<String, String> tempFileMap = this.saveYeedocFile(context, configJsonObject.getString("formula"), configJsonObject.getString("libraryId"), tempFileCodes);
            List<String> newFileCodes = tempFileCodes.stream().map(tempFileMap::get).toList();
            fileCodes.addAll(newFileCodes);
        }
        List<String> toDeleteList = deleteList.stream().map(Object::toString).filter(it -> !it.contains("Ptcent_YiDoc_Item_WebApi_TempLoadFile")).toList();
        this.yeedocService.deleteItem(String.join((CharSequence)",", toDeleteList));
        return String.join((CharSequence)",", fileCodes);
    }

    public JSONObject getYeedocFieldConfig(String tablename, String fieldName) {
        BusinessTableFieldsVO businessTableFieldsVO = this.businessTableFieldsDAO.queryByTableNameAndFieldName(tablename, fieldName);
        if (ObjectUtils.isEmpty((Object)businessTableFieldsVO)) {
            throw TwException.error("", "\u4fdd\u5b58\u6613\u7a3b\u58f3\u9644\u4ef6\u65f6\uff0cbusinessTableFieldsVO\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String showType = businessTableFieldsVO.getShowType();
        if (!"ConfigYeedocFile".equals(showType)) {
            throw TwException.error("", "\u4fdd\u5b58\u6613\u7a3b\u58f3\u9644\u4ef6\u5931\u8d25\uff0c\u3010" + fieldName + "\u3011 \u5b57\u6bb5\u7c7b\u578b\u4e0d\u662f\u6613\u7a3b\u58f3\u9644\u4ef6\u7c7b\u578b!");
        }
        String showAttr = businessTableFieldsVO.getShowAttr();
        return JSONObject.parseObject((String)showAttr);
    }

    public Map<String, String> saveYeedocFile(Map<String, Object> context, String formula, String libraryId, List<String> cacheKeys) {
        if (CollectionUtils.isEmpty(cacheKeys)) {
            throw TwException.error("", "\u4fdd\u5b58\u6613\u7a3b\u58f3\u9644\u4ef6\u65f6\uff0ccacheKeys\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String authTokenByYdk = this.yeedocService.getYeedocJwt();
        String calculatePath = "";
        try {
            calculatePath = this.calculatePath(context, formula);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw TwException.error("", "\u4fdd\u5b58\u6613\u7a3b\u58f3\u9644\u4ef6\u65f6\uff0cformula\u8868\u8fbe\u5f0f\u89e3\u6790\u5931\u8d25!");
        }
        String ydkFolderId = this.createYdkFolder(Collections.singletonList(calculatePath), authTokenByYdk, libraryId);
        Map<String, String> cachekeyAndItemIdMap = this.saveYdkFile(ydkFolderId, new HashSet<String>(cacheKeys), authTokenByYdk, libraryId);
        return cachekeyAndItemIdMap;
    }

    private String createYdkFolder(List<String> pathArry, String authTokenByYdk, String libraryId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PathArry", pathArry);
        map.put("LibraryId", libraryId);
        log.info("[\u521b\u5efa\u6587\u4ef6\u5939-\u6613\u9053\u58f3\u5f00\u59cb]-map:{}", (Object)JSONObject.toJSONString(map));
        String resultStr = this.yeedocService.createFolder(map, authTokenByYdk);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)resultStr)) {
            log.info("[\u521b\u5efa\u6587\u4ef6\u5939-\u6613\u9053\u58f3]-map:{}", (Object)JSONObject.toJSONString(map));
            log.info("[\u521b\u5efa\u6587\u4ef6\u5939-\u6613\u9053\u58f3]-resultStr:{}", (Object)resultStr);
            throw TwException.error("", "\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25!result = {" + resultStr + "}");
        }
        JSONObject resultJson = JSONObject.parseObject((String)resultStr);
        log.info("[\u521b\u5efa\u6587\u4ef6\u5939-\u6613\u9053\u58f3\u8fd4\u56de\u503c]-resultJson:{}", (Object)resultJson);
        Object data = resultJson.get((Object)"Data");
        if (ObjectUtils.isEmpty((Object)data)) {
            throw TwException.error("", "\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25!result = {" + resultJson + "}");
        }
        JSONArray dataArray = JSONArray.parseArray((String)data.toString());
        String folderId = (String)JSONObject.parseObject((String)String.valueOf(dataArray.get(dataArray.size() - 1))).get((Object)"FolderId");
        if (!StringUtils.hasText((String)folderId)) {
            throw TwException.error("", "\u521b\u5efa\u6587\u4ef6\u5939\u8fd4\u56de\u503cfolderId\u4e3a\u7a7a!");
        }
        return folderId;
    }

    private Map<String, String> saveYdkFile(String ydkFolderId, Set<String> cacheKeys, String authTokenByYdk, String libraryId) {
        JSONObject itemIdResultJson;
        Object itemIdData;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (CollectionUtils.isEmpty(cacheKeys)) {
            return null;
        }
        map.put("FolderId", ydkFolderId);
        map.put("LibraryId", libraryId);
        map.put("CacheKey", cacheKeys);
        map.put("ItemList", Lists.newArrayList());
        map.put("AssociatedItemID", Lists.newArrayList());
        map.put("Description", "");
        log.info("[\u6700\u7ec8\u4fdd\u5b58\u9644\u4ef6-\u6613\u9053\u58f3\u5f00\u59cb]-map:{}", (Object)JSONObject.toJSONString(map));
        log.info("[\u6700\u7ec8\u4fdd\u5b58\u9644\u4ef6-\u6613\u9053\u58f3\u5f00\u59cb]-authTokenByYdk:{}", (Object)authTokenByYdk);
        String resultStr = this.yeedocService.newUploadFilesSave(map, authTokenByYdk);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)resultStr)) {
            log.info("[\u6700\u7ec8\u4fdd\u5b58\u9644\u4ef6-\u6613\u9053\u58f3]-resultStr:{}", (Object)resultStr);
            throw TwException.error("", "\u6700\u7ec8\u4fdd\u5b58\u9644\u4ef6\u5931\u8d25!result = {" + resultStr + "}");
        }
        JSONObject resultJson = JSONObject.parseObject((String)resultStr);
        log.info("[\u6700\u7ec8\u4fdd\u5b58\u9644\u4ef6-\u6613\u9053\u58f3\u8fd4\u56de\u503c]-resultJson:{}", (Object)resultJson);
        Boolean isSuccess = resultJson.getBoolean("IsSuccess");
        String message = resultJson.getString("Message");
        if (!isSuccess.booleanValue() || !"\u4e0a\u4f20\u6210\u529f\uff01".equals(message)) {
            throw TwException.error("", "\u6700\u7ec8\u4fdd\u5b58\u9644\u4ef6\u5931\u8d25!result = {" + resultJson + "}");
        }
        HashMap<String, Object> getItemMap = new HashMap<String, Object>();
        getItemMap.put("CacheKeys", cacheKeys);
        log.info("[\u83b7\u53d6\u6613\u9053\u58f3\u9644\u4ef6id-\u6613\u9053\u58f3\u5f00\u59cb]-map:{}", (Object)JSONObject.toJSONString(getItemMap));
        log.info("[\u83b7\u53d6\u6613\u9053\u58f3\u9644\u4ef6id-\u6613\u9053\u58f3\u5f00\u59cb]-authTokenByYdk:{}", (Object)authTokenByYdk);
        String itemIdResult = this.yeedocService.getCaCheKeyItemId(getItemMap, authTokenByYdk);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)itemIdResult)) {
            log.info("[\u83b7\u53d6\u6613\u9053\u58f3\u9644\u4ef6id-\u6613\u9053\u58f3]-resultStr:{}", (Object)itemIdResult);
        }
        if (ObjectUtils.isEmpty((Object)(itemIdData = (itemIdResultJson = JSONObject.parseObject((String)itemIdResult)).get((Object)"Data")))) {
            throw TwException.error("", "\u83b7\u53d6\u6613\u9053\u58f3\u9644\u4ef6id\u5931\u8d25!result = {" + itemIdResultJson + "}");
        }
        List itemIdJsonObjectList = JSONArray.parseArray((String)itemIdData.toString()).toJavaList(JSONObject.class);
        Map<String, String> resultMap = itemIdJsonObjectList.stream().filter(Objects::nonNull).collect(Collectors.toMap(item -> item.getString("CacheKey"), item -> item.getString("ItemId")));
        return resultMap;
    }

    public List<YeedocFileVO> getYeedocFile(List<String> fileCodes) {
        JSONObject allItemsInfotJson;
        Object data;
        String allItemsInfo = this.yeedocService.getAllItemsInfo(fileCodes);
        if (!StringUtils.hasText((String)allItemsInfo)) {
            log.info("[\u83b7\u53d6\u6613\u9053\u58f3\u9644\u4ef6-\u6613\u9053\u58f3]-resultStr:{}", (Object)allItemsInfo);
        }
        if (ObjectUtils.isEmpty((Object)(data = (allItemsInfotJson = JSONObject.parseObject((String)allItemsInfo)).get((Object)"Data")))) {
            throw TwException.error("", "\u83b7\u53d6\u6613\u9053\u58f3\u9644\u4ef6\u5931\u8d25!result = {" + allItemsInfotJson + "}");
        }
        List yeedocFileVO = JSONArray.parseArray((String)String.valueOf(data), YeedocFileVO.class);
        return yeedocFileVO;
    }

    public YeedocUtils(Map<String, CommonFormulaFunction> functionMap, YeedocService yeedocService, BusinessTableFieldsDAO businessTableFieldsDAO) {
        this.functionMap = functionMap;
        this.yeedocService = yeedocService;
        this.businessTableFieldsDAO = businessTableFieldsDAO;
    }
}

