/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.acc.service;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSourceDetailPayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSourcePayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSourceRecordPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSourceRecordQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSourceRecordService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSourceRecordVO;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimSourceRecordConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimSourceRecordDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSourceRecordDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSourceRecordRepo;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class AccReimSourceRecordServiceImpl
extends BaseServiceImpl
implements AccReimSourceRecordService {
    private static final Logger log = LoggerFactory.getLogger(AccReimSourceRecordServiceImpl.class);
    private final AccReimSourceRecordRepo repo;
    private final AccReimSourceRecordDAO dao;
    private final FileUtil fileUtil;

    public PagingVO<AccReimSourceRecordVO> queryPaging(AccReimSourceRecordQuery query) {
        return this.dao.queryPaging(query);
    }

    public List<AccReimSourceRecordVO> queryListDynamic(AccReimSourceRecordQuery query) {
        List<AccReimSourceRecordVO> vos = this.dao.queryListDynamic(query);
        if (ObjectUtils.isEmpty(vos)) {
            log.warn("\u5f53\u524d\u67e5\u8be2\u4fe1\u606f {} \u83b7\u53d6\u7684\u62a5\u9500\u91d1\u989d\u6765\u6e90\u8bb0\u5f55\u4e3a\u7a7a", (Object)query);
            return vos;
        }
        vos.forEach(vo -> {
            AccReimSourcePayload accReimSourcePayload = (AccReimSourcePayload)JSON.parseObject((String)vo.getContent(), AccReimSourcePayload.class);
            List details = accReimSourcePayload.getDetails();
            if (!CollectionUtils.isEmpty((Collection)details)) {
                for (AccReimSourceDetailPayload detail : details) {
                    if (!StringUtils.hasText((String)detail.getFileCodes())) continue;
                    detail.setFileDates(this.fileUtil.getFileDatas(detail.getFileCodes()));
                }
            }
            vo.setSource(accReimSourcePayload);
        });
        return vos;
    }

    public AccReimSourceRecordVO queryByKey(Long key) {
        return this.dao.queryByKey(key);
    }

    @Transactional
    public AccReimSourceRecordVO insert(AccReimSourceRecordPayload payload) {
        String content = JSON.toJSONString((Object)payload.getSource());
        payload.setContent(content);
        AccReimSourceRecordDO entityDo = AccReimSourceRecordConvert.INSTANCE.toDo(payload);
        return AccReimSourceRecordConvert.INSTANCE.toVo((AccReimSourceRecordDO)this.repo.save(entityDo));
    }

    @Transactional
    public AccReimSourceRecordVO update(AccReimSourceRecordPayload payload) {
        AccReimSourceRecordDO entity = this.repo.findById(payload.getId()).orElseGet(AccReimSourceRecordDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        AccReimSourceRecordDO entityDo = AccReimSourceRecordConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return AccReimSourceRecordConvert.INSTANCE.toVo((AccReimSourceRecordDO)this.repo.save(entity));
    }

    @Transactional
    public long updateByKeyDynamic(AccReimSourceRecordPayload payload) {
        AccReimSourceRecordDO entity = this.repo.findById(payload.getId()).orElseGet(AccReimSourceRecordDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.dao.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.dao.deleteSoft(keys);
        }
    }

    @Transactional
    public void delByReimId(Long reimId) {
        this.dao.delByReimId(reimId);
    }

    public AccReimSourceRecordServiceImpl(AccReimSourceRecordRepo repo, AccReimSourceRecordDAO dao, FileUtil fileUtil) {
        this.repo = repo;
        this.dao = dao;
        this.fileUtil = fileUtil;
    }
}

